/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.helpers.NodeComparator;
import de.fraunhofer.aisec.cpg.helpers.TriConsumer;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubgraphWalker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubgraphWalker.class);

    private SubgraphWalker() {
    }

    private static Collection<Field> getAllFields(Class<?> classType) {
        if (classType.getSuperclass() != null) {
            Collection<Field> fields = SubgraphWalker.getAllFields(classType.getSuperclass());
            fields.addAll(Arrays.asList(classType.getDeclaredFields()));
            return fields;
        }
        return new ArrayList<Field>();
    }

    public static Set<Node> getAstChildren(Node node) {
        LinkedHashSet<Node> children = new LinkedHashSet<Node>();
        if (node == null) {
            return children;
        }
        Class<?> classType = node.getClass();
        for (Field field2 : SubgraphWalker.getAllFields(classType)) {
            SubGraph subGraph = field2.getAnnotation(SubGraph.class);
            if (subGraph == null || !Arrays.asList(subGraph.value()).contains("AST")) continue;
            try {
                field2.trySetAccessible();
                Object obj = field2.get(node);
                field2.setAccessible(false);
                if (obj == null) continue;
                boolean outgoing = true;
                if (field2.getAnnotation(Relationship.class) != null) {
                    outgoing = field2.getAnnotation(Relationship.class).direction().equals("OUTGOING");
                }
                if (PropertyEdge.checkForPropertyEdge(field2, obj)) {
                    obj = PropertyEdge.unwrapPropertyEdge(obj, outgoing);
                }
                if (obj instanceof Node) {
                    children.add((Node)obj);
                    continue;
                }
                if (obj instanceof Collection) {
                    Collection astChildren = (Collection)obj;
                    astChildren.removeIf(Objects::isNull);
                    children.addAll(astChildren);
                    continue;
                }
                throw new AnnotationFormatError("Found @SubGraph(\"AST\") on field of type " + obj.getClass() + " but can only used with node graph classes or collections of graph nodes");
            }
            catch (IllegalAccessException ex) {
                LOGGER.error("Error while retrieving AST children: {}", (Object)ex.getMessage());
            }
        }
        return children;
    }

    public static List<Node> flattenAST(Node n) {
        if (n == null) {
            return new ArrayList<Node>();
        }
        HashSet<Node> list = new HashSet<Node>();
        SubgraphWalker.flattenASTInternal(list, n);
        ArrayList<Node> ret = new ArrayList<Node>(list);
        ret.sort(new NodeComparator());
        return ret;
    }

    private static void flattenASTInternal(@NonNull Set<Node> list, @NonNull Node n) {
        list.add(n);
        for (Node child : SubgraphWalker.getAstChildren(n)) {
            if (list.contains(child)) continue;
            SubgraphWalker.flattenASTInternal(list, child);
        }
    }

    public static Border getEOGPathEdges(Node n) {
        Border border = new Border();
        List<Node> flattedASTTree = SubgraphWalker.flattenAST(n);
        List eogNodes = flattedASTTree.stream().filter(node -> !node.getPrevEOG().isEmpty() || !node.getNextEOG().isEmpty()).collect(Collectors.toList());
        border.entries = eogNodes.stream().filter(node -> node.getPrevEOG().stream().anyMatch(prev -> !eogNodes.contains(prev))).collect(Collectors.toList());
        border.exits = eogNodes.stream().filter(node -> node.getNextEOG().stream().anyMatch(next -> !eogNodes.contains(next))).collect(Collectors.toList());
        return border;
    }

    public static class ScopedWalker {
        private Map<Node, Pair<Node, List<ValueDeclaration>>> nodeToParentBlockAndContainedValueDeclarations = new IdentityHashMap<Node, Pair<Node, List<ValueDeclaration>>>();
        private Deque<RecordDeclaration> currentClass = new ArrayDeque<RecordDeclaration>();
        private IterativeGraphWalker walker;
        private LanguageFrontend lang;
        private List<TriConsumer<RecordDeclaration, Node, Node>> handlers = new ArrayList<TriConsumer<RecordDeclaration, Node, Node>>();

        public ScopedWalker(LanguageFrontend lang) {
            this.lang = lang;
        }

        public void clearCallbacks() {
            this.handlers.clear();
        }

        public void registerHandler(TriConsumer<RecordDeclaration, Node, Node> handler) {
            this.handlers.add(handler);
        }

        public void registerHandler(BiConsumer<Node, RecordDeclaration> handler) {
            this.handlers.add((currClass, parent, currNode) -> handler.accept((Node)currNode, (RecordDeclaration)currClass));
        }

        public void iterate(Node root) {
            this.walker = new IterativeGraphWalker();
            this.handlers.forEach(h2 -> this.walker.registerOnNodeVisit(n -> this.handleNode((Node)n, (TriConsumer<RecordDeclaration, Node, Node>)h2)));
            this.walker.registerOnScopeExit(this::leaveScope);
            this.walker.iterate(root);
        }

        private void handleNode(Node current, TriConsumer<RecordDeclaration, Node, Node> handler) {
            RecordDeclaration recordDeclaration;
            this.lang.getScopeManager().enterScopeIfExists(current);
            Node parent = this.walker.getBacklog().peek();
            if (current instanceof RecordDeclaration && current != this.currentClass.peek()) {
                this.currentClass.push((RecordDeclaration)current);
            }
            if (current instanceof MethodDeclaration && (recordDeclaration = ((MethodDeclaration)current).getRecordDeclaration()) != null && recordDeclaration != this.currentClass.peek()) {
                this.currentClass.push(recordDeclaration);
            }
            handler.accept(this.currentClass.peek(), parent, current);
        }

        private void leaveScope(Node exiting) {
            if (exiting instanceof RecordDeclaration) {
                this.currentClass.pop();
            }
            this.lang.getScopeManager().leaveScope(exiting);
        }

        public @Nullable RecordDeclaration getCurrentClass() {
            return this.currentClass.isEmpty() ? null : this.currentClass.peek();
        }

        public void collectDeclarations(Node current) {
            Node parentBlock = null;
            for (Node node : this.walker.getBacklog()) {
                if (!(node instanceof RecordDeclaration) && !(node instanceof CompoundStatement) && !(node instanceof FunctionDeclaration) && !(node instanceof TranslationUnitDeclaration)) continue;
                parentBlock = node;
                break;
            }
            this.nodeToParentBlockAndContainedValueDeclarations.put(current, new MutablePair(parentBlock, new ArrayList()));
            if (current instanceof ValueDeclaration) {
                LOGGER.trace("Adding variable {}", (Object)current.getCode());
                if (parentBlock == null) {
                    LOGGER.warn("Parent block is empty during subgraph run");
                } else {
                    this.nodeToParentBlockAndContainedValueDeclarations.get(parentBlock).getRight().add((ValueDeclaration)current);
                }
            }
        }

        public List<ValueDeclaration> getAllDeclarationsForScope(Node scope) {
            ArrayList<ValueDeclaration> result = new ArrayList<ValueDeclaration>();
            Node currentScope = scope;
            HashSet<String> scopedVars = new HashSet<String>();
            while (currentScope != null && this.nodeToParentBlockAndContainedValueDeclarations.containsKey(scope)) {
                Pair<Node, List<ValueDeclaration>> entry = this.nodeToParentBlockAndContainedValueDeclarations.get(currentScope);
                for (ValueDeclaration val : entry.getRight()) {
                    if (!(val instanceof FunctionDeclaration) && scopedVars.contains(val.getName())) continue;
                    result.add(val);
                    scopedVars.add(val.getName());
                }
                currentScope = entry.getLeft();
            }
            return result;
        }

        public Optional<? extends ValueDeclaration> getDeclarationForScope(Node scope, Predicate<ValueDeclaration> predicate2) {
            Node currentScope = scope;
            while (currentScope != null && this.nodeToParentBlockAndContainedValueDeclarations.containsKey(scope)) {
                Pair<Node, List<ValueDeclaration>> entry = this.nodeToParentBlockAndContainedValueDeclarations.get(currentScope);
                for (ValueDeclaration val : entry.getRight()) {
                    if (!predicate2.test(val)) continue;
                    return Optional.of(val);
                }
                currentScope = entry.getLeft();
            }
            return Optional.empty();
        }
    }

    public static class IterativeGraphWalker {
        private Deque<Node> todo;
        private Deque<Node> backlog;
        private List<Consumer<Node>> onNodeVisit = new ArrayList<Consumer<Node>>();
        private List<Consumer<Node>> onScopeExit = new ArrayList<Consumer<Node>>();

        public void iterate(Node root) {
            this.todo = new ArrayDeque<Node>();
            this.backlog = new ArrayDeque<Node>();
            LinkedHashSet seen = new LinkedHashSet();
            this.todo.push(root);
            while (!this.todo.isEmpty()) {
                Node current = this.todo.pop();
                if (!this.backlog.isEmpty() && this.backlog.peek().equals(current)) {
                    Node exiting = this.backlog.pop();
                    this.onScopeExit.forEach(c -> c.accept(exiting));
                    continue;
                }
                this.todo.push(current);
                this.onNodeVisit.forEach(c -> c.accept(current));
                Set unseenChildren = SubgraphWalker.getAstChildren(current).stream().filter(Predicate.not(seen::contains)).collect(Collectors.toSet());
                seen.addAll(unseenChildren);
                Util.reverse(unseenChildren.stream()).forEach(this.todo::push);
                this.backlog.push(current);
            }
        }

        public void registerOnNodeVisit(Consumer<Node> callback) {
            this.onNodeVisit.add(callback);
        }

        public void registerOnScopeExit(Consumer<Node> callback) {
            this.onScopeExit.add(callback);
        }

        public void clearCallbacks() {
            this.onNodeVisit.clear();
            this.onScopeExit.clear();
        }

        public Deque<Node> getTodo() {
            return this.todo;
        }

        public Deque<Node> getBacklog() {
            return this.backlog;
        }
    }

    public static class Border {
        private List<Node> entries = new ArrayList<Node>();
        private List<Node> exits = new ArrayList<Node>();

        public List<Node> getEntries() {
            return this.entries;
        }

        public List<Node> getExits() {
            return this.exits;
        }
    }
}

