/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;

public class LocationConverter
implements CompositeAttributeConverter<PhysicalLocation> {
    public static final String START_LINE = "startLine";
    public static final String END_LINE = "endLine";
    public static final String START_COLUMN = "startColumn";
    public static final String END_COLUMN = "endColumn";
    public static final String ARTIFACT = "artifact";

    @Override
    public Map<String, ?> toGraphProperties(PhysicalLocation value) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (value != null) {
            properties.put(ARTIFACT, value.getArtifactLocation().getUri().toString());
            properties.put(START_LINE, value.getRegion().getStartLine());
            properties.put(END_LINE, value.getRegion().getEndLine());
            properties.put(START_COLUMN, value.getRegion().getStartColumn());
            properties.put(END_COLUMN, value.getRegion().getEndColumn());
        }
        return properties;
    }

    @Override
    public PhysicalLocation toEntityAttribute(Map<String, ?> value) {
        try {
            int startLine = this.toInt(value.get(START_LINE));
            int endLine = this.toInt(value.get(END_LINE));
            int startColumn = this.toInt(value.get(START_COLUMN));
            int endColumn = this.toInt(value.get(END_COLUMN));
            URI uri = URI.create((String)value.get(ARTIFACT));
            return new PhysicalLocation(uri, new Region(startLine, startColumn, endLine, endColumn));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private int toInt(Object objectToMap) {
        long value = Long.parseLong(objectToMap.toString());
        return Math.toIntExact(value);
    }
}

