/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class CompoundStatement
extends Statement {
    @Relationship(value="STATEMENTS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private @NonNull List<PropertyEdge<Statement>> statements = new ArrayList<PropertyEdge<Statement>>();

    public @NonNull List<Statement> getStatements() {
        ArrayList<Statement> targets = new ArrayList<Statement>();
        for (PropertyEdge<Statement> propertyEdge : this.statements) {
            targets.add(propertyEdge.getEnd());
        }
        return Collections.unmodifiableList(targets);
    }

    public @NonNull List<PropertyEdge<Statement>> getStatementsPropertyEdge() {
        return this.statements;
    }

    public void setStatements(@NonNull List<Statement> statements) {
        this.statements = PropertyEdge.transformIntoOutgoingPropertyEdgeList(statements, this);
    }

    public @NonNull List<PropertyEdge<Statement>> getStatementEdges() {
        return this.statements;
    }

    public void addStatement(Statement s2) {
        PropertyEdge<Statement> propertyEdge = new PropertyEdge<Statement>(this, s2);
        propertyEdge.addProperty(Properties.INDEX, this.statements.size());
        this.statements.add(propertyEdge);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompoundStatement)) {
            return false;
        }
        CompoundStatement that = (CompoundStatement)o;
        return super.equals(that) && Objects.equals(this.getStatements(), that.getStatements()) && PropertyEdge.propertyEqualsList(this.statements, that.statements);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

