/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.edge;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Persistable;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdgeConverter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RelationshipEntity
public class PropertyEdge<T extends Node>
implements Persistable {
    @Id
    @GeneratedValue
    private Long id;
    protected static final Logger log = LoggerFactory.getLogger(PropertyEdge.class);
    @StartNode
    private Node start;
    @EndNode
    private T end;
    @Convert(value=PropertyEdgeConverter.class)
    private Map<Properties, Object> properties;

    public PropertyEdge(Node start, T end) {
        this.start = start;
        this.end = end;
        this.properties = new EnumMap<Properties, Object>(Properties.class);
    }

    public PropertyEdge(PropertyEdge<T> propertyEdge) {
        this.start = propertyEdge.start;
        this.end = propertyEdge.end;
        this.properties = new EnumMap<Properties, Object>(Properties.class);
        this.properties.putAll(propertyEdge.properties);
    }

    public PropertyEdge(Node start, T end, Map<Properties, Object> properties) {
        this.start = start;
        this.end = end;
        this.properties = properties;
    }

    public static <S extends PropertyEdge<?>> List<S> findPropertyEdgesByPredicate(Collection<S> edges, Predicate<S> predicate2) {
        return edges.stream().filter(predicate2).collect(Collectors.toList());
    }

    public Object getProperty(Properties property) {
        return this.properties.getOrDefault((Object)property, null);
    }

    public void addProperty(Properties property, Object value) {
        this.properties.put(property, value);
    }

    public void addProperties(Map<Properties, Object> propertyMap) {
        this.properties.putAll(propertyMap);
    }

    public T getEnd() {
        return this.end;
    }

    public Node getStart() {
        return this.start;
    }

    public void setEnd(T end) {
        this.end = end;
    }

    public void setStart(Node start) {
        this.start = start;
    }

    public static <T extends Node> List<PropertyEdge<T>> applyIndexProperty(List<PropertyEdge<T>> propertyEdges) {
        int counter = 0;
        for (PropertyEdge<T> propertyEdge : propertyEdges) {
            propertyEdge.addProperty(Properties.INDEX, counter);
            ++counter;
        }
        return propertyEdges;
    }

    public static <T extends Node> List<PropertyEdge<T>> transformIntoOutgoingPropertyEdgeList(List<T> nodes, Node commonRelationshipNode) {
        ArrayList<PropertyEdge<T>> propertyEdges = new ArrayList<PropertyEdge<T>>();
        for (Node n : nodes) {
            propertyEdges.add(new PropertyEdge<Node>(commonRelationshipNode, n));
        }
        return propertyEdges;
    }

    public static <T extends Node> List<PropertyEdge<T>> transformIntoIncomingPropertyEdgeList(List<? extends Node> nodes, T commonRelationshipNode) {
        ArrayList<PropertyEdge<T>> propertyEdges = new ArrayList<PropertyEdge<T>>();
        for (Node node : nodes) {
            propertyEdges.add(new PropertyEdge<T>(node, commonRelationshipNode));
        }
        return propertyEdges;
    }

    public static <T extends Node> List<T> unwrap(@NonNull List<PropertyEdge<T>> collection) {
        return PropertyEdge.unwrap(collection, true);
    }

    public static <T extends Node> List<T> unwrap(@NonNull List<PropertyEdge<T>> collection, boolean outgoing) {
        return collection.stream().map(edge -> outgoing ? edge.getEnd() : edge.getStart()).collect(Collectors.toUnmodifiableList());
    }

    private static Object unwrapPropertyEdgeCollection(Collection<?> collection, boolean outgoing) {
        Object element = null;
        Optional<?> value = collection.stream().findAny();
        if (value.isPresent()) {
            element = value.get();
        }
        if (element instanceof PropertyEdge) {
            try {
                Collection outputCollection = (Collection)collection.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Object obj : collection) {
                    if (!(obj instanceof PropertyEdge)) continue;
                    PropertyEdge propertyEdge = (PropertyEdge)obj;
                    if (outgoing) {
                        outputCollection.add(propertyEdge.getEnd());
                        continue;
                    }
                    outputCollection.add(propertyEdge.getStart());
                }
                return outputCollection;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("PropertyEdges could not be unwrapped");
            }
        }
        return collection;
    }

    public static Object unwrapPropertyEdge(Object obj, boolean outgoing) {
        if (obj instanceof PropertyEdge) {
            if (outgoing) {
                return ((PropertyEdge)obj).getEnd();
            }
            return ((PropertyEdge)obj).getStart();
        }
        if (obj instanceof Collection && !((Collection)obj).isEmpty()) {
            return PropertyEdge.unwrapPropertyEdgeCollection((Collection)obj, outgoing);
        }
        return obj;
    }

    public static boolean checkForPropertyEdge(Field f, Object obj) {
        if (obj instanceof PropertyEdge) {
            return true;
        }
        if (obj instanceof Collection) {
            List<Type> collectionTypes = List.of(((ParameterizedType)f.getGenericType()).getActualTypeArguments());
            for (Type t : collectionTypes) {
                if (t instanceof ParameterizedType) {
                    return ((ParameterizedType)t).getRawType().equals(PropertyEdge.class);
                }
                if (!PropertyEdge.class.equals((Object)t)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends Node> List<T> getTarget(List<PropertyEdge<T>> propertyEdges) {
        ArrayList<T> targets = new ArrayList<T>();
        for (PropertyEdge<T> propertyEdge : propertyEdges) {
            targets.add(propertyEdge.getEnd());
        }
        return targets;
    }

    public static <T extends Node> List<Node> getSource(List<PropertyEdge<T>> propertyEdges) {
        ArrayList<Node> targets = new ArrayList<Node>();
        for (PropertyEdge<T> propertyEdge : propertyEdges) {
            targets.add(propertyEdge.getStart());
        }
        return targets;
    }

    public static <T extends Node> List<PropertyEdge<T>> removeElementFromList(List<PropertyEdge<T>> propertyEdges, T element, boolean end) {
        ArrayList<PropertyEdge<T>> newPropertyEdges = new ArrayList<PropertyEdge<T>>();
        for (PropertyEdge<T> propertyEdge : propertyEdges) {
            if (end && !((Node)propertyEdge.getEnd()).equals(element)) {
                newPropertyEdges.add(propertyEdge);
            }
            if (end || propertyEdge.getStart().equals(element)) continue;
            newPropertyEdges.add(propertyEdge);
        }
        return PropertyEdge.applyIndexProperty(newPropertyEdges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyEdge)) {
            return false;
        }
        PropertyEdge propertyEdge = (PropertyEdge)obj;
        return Objects.equals(this.properties, propertyEdge.properties) && this.start.equals(propertyEdge.getStart()) && ((Node)this.end).equals(propertyEdge.getEnd());
    }

    public boolean propertyEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyEdge)) {
            return false;
        }
        PropertyEdge propertyEdge = (PropertyEdge)obj;
        return Objects.equals(this.properties, propertyEdge.properties);
    }

    public static <E extends Node> boolean propertyEqualsList(List<PropertyEdge<E>> propertyEdges, List<PropertyEdge<E>> propertyEdges2) {
        if (propertyEdges.size() == propertyEdges2.size()) {
            for (int i = 0; i < propertyEdges.size(); ++i) {
                if (propertyEdges.get(i).propertyEquals(propertyEdges2.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.end, this.properties);
    }
}

