/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class DeclarationSequence
extends Declaration
implements DeclarationHolder {
    @Relationship(value="CHILDREN", direction="OUTGOING")
    private final List<PropertyEdge<Declaration>> children = new ArrayList<PropertyEdge<Declaration>>();

    public List<PropertyEdge<Declaration>> getChildrenPropertyEdge() {
        return this.children;
    }

    public List<Declaration> getChildren() {
        ArrayList<Declaration> target = new ArrayList<Declaration>();
        for (PropertyEdge<Declaration> propertyEdge : this.children) {
            target.add(propertyEdge.getEnd());
        }
        return Collections.unmodifiableList(target);
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof DeclarationSequence) {
            for (Declaration declarationChild : ((DeclarationSequence)declaration).getChildren()) {
                this.addIfNotContains(this.children, declarationChild);
            }
        }
        this.addIfNotContains(this.children, declaration);
    }

    public List<Declaration> asList() {
        return this.getChildren();
    }

    public boolean isSingle() {
        return this.children.size() == 1;
    }

    public Declaration first() {
        return this.children.get(0).getEnd();
    }
}

