/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.golang.GoLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.python.PythonLanguageFrontend;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LanguageFrontendFactory {
    private static final List<String> JAVA_EXTENSIONS = List.of(".java");
    public static final List<String> CXX_EXTENSIONS = List.of(".c", ".cpp", ".cc");
    private static final List<String> CXX_HEADER_EXTENSIONS = List.of(".h", ".hpp");
    private static final List<String> PYTHON_EXTENSIONS = List.of(".py");
    private static final List<String> GOLANG_EXTENSIONS = List.of(".go");

    private LanguageFrontendFactory() {
    }

    public static @Nullable LanguageFrontend getFrontend(String fileType, TranslationConfiguration config, ScopeManager scopeManager) {
        if (JAVA_EXTENSIONS.contains(fileType)) {
            return new JavaLanguageFrontend(config, scopeManager);
        }
        if (CXX_EXTENSIONS.contains(fileType) || CXX_HEADER_EXTENSIONS.contains(fileType)) {
            return new CXXLanguageFrontend(config, scopeManager);
        }
        if (PYTHON_EXTENSIONS.contains(fileType)) {
            return new PythonLanguageFrontend(config, scopeManager);
        }
        if (GOLANG_EXTENSIONS.contains(fileType)) {
            return new GoLanguageFrontend(config, scopeManager);
        }
        return null;
    }
}

