/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.neo4j.ogm.annotation.Relationship;

public class ObjectType
extends Type {
    private final Modifier modifier;
    private RecordDeclaration recordDeclaration = null;
    @Relationship(value="GENERICS", direction="OUTGOING")
    private List<PropertyEdge<Type>> generics;

    public ObjectType(String typeName, Type.Storage storage, Type.Qualifier qualifier, List<Type> generics, Modifier modifier, boolean primitive) {
        super(typeName, storage, qualifier);
        this.generics = PropertyEdge.transformIntoOutgoingPropertyEdgeList(generics, this);
        this.modifier = modifier;
        this.primitive = primitive;
    }

    public ObjectType(Type type, List<Type> generics, Modifier modifier, boolean primitive) {
        super(type);
        this.generics = PropertyEdge.transformIntoOutgoingPropertyEdgeList(generics, this);
        this.modifier = modifier;
        this.primitive = primitive;
    }

    public ObjectType() {
        this.generics = new ArrayList<PropertyEdge<Type>>();
        this.modifier = Modifier.NOT_APPLICABLE;
        this.primitive = false;
    }

    public List<Type> getGenerics() {
        ArrayList<Type> genericValues = new ArrayList<Type>();
        for (PropertyEdge<Type> edge : this.generics) {
            genericValues.add(edge.getEnd());
        }
        return Collections.unmodifiableList(genericValues);
    }

    public List<PropertyEdge<Type>> getGenericPropertyEdges() {
        return this.generics;
    }

    public RecordDeclaration getRecordDeclaration() {
        return this.recordDeclaration;
    }

    public void setRecordDeclaration(RecordDeclaration recordDeclaration) {
        this.recordDeclaration = recordDeclaration;
    }

    @Override
    public PointerType reference(PointerType.PointerOrigin pointerOrigin) {
        return new PointerType(this, pointerOrigin);
    }

    @Override
    public Type dereference() {
        return UnknownType.getUnknownType();
    }

    @Override
    public Type duplicate() {
        return new ObjectType(this, this.getGenerics(), this.modifier, this.primitive);
    }

    public void setGenerics(List<Type> generics) {
        this.generics = PropertyEdge.transformIntoOutgoingPropertyEdgeList(generics, this);
    }

    public void addGeneric(Type generic) {
        PropertyEdge<Type> propertyEdge = new PropertyEdge<Type>(this, generic);
        this.generics.add(propertyEdge);
    }

    @Override
    public boolean isSimilar(Type t) {
        return t instanceof ObjectType && this.getGenerics().equals(((ObjectType)t).getGenerics()) && super.isSimilar(t);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        return Objects.equals(this.generics, that.generics) && Objects.equals(this.getGenerics(), that.getGenerics()) && this.primitive == that.primitive && this.modifier.equals((Object)that.modifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.generics, this.modifier, this.primitive});
    }

    @Override
    public String toString() {
        return "ObjectType{generics=" + this.generics + ", typeName='" + this.name + "', storage=" + this.getStorage() + ", qualifier=" + this.getQualifier() + ", modifier=" + this.modifier + ", primitive=" + this.primitive + ", origin=" + this.getTypeOrigin() + "}";
    }

    public static enum Modifier {
        SIGNED,
        UNSIGNED,
        NOT_APPLICABLE;

    }
}

