/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.PopulatedByPass;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Relationship;

public class ConstructExpression
extends Expression
implements HasType.TypeListener {
    @PopulatedByPass(value=CallResolver.class)
    private ConstructorDeclaration constructor;
    @PopulatedByPass(value=CallResolver.class)
    private Declaration instantiates;
    @Relationship(value="ARGUMENTS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Expression>> arguments = new ArrayList<PropertyEdge<Expression>>();

    public Declaration getInstantiates() {
        return this.instantiates;
    }

    public void setInstantiates(Declaration instantiates) {
        this.instantiates = instantiates;
        if (instantiates != null) {
            this.setType(TypeParser.createFrom(instantiates.getName(), true));
        }
    }

    public ConstructorDeclaration getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorDeclaration constructor) {
        if (this.constructor != null) {
            this.constructor.unregisterTypeListener(this);
            Util.detachCallParameters(this.constructor, this.getArguments());
            this.removePrevDFG(this.constructor);
        }
        this.constructor = constructor;
        if (constructor != null) {
            constructor.registerTypeListener(this);
            Util.attachCallParameters(constructor, this.getArguments());
            this.addPrevDFG(constructor);
        }
    }

    public List<Expression> getArguments() {
        return PropertyEdge.unwrap(this.arguments);
    }

    public List<PropertyEdge<Expression>> getArgumentsPropertyEdge() {
        return this.arguments;
    }

    public void setArguments(List<Expression> arguments) {
        this.arguments = PropertyEdge.transformIntoOutgoingPropertyEdgeList(arguments, this);
    }

    public void addArgument(Expression argument) {
        PropertyEdge<Expression> propertyEdge = new PropertyEdge<Expression>(this, argument);
        propertyEdge.addProperty(Properties.INDEX, this.arguments.size());
        this.arguments.add(propertyEdge);
    }

    public List<Type> getSignature() {
        return this.getArguments().stream().map(Expression::getType).collect(Collectors.toList());
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        this.setType(src.getPropagationType(), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("constructor", (Object)this.constructor).append("instantiates", (Object)this.instantiates).append("arguments", this.arguments).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructExpression)) {
            return false;
        }
        ConstructExpression that = (ConstructExpression)o;
        return super.equals(that) && Objects.equals(this.constructor, that.constructor) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.getArguments(), that.getArguments());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

