/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements;

import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class TryStatement
extends Statement {
    @Relationship(value="RESOURCES", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Statement>> resources = new ArrayList<PropertyEdge<Statement>>();
    @SubGraph(value={"AST"})
    private CompoundStatement tryBlock;
    @SubGraph(value={"AST"})
    private CompoundStatement finallyBlock;
    @Relationship(value="CATCH_CLAUSES", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<CatchClause>> catchClauses = new ArrayList<PropertyEdge<CatchClause>>();

    public @NonNull List<Statement> getResources() {
        return PropertyEdge.unwrap(this.resources);
    }

    public List<PropertyEdge<Statement>> getResourcesPropertyEdge() {
        return this.resources;
    }

    public void setResources(List<Statement> resources) {
        this.resources = new ArrayList<PropertyEdge<Statement>>();
        int c = 0;
        for (Statement s : resources) {
            PropertyEdge<Statement> propertyEdge = new PropertyEdge<Statement>(this, s);
            propertyEdge.addProperty(Properties.INDEX, c);
            this.resources.add(propertyEdge);
            ++c;
        }
    }

    public CompoundStatement getTryBlock() {
        return this.tryBlock;
    }

    public void setTryBlock(CompoundStatement tryBlock) {
        this.tryBlock = tryBlock;
    }

    public CompoundStatement getFinallyBlock() {
        return this.finallyBlock;
    }

    public void setFinallyBlock(CompoundStatement finallyBlock) {
        this.finallyBlock = finallyBlock;
    }

    public @NonNull List<CatchClause> getCatchClauses() {
        return PropertyEdge.unwrap(this.catchClauses);
    }

    public List<PropertyEdge<CatchClause>> getCatchClausesPropertyEdge() {
        return this.catchClauses;
    }

    public void setCatchClauses(List<CatchClause> catchClauses) {
        this.catchClauses = new ArrayList<PropertyEdge<CatchClause>>();
        int counter = 0;
        for (CatchClause c : catchClauses) {
            PropertyEdge<CatchClause> propertyEdge = new PropertyEdge<CatchClause>(this, c);
            propertyEdge.addProperty(Properties.INDEX, counter);
            this.catchClauses.add(propertyEdge);
            ++counter;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TryStatement)) {
            return false;
        }
        TryStatement that = (TryStatement)o;
        return super.equals(that) && Objects.equals(this.resources, that.resources) && Objects.equals(this.getResources(), that.getResources()) && Objects.equals(this.tryBlock, that.tryBlock) && Objects.equals(this.finallyBlock, that.finallyBlock) && Objects.equals(this.catchClauses, that.catchClauses) && Objects.equals(this.getCatchClauses(), that.getCatchClauses());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

