/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Relationship;

public class IncludeDeclaration
extends Declaration {
    @Relationship(value="INCLUDES", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<IncludeDeclaration>> includes = new ArrayList<PropertyEdge<IncludeDeclaration>>();
    @Relationship(value="PROBLEMS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<ProblemDeclaration>> problems = new ArrayList<PropertyEdge<ProblemDeclaration>>();
    private String filename;

    public List<IncludeDeclaration> getIncludes() {
        return PropertyEdge.unwrap(this.includes);
    }

    public List<PropertyEdge<IncludeDeclaration>> getIncludesPropertyEdge() {
        return this.includes;
    }

    public void addInclude(IncludeDeclaration includeDeclaration) {
        PropertyEdge<IncludeDeclaration> propertyEdge = new PropertyEdge<IncludeDeclaration>(this, includeDeclaration);
        propertyEdge.addProperty(Properties.INDEX, this.includes.size());
        this.includes.add(propertyEdge);
    }

    public List<ProblemDeclaration> getProblems() {
        return PropertyEdge.unwrap(this.problems);
    }

    public List<PropertyEdge<ProblemDeclaration>> getProblemsPropertyEdge() {
        return this.problems;
    }

    public void addProblems(Collection<ProblemDeclaration> c) {
        for (ProblemDeclaration problemDeclaration : c) {
            this.addProblem(problemDeclaration);
        }
    }

    public void addProblem(ProblemDeclaration problemDeclaration) {
        PropertyEdge<ProblemDeclaration> propertyEdge = new PropertyEdge<ProblemDeclaration>(this, problemDeclaration);
        propertyEdge.addProperty(Properties.INDEX, this.problems.size());
        this.problems.add(propertyEdge);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("name", (Object)this.name).append("filename", (Object)this.filename).append("includes", this.includes).append("problems", this.problems).toString();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncludeDeclaration)) {
            return false;
        }
        IncludeDeclaration that = (IncludeDeclaration)o;
        return super.equals(that) && Objects.equals(this.includes, that.includes) && Objects.equals(this.getIncludes(), that.getIncludes()) && Objects.equals(this.problems, that.problems) && Objects.equals(this.getProblems(), that.getProblems()) && Objects.equals(this.filename, that.filename);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

