/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Annotation;
import de.fraunhofer.aisec.cpg.graph.Persistable;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.helpers.LocationConverter;
import de.fraunhofer.aisec.cpg.processing.IVisitable;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements IVisitable<Node>,
Persistable {
    public static final ToStringStyle TO_STRING_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;
    protected static final Logger log = LoggerFactory.getLogger(Node.class);
    public static final String EMPTY_NAME = "";
    protected @NonNull String name = "";
    protected @Nullable String code;
    protected @Nullable String comment;
    @Convert(value=LocationConverter.class)
    protected @Nullable PhysicalLocation location;
    protected @Nullable String file;
    @Relationship(value="EOG", direction="INCOMING")
    protected @NonNull List<PropertyEdge<Node>> prevEOG = new ArrayList<PropertyEdge<Node>>();
    @Relationship(value="EOG", direction="OUTGOING")
    protected @NonNull List<PropertyEdge<Node>> nextEOG = new ArrayList<PropertyEdge<Node>>();
    @Deprecated(since="3.4", forRemoval=true)
    @Relationship(value="CFG", direction="OUTGOING")
    protected @NonNull List<PropertyEdge<Node>> nextCFG = new ArrayList<PropertyEdge<Node>>();
    @Relationship(value="DFG", direction="INCOMING")
    protected @NonNull Set<Node> prevDFG = new HashSet<Node>();
    @Relationship(value="DFG")
    protected @NonNull Set<Node> nextDFG = new HashSet<Node>();
    protected @NonNull Set<TypedefDeclaration> typedefs = new HashSet<TypedefDeclaration>();
    protected boolean dummy = false;
    protected boolean implicit = false;
    @Id
    @GeneratedValue
    private Long id;
    private int argumentIndex;
    @SubGraph(value={"AST"})
    protected List<Annotation> annotations = new ArrayList<Annotation>();

    public Long getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    public @Nullable String getFile() {
        return this.file;
    }

    public void setFile(@Nullable String file) {
        this.file = file;
    }

    public @Nullable String getCode() {
        return this.code;
    }

    public void setCode(@Nullable String code) {
        this.code = code;
    }

    public @Nullable PhysicalLocation getLocation() {
        return this.location;
    }

    public void setLocation(@Nullable PhysicalLocation location) {
        this.location = location;
    }

    public @NonNull List<PropertyEdge<Node>> getPrevEOGProperties() {
        return this.prevEOG;
    }

    public @NonNull List<PropertyEdge<Node>> getNextEOGProperties() {
        return this.nextEOG;
    }

    public void setPrevEOGProperties(@NonNull List<PropertyEdge<Node>> prevEOG) {
        this.prevEOG = prevEOG;
    }

    public void removePrevEOGEntry(@NonNull Node eog) {
        this.removePrevEOGEntries(List.of(eog));
    }

    public void removePrevEOGEntries(@NonNull List<Node> prevEOGs) {
        for (Node n : prevEOGs) {
            List<PropertyEdge> remove = PropertyEdge.findPropertyEdgesByPredicate(this.prevEOG, e -> e.getStart().equals(n));
            this.prevEOG.removeAll(remove);
        }
    }

    public @NonNull List<Node> getPrevEOG() {
        ArrayList<Node> prevEOGTargets = new ArrayList<Node>();
        this.prevEOG.forEach(propertyEdge -> prevEOGTargets.add(propertyEdge.getStart()));
        return prevEOGTargets;
    }

    public void setPrevEOG(@NonNull List<Node> prevEOG) {
        ArrayList<PropertyEdge<Node>> propertyEdgesEOG = new ArrayList<PropertyEdge<Node>>();
        int idx = 0;
        for (Node prev : prevEOG) {
            PropertyEdge<Node> propertyEdge = new PropertyEdge<Node>(prev, this);
            propertyEdge.addProperty(Properties.INDEX, idx);
            propertyEdgesEOG.add(propertyEdge);
            ++idx;
        }
        this.prevEOG = propertyEdgesEOG;
    }

    public void addPrevEOG(@NonNull PropertyEdge<Node> propertyEdge) {
        this.prevEOG.add(propertyEdge);
    }

    public @NonNull List<PropertyEdge<Node>> getNextEOGPropertyEdge() {
        return this.nextEOG;
    }

    public @NonNull List<Node> getNextEOG() {
        ArrayList nextEOGTargets = new ArrayList();
        this.nextEOG.forEach(propertyEdge -> nextEOGTargets.add(propertyEdge.getEnd()));
        return Collections.unmodifiableList(nextEOGTargets);
    }

    public void setNextEOG(@NonNull List<Node> nextEOG) {
        this.nextEOG = PropertyEdge.transformIntoOutgoingPropertyEdgeList(nextEOG, this);
    }

    public void addNextEOG(@NonNull PropertyEdge<Node> propertyEdge) {
        this.nextEOG.add(propertyEdge);
    }

    public void clearNextEOG() {
        this.nextEOG.clear();
    }

    @Deprecated(since="3.4", forRemoval=true)
    public @NonNull List<Node> getNextCFG() {
        return PropertyEdge.unwrap(this.nextCFG);
    }

    @Deprecated(since="3.4", forRemoval=true)
    public void addNextCFG(Node node) {
        PropertyEdge<Node> propertyEdge = new PropertyEdge<Node>(this, node);
        propertyEdge.addProperty(Properties.INDEX, this.nextCFG.size());
        this.nextCFG.add(propertyEdge);
    }

    @Deprecated(since="3.4", forRemoval=true)
    public void addNextCFG(Collection<? extends Node> collection) {
        for (Node node : collection) {
            this.addNextCFG(node);
        }
    }

    public @NonNull Set<Node> getNextDFG() {
        return this.nextDFG;
    }

    public void setNextDFG(@NonNull Set<Node> nextDFG) {
        this.nextDFG = nextDFG;
    }

    public void addNextDFG(Node next) {
        this.nextDFG.add(next);
        next.prevDFG.add(this);
    }

    public void removeNextDFG(Node next) {
        if (next != null) {
            this.nextDFG.remove(next);
            next.prevDFG.remove(this);
        }
    }

    public @NonNull Set<Node> getPrevDFG() {
        return this.prevDFG;
    }

    public void setPrevDFG(@NonNull Set<Node> prevDFG) {
        this.prevDFG = prevDFG;
    }

    public void addPrevDFG(Node prev) {
        this.prevDFG.add(prev);
        prev.nextDFG.add(this);
    }

    public void removePrevDFG(Node prev) {
        if (prev != null) {
            this.prevDFG.remove(prev);
            prev.nextDFG.remove(this);
        }
    }

    public void addTypedef(TypedefDeclaration typedef) {
        this.typedefs.add(typedef);
    }

    public @NonNull Set<TypedefDeclaration> getTypedefs() {
        return this.typedefs;
    }

    public void setTypedefs(@NonNull Set<TypedefDeclaration> typedefs) {
        this.typedefs = typedefs;
    }

    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    public void setArgumentIndex(int argumentIndex) {
        this.argumentIndex = argumentIndex;
    }

    @Deprecated(forRemoval=true)
    public boolean isDummy() {
        return this.dummy;
    }

    @Deprecated(forRemoval=true)
    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public @NonNull List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotations(@NonNull Collection<Annotation> annotations) {
        this.annotations.addAll(annotations);
    }

    public void disconnectFromGraph() {
        List<PropertyEdge> remove;
        for (Node node : this.nextDFG) {
            node.prevDFG.remove(this);
        }
        this.nextDFG.clear();
        for (Node node : this.prevDFG) {
            node.nextDFG.remove(this);
        }
        this.prevDFG.clear();
        for (PropertyEdge propertyEdge : this.nextEOG) {
            remove = PropertyEdge.findPropertyEdgesByPredicate(((Node)propertyEdge.getEnd()).prevEOG, e -> e.getStart().equals(this));
            ((Node)propertyEdge.getEnd()).prevEOG.removeAll(remove);
        }
        this.nextEOG.clear();
        for (PropertyEdge propertyEdge : this.prevEOG) {
            remove = PropertyEdge.findPropertyEdgesByPredicate(propertyEdge.getStart().nextEOG, e -> ((Node)e.getEnd()).equals(this));
            propertyEdge.getStart().nextEOG.removeAll(remove);
        }
        this.prevEOG.clear();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, TO_STRING_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).append("location", (Object)this.location).append("argumentIndex", this.argumentIndex).toString();
    }

    public void setComment(@NonNull String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        if (this.location == null || node.location == null) {
            return false;
        }
        return Objects.equals(this.name, node.name) && Objects.equals(this.code, node.code) && Objects.equals(this.comment, node.comment) && Objects.equals(this.location, node.location) && Objects.equals(this.file, node.file);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getClass());
    }
}

