/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.java;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedValueDeclaration;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UninitializedValue;
import de.fraunhofer.aisec.cpg.graph.types.PointerType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionHandler
extends Handler<Statement, com.github.javaparser.ast.expr.Expression, JavaLanguageFrontend> {
    private static final Logger log = LoggerFactory.getLogger(ExpressionHandler.class);

    public ExpressionHandler(JavaLanguageFrontend lang) {
        super(Expression::new, lang);
        this.map.put(AssignExpr.class, this::handleAssignmentExpression);
        this.map.put(FieldAccessExpr.class, this::handleFieldAccessExpression);
        this.map.put(LiteralExpr.class, this::handleLiteralExpression);
        this.map.put(ThisExpr.class, this::handleThisExpression);
        this.map.put(SuperExpr.class, this::handleSuperExpression);
        this.map.put(ClassExpr.class, this::handleClassExpression);
        this.map.put(NameExpr.class, this::handleNameExpression);
        this.map.put(InstanceOfExpr.class, this::handleInstanceOfExpression);
        this.map.put(UnaryExpr.class, this::handleUnaryExpression);
        this.map.put(BinaryExpr.class, this::handleBinaryExpression);
        this.map.put(VariableDeclarationExpr.class, this::handleVariableDeclarationExpr);
        this.map.put(MethodCallExpr.class, this::handleMethodCallExpression);
        this.map.put(ObjectCreationExpr.class, this::handleObjectCreationExpr);
        this.map.put(ConditionalExpr.class, this::handleConditionalExpression);
        this.map.put(EnclosedExpr.class, this::handleEnclosedExpression);
        this.map.put(ArrayAccessExpr.class, this::handleArrayAccessExpr);
        this.map.put(ArrayCreationExpr.class, this::handleArrayCreationExpr);
        this.map.put(ArrayInitializerExpr.class, this::handleArrayInitializerExpr);
        this.map.put(CastExpr.class, this::handleCastExpr);
    }

    private Statement handleCastExpr(com.github.javaparser.ast.expr.Expression expr) {
        CastExpr castExpr = expr.asCastExpr();
        CastExpression castExpression = NodeBuilder.newCastExpression(expr.toString());
        Expression expression = (Expression)this.handle(castExpr.getExpression());
        castExpression.setExpression(expression);
        castExpression.setCastOperator(2);
        Type t = ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible(castExpr.getType());
        castExpression.setCastType(t);
        if (castExpr.getType().isPrimitiveType()) {
            castExpression.setType(TypeParser.createFrom(castExpr.getType().resolve().asPrimitive().describe(), true));
        } else {
            castExpression.getExpression().registerTypeListener(castExpression);
        }
        return castExpression;
    }

    private Statement handleArrayCreationExpr(com.github.javaparser.ast.expr.Expression expr) {
        ArrayCreationExpr arrayCreationExpr = (ArrayCreationExpr)expr;
        ArrayCreationExpression creationExpression = NodeBuilder.newArrayCreationExpression(expr.toString());
        arrayCreationExpr.getInitializer().ifPresent(init -> creationExpression.setInitializer((InitializerListExpression)this.handle(init)));
        for (ArrayCreationLevel lvl : arrayCreationExpr.getLevels()) {
            lvl.getDimension().ifPresent(expression -> creationExpression.addDimension((Expression)this.handle(expression)));
        }
        return creationExpression;
    }

    private Statement handleArrayInitializerExpr(com.github.javaparser.ast.expr.Expression expr) {
        ArrayInitializerExpr arrayInitializerExpr = (ArrayInitializerExpr)expr;
        InitializerListExpression initList = NodeBuilder.newInitializerListExpression(expr.toString());
        List<Expression> initializers = arrayInitializerExpr.getValues().stream().map(this::handle).map(Expression.class::cast).collect(Collectors.toList());
        initList.setInitializers(initializers);
        return initList;
    }

    private ArraySubscriptionExpression handleArrayAccessExpr(com.github.javaparser.ast.expr.Expression expr) {
        ArrayAccessExpr arrayAccessExpr = (ArrayAccessExpr)expr;
        ArraySubscriptionExpression arraySubsExpression = NodeBuilder.newArraySubscriptionExpression(expr.toString());
        arraySubsExpression.setArrayExpression((Expression)this.handle(arrayAccessExpr.getName()));
        arraySubsExpression.setSubscriptExpression((Expression)this.handle(arrayAccessExpr.getIndex()));
        return arraySubsExpression;
    }

    private Statement handleEnclosedExpression(com.github.javaparser.ast.expr.Expression expr) {
        return (Statement)this.handle(((EnclosedExpr)expr).getInner());
    }

    private ConditionalExpression handleConditionalExpression(com.github.javaparser.ast.expr.Expression expr) {
        Type superType;
        ConditionalExpr conditionalExpr = expr.asConditionalExpr();
        try {
            superType = TypeParser.createFrom(conditionalExpr.calculateResolvedType().describe(), true);
        }
        catch (NoClassDefFoundError | RuntimeException e) {
            String s = ((JavaLanguageFrontend)this.lang).recoverTypeFromUnsolvedException(e);
            superType = s != null ? TypeParser.createFrom(s, true) : null;
        }
        Expression condition = (Expression)this.handle(conditionalExpr.getCondition());
        Expression thenExpr = (Expression)this.handle(conditionalExpr.getThenExpr());
        Expression elseExpr = (Expression)this.handle(conditionalExpr.getElseExpr());
        return NodeBuilder.newConditionalExpression(condition, thenExpr, elseExpr, superType);
    }

    private BinaryOperator handleAssignmentExpression(com.github.javaparser.ast.expr.Expression expr) {
        AssignExpr assignExpr = expr.asAssignExpr();
        Expression lhs = (Expression)this.handle(assignExpr.getTarget());
        Expression rhs = (Expression)this.handle(assignExpr.getValue());
        BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator(assignExpr.getOperator().asString(), assignExpr.toString());
        binaryOperator.setLhs(lhs);
        binaryOperator.setRhs(rhs);
        binaryOperator.setType(lhs.getType());
        return binaryOperator;
    }

    private DeclarationStatement handleVariableDeclarationExpr(com.github.javaparser.ast.expr.Expression expr) {
        VariableDeclarationExpr variableDeclarationExpr = expr.asVariableDeclarationExpr();
        DeclarationStatement declarationStatement = NodeBuilder.newDeclarationStatement(variableDeclarationExpr.toString());
        for (VariableDeclarator variable2 : variableDeclarationExpr.getVariables()) {
            ResolvedValueDeclaration resolved = variable2.resolve();
            VariableDeclaration declaration = NodeBuilder.newVariableDeclaration(resolved.getName(), ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible((NodeWithType)variable2, resolved), variable2.toString(), false);
            if (declaration.getType() instanceof PointerType && ((PointerType)declaration.getType()).isArray()) {
                declaration.setIsArray(true);
            }
            declaration.getType().setAdditionalTypeKeywords(variableDeclarationExpr.getModifiers().stream().map(m -> m.getKeyword().asString()).collect(Collectors.joining(" ")));
            Optional oInitializer = variable2.getInitializer();
            if (oInitializer.isPresent()) {
                Expression initializer = (Expression)this.handle((com.github.javaparser.ast.expr.Expression)oInitializer.get());
                if (initializer instanceof ArrayCreationExpression) {
                    declaration.setIsArray(true);
                }
                declaration.setInitializer(initializer);
            } else {
                UninitializedValue uninitialzedInitializer = new UninitializedValue();
                declaration.setInitializer(uninitialzedInitializer);
                declaration.getNextEOG();
            }
            ((JavaLanguageFrontend)this.lang).setCodeAndRegion(declaration, variable2);
            declarationStatement.addToPropertyEdgeDeclaration(declaration);
            ((JavaLanguageFrontend)this.lang).getScopeManager().addDeclaration(declaration);
        }
        return declarationStatement;
    }

    private Expression handleFieldAccessExpression(com.github.javaparser.ast.expr.Expression expr) {
        Type fieldType;
        Expression base;
        FieldAccessExpr fieldAccessExpr = expr.asFieldAccessExpr();
        com.github.javaparser.ast.expr.Expression scope = fieldAccessExpr.getScope();
        if (scope.isNameExpr()) {
            Type baseType;
            boolean isStaticAccess = false;
            try {
                ResolvedValueDeclaration resolve = fieldAccessExpr.resolve();
                if (resolve.asField().isStatic()) {
                    isStaticAccess = true;
                }
                baseType = TypeParser.createFrom(resolve.asField().declaringType().getQualifiedName(), true);
            }
            catch (NoClassDefFoundError | RuntimeException ex) {
                isStaticAccess = true;
                String typeString = ((JavaLanguageFrontend)this.lang).recoverTypeFromUnsolvedException(ex);
                if (typeString != null) {
                    baseType = TypeParser.createFrom(typeString, true);
                }
                Optional tokenRange = scope.asNameExpr().getTokenRange();
                String name = tokenRange.isPresent() ? ((TokenRange)tokenRange.get()).toString() : scope.asNameExpr().getNameAsString();
                String qualifiedNameFromImports = ((JavaLanguageFrontend)this.lang).getQualifiedNameFromImports(name);
                if (qualifiedNameFromImports != null) {
                    baseType = TypeParser.createFrom(qualifiedNameFromImports, true);
                }
                log.info("Unknown base type 1 for {}", (Object)fieldAccessExpr);
                baseType = UnknownType.getUnknownType();
            }
            base = NodeBuilder.newDeclaredReferenceExpression(scope.asNameExpr().getNameAsString(), baseType, scope.toString());
            ((DeclaredReferenceExpression)base).setStaticAccess(isStaticAccess);
            ((JavaLanguageFrontend)this.lang).setCodeAndRegion(base, fieldAccessExpr.getScope());
        } else if (scope.isFieldAccessExpr()) {
            Expression tester = base = (Expression)this.handle(scope);
            while (tester instanceof MemberExpression) {
                tester = ((MemberExpression)tester).getBase();
            }
            if (tester instanceof DeclaredReferenceExpression && ((DeclaredReferenceExpression)tester).isStaticAccess()) {
                Type baseType;
                Optional tokenRange = scope.asFieldAccessExpr().getTokenRange();
                String name = tokenRange.isPresent() ? ((TokenRange)tokenRange.get()).toString() : scope.asFieldAccessExpr().getNameAsString();
                String qualifiedNameFromImports = ((JavaLanguageFrontend)this.lang).getQualifiedNameFromImports(name);
                if (qualifiedNameFromImports != null) {
                    baseType = TypeParser.createFrom(qualifiedNameFromImports, true);
                } else {
                    log.info("Unknown base type 2 for {}", (Object)fieldAccessExpr);
                    baseType = UnknownType.getUnknownType();
                }
                base = NodeBuilder.newDeclaredReferenceExpression(scope.asFieldAccessExpr().getNameAsString(), baseType, scope.toString());
                ((DeclaredReferenceExpression)base).setStaticAccess(true);
            }
            ((JavaLanguageFrontend)this.lang).setCodeAndRegion(base, fieldAccessExpr.getScope());
        } else {
            base = (Expression)this.handle(scope);
        }
        try {
            ResolvedValueDeclaration symbol = fieldAccessExpr.resolve();
            fieldType = TypeManager.getInstance().getTypeParameter(((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord(), symbol.asField().getType().describe());
            if (fieldType == null) {
                fieldType = TypeParser.createFrom(symbol.asField().getType().describe(), true);
            }
        }
        catch (NoClassDefFoundError | RuntimeException ex) {
            Type fieldType2;
            String typeString = ((JavaLanguageFrontend)this.lang).recoverTypeFromUnsolvedException(ex);
            if (typeString != null) {
                fieldType2 = TypeParser.createFrom(typeString, true);
            } else if (fieldAccessExpr.toString().endsWith(".length")) {
                fieldType2 = TypeParser.createFrom("int", true);
            } else {
                log.info("Unknown field type for {}", (Object)fieldAccessExpr);
                fieldType2 = UnknownType.getUnknownType();
            }
            MemberExpression memberExpression = NodeBuilder.newMemberExpression(base, fieldType2, fieldAccessExpr.getName().getIdentifier(), ".", fieldAccessExpr.toString());
            memberExpression.setStaticAccess(true);
            return memberExpression;
        }
        if (base.getLocation() == null) {
            base.setLocation(((JavaLanguageFrontend)this.lang).getLocationFromRawNode(fieldAccessExpr));
        }
        return NodeBuilder.newMemberExpression(base, fieldType, fieldAccessExpr.getName().getIdentifier(), ".", fieldAccessExpr.toString());
    }

    private Literal handleLiteralExpression(com.github.javaparser.ast.expr.Expression expr) {
        LiteralExpr literalExpr = expr.asLiteralExpr();
        String value = literalExpr.toString();
        if (literalExpr instanceof IntegerLiteralExpr) {
            return NodeBuilder.newLiteral(literalExpr.asIntegerLiteralExpr().asNumber(), TypeParser.createFrom("int", true), value);
        }
        if (literalExpr instanceof StringLiteralExpr) {
            return NodeBuilder.newLiteral(literalExpr.asStringLiteralExpr().asString(), TypeParser.createFrom("java.lang.String", true), value);
        }
        if (literalExpr instanceof BooleanLiteralExpr) {
            return NodeBuilder.newLiteral(literalExpr.asBooleanLiteralExpr().getValue(), TypeParser.createFrom("boolean", true), value);
        }
        if (literalExpr instanceof CharLiteralExpr) {
            return NodeBuilder.newLiteral(Character.valueOf(literalExpr.asCharLiteralExpr().asChar()), TypeParser.createFrom("char", true), value);
        }
        if (literalExpr instanceof DoubleLiteralExpr) {
            return NodeBuilder.newLiteral(literalExpr.asDoubleLiteralExpr().asDouble(), TypeParser.createFrom("double", true), value);
        }
        if (literalExpr instanceof LongLiteralExpr) {
            return NodeBuilder.newLiteral(literalExpr.asLongLiteralExpr().asNumber(), TypeParser.createFrom("long", true), value);
        }
        if (literalExpr instanceof NullLiteralExpr) {
            return NodeBuilder.newLiteral(null, TypeParser.createFrom("null", true), value);
        }
        return null;
    }

    private DeclaredReferenceExpression handleClassExpression(com.github.javaparser.ast.expr.Expression expr) {
        ClassExpr classExpr = expr.asClassExpr();
        Type type = TypeParser.createFrom(classExpr.getType().asString(), true);
        DeclaredReferenceExpression thisExpression = NodeBuilder.newDeclaredReferenceExpression(classExpr.toString().substring(classExpr.toString().lastIndexOf(46) + 1), type, classExpr.toString());
        thisExpression.setStaticAccess(true);
        ((JavaLanguageFrontend)this.lang).setCodeAndRegion(thisExpression, classExpr);
        return thisExpression;
    }

    private DeclaredReferenceExpression handleThisExpression(com.github.javaparser.ast.expr.Expression expr) {
        ThisExpr thisExpr = expr.asThisExpr();
        ResolvedTypeDeclaration resolvedValueDeclaration = thisExpr.resolve();
        Type type = TypeParser.createFrom(resolvedValueDeclaration.getQualifiedName(), true);
        DeclaredReferenceExpression thisExpression = NodeBuilder.newDeclaredReferenceExpression(thisExpr.toString(), type, thisExpr.toString());
        ((JavaLanguageFrontend)this.lang).setCodeAndRegion(thisExpression, thisExpr);
        return thisExpression;
    }

    private DeclaredReferenceExpression handleSuperExpression(com.github.javaparser.ast.expr.Expression expr) {
        DeclaredReferenceExpression superExpression = NodeBuilder.newDeclaredReferenceExpression(expr.toString(), UnknownType.getUnknownType(), expr.toString());
        ((JavaLanguageFrontend)this.lang).setCodeAndRegion(superExpression, expr);
        return superExpression;
    }

    private Expression handleNameExpression(com.github.javaparser.ast.expr.Expression expr) {
        NameExpr nameExpr = expr.asNameExpr();
        try {
            ResolvedValueDeclaration symbol = nameExpr.resolve();
            if (symbol.isField()) {
                ResolvedFieldDeclaration field = symbol.asField();
                if (!field.isStatic()) {
                    FieldAccessExpr fieldAccessExpr = new FieldAccessExpr((com.github.javaparser.ast.expr.Expression)new ThisExpr(), field.getName());
                    expr.getRange().ifPresent(arg_0 -> ((FieldAccessExpr)fieldAccessExpr).setRange(arg_0));
                    expr.getTokenRange().ifPresent(arg_0 -> ((FieldAccessExpr)fieldAccessExpr).setTokenRange(arg_0));
                    expr.getParentNode().ifPresent(arg_0 -> ((FieldAccessExpr)fieldAccessExpr).setParentNode(arg_0));
                    expr.replace((Node)fieldAccessExpr);
                    fieldAccessExpr.getParentNode().ifPresent(arg_0 -> ((com.github.javaparser.ast.expr.Expression)expr).setParentNode(arg_0));
                    return (Expression)this.handle(fieldAccessExpr);
                }
                FieldAccessExpr fieldAccessExpr = new FieldAccessExpr((com.github.javaparser.ast.expr.Expression)new NameExpr(field.declaringType().getClassName()), field.getName());
                expr.getRange().ifPresent(arg_0 -> ((FieldAccessExpr)fieldAccessExpr).setRange(arg_0));
                expr.getTokenRange().ifPresent(arg_0 -> ((FieldAccessExpr)fieldAccessExpr).setTokenRange(arg_0));
                expr.getParentNode().ifPresent(arg_0 -> ((FieldAccessExpr)fieldAccessExpr).setParentNode(arg_0));
                expr.replace((Node)fieldAccessExpr);
                fieldAccessExpr.getParentNode().ifPresent(arg_0 -> ((com.github.javaparser.ast.expr.Expression)expr).setParentNode(arg_0));
                return (Expression)this.handle(fieldAccessExpr);
            }
            Type type = TypeManager.getInstance().getTypeParameter(((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord(), symbol.getType().describe());
            if (type == null) {
                type = TypeParser.createFrom(symbol.getType().describe(), true);
            }
            DeclaredReferenceExpression declaredReferenceExpression = NodeBuilder.newDeclaredReferenceExpression(symbol.getName(), type, nameExpr.toString());
            ((JavaLanguageFrontend)this.lang).getScopeManager().connectToLocal(declaredReferenceExpression);
            return declaredReferenceExpression;
        }
        catch (UnsolvedSymbolException ex) {
            Type t;
            String typeString = ex.getName().startsWith("We are unable to find the value declaration corresponding to") ? nameExpr.getNameAsString() : ((JavaLanguageFrontend)this.lang).recoverTypeFromUnsolvedException(ex);
            if (typeString == null) {
                t = TypeParser.createFrom("UNKNOWN3", true);
                log.info("Unresolved symbol: {}", (Object)nameExpr.getNameAsString());
            } else {
                t = TypeParser.createFrom(typeString, true);
                t.setTypeOrigin(Type.Origin.GUESSED);
            }
            String name = nameExpr.getNameAsString();
            DeclaredReferenceExpression declaredReferenceExpression = NodeBuilder.newDeclaredReferenceExpression(name, t, nameExpr.toString());
            RecordDeclaration record = ((JavaLanguageFrontend)this.lang).getScopeManager().getCurrentRecord();
            if (record != null && Objects.equals(record.getName(), name)) {
                declaredReferenceExpression.setRefersTo(record);
            } else {
                ((JavaLanguageFrontend)this.lang).getScopeManager().connectToLocal(declaredReferenceExpression);
            }
            return declaredReferenceExpression;
        }
        catch (NoClassDefFoundError | RuntimeException ex) {
            Type t = TypeParser.createFrom("UNKNOWN4", true);
            log.info("Unresolved symbol: {}", (Object)nameExpr.getNameAsString());
            DeclaredReferenceExpression declaredReferenceExpression = NodeBuilder.newDeclaredReferenceExpression(nameExpr.getNameAsString(), t, nameExpr.toString());
            return declaredReferenceExpression;
        }
    }

    private BinaryOperator handleInstanceOfExpression(com.github.javaparser.ast.expr.Expression expr) {
        InstanceOfExpr binaryExpr = expr.asInstanceOfExpr();
        Expression lhs = (Expression)this.handle(binaryExpr.getExpression());
        Type typeAsGoodAsPossible = ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible((com.github.javaparser.ast.type.Type)binaryExpr.getType());
        Literal<String> rhs = NodeBuilder.newLiteral(typeAsGoodAsPossible.getTypeName(), TypeParser.createFrom("class", true), binaryExpr.getTypeAsString());
        BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator("instanceof", binaryExpr.toString());
        binaryOperator.setLhs(lhs);
        binaryOperator.setRhs(rhs);
        return binaryOperator;
    }

    private UnaryOperator handleUnaryExpression(com.github.javaparser.ast.expr.Expression expr) {
        UnaryExpr unaryExpr = expr.asUnaryExpr();
        Expression expression = (Expression)this.handle(unaryExpr.getExpression());
        UnaryOperator unaryOperator = NodeBuilder.newUnaryOperator(unaryExpr.getOperator().asString(), unaryExpr.isPostfix(), unaryExpr.isPrefix(), unaryExpr.toString());
        unaryOperator.setInput(expression);
        unaryOperator.setType(expression.getType());
        return unaryOperator;
    }

    private BinaryOperator handleBinaryExpression(com.github.javaparser.ast.expr.Expression expr) {
        BinaryExpr binaryExpr = expr.asBinaryExpr();
        Expression lhs = (Expression)this.handle(binaryExpr.getLeft());
        Expression rhs = (Expression)this.handle(binaryExpr.getRight());
        BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator(binaryExpr.getOperator().asString(), binaryExpr.toString());
        binaryOperator.setLhs(lhs);
        binaryOperator.setRhs(rhs);
        return binaryOperator;
    }

    private CallExpression handleMethodCallExpression(com.github.javaparser.ast.expr.Expression expr) {
        CallExpression callExpression;
        MethodCallExpr methodCallExpr = expr.asMethodCallExpr();
        Optional o = methodCallExpr.getScope();
        String qualifiedName = ((JavaLanguageFrontend)this.lang).getQualifiedMethodNameAsGoodAsPossible(methodCallExpr);
        String name = qualifiedName;
        if (name.contains(".")) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        String typeString = "UNKNOWN";
        boolean isStatic = false;
        ResolvedMethodDeclaration resolved = null;
        try {
            resolved = methodCallExpr.resolve();
            isStatic = resolved.isStatic();
            typeString = resolved.getReturnType().describe();
        }
        catch (NoClassDefFoundError | RuntimeException ignored) {
            log.debug("Could not resolve method {}", (Object)methodCallExpr);
        }
        if (o.isPresent()) {
            com.github.javaparser.ast.expr.Expression scope = (com.github.javaparser.ast.expr.Expression)o.get();
            String scopeName = null;
            if (scope instanceof NameExpr) {
                scopeName = ((NameExpr)scope).getNameAsString();
            } else if (scope instanceof SuperExpr) {
                scopeName = scope.toString();
            }
            Statement base = (Statement)this.handle(scope);
            if (base instanceof DeclaredReferenceExpression && ((DeclaredReferenceExpression)base).getRefersTo() instanceof RecordDeclaration) {
                isStatic = true;
            }
            if (base instanceof DeclaredReferenceExpression && ((JavaLanguageFrontend)this.lang).getQualifiedNameFromImports(base.getName()) != null) {
                isStatic = true;
            }
            if (!isStatic) {
                DeclaredReferenceExpression member = NodeBuilder.newDeclaredReferenceExpression(name, UnknownType.getUnknownType(), "");
                ((JavaLanguageFrontend)this.lang).setCodeAndRegion(member, methodCallExpr);
                callExpression = NodeBuilder.newMemberCallExpression(name, qualifiedName, base, member, ".", methodCallExpr.toString());
            } else {
                String targetClass = resolved != null ? resolved.declaringType().getQualifiedName() : ((JavaLanguageFrontend)this.lang).getQualifiedNameFromImports(scopeName);
                if (targetClass == null) {
                    targetClass = scopeName;
                }
                callExpression = NodeBuilder.newStaticCallExpression(name, qualifiedName, methodCallExpr.toString(), targetClass);
            }
        } else {
            callExpression = NodeBuilder.newCallExpression(name, qualifiedName, methodCallExpr.toString());
        }
        callExpression.setType(TypeParser.createFrom(typeString, true));
        NodeList arguments = methodCallExpr.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            Expression argument = (Expression)this.handle((com.github.javaparser.ast.expr.Expression)arguments.get(i));
            argument.setArgumentIndex(i);
            callExpression.addArgument(argument);
        }
        return callExpression;
    }

    private NewExpression handleObjectCreationExpr(com.github.javaparser.ast.expr.Expression expr) {
        ObjectCreationExpr objectCreationExpr = expr.asObjectCreationExpr();
        Optional o = objectCreationExpr.getScope();
        if (o.isPresent()) {
            log.warn("Scope {}", (Object)o);
        }
        Type t = ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible((com.github.javaparser.ast.type.Type)objectCreationExpr.getType());
        NewExpression newExpression = NodeBuilder.newNewExpression(expr.toString(), t);
        NodeList arguments = objectCreationExpr.getArguments();
        String code = expr.toString();
        if (code.length() > 4) {
            code = code.substring(4);
        }
        ConstructExpression ctor = NodeBuilder.newConstructExpression(code);
        ctor.setType(t);
        ((JavaLanguageFrontend)this.lang).setCodeAndRegion(ctor, expr);
        for (int i = 0; i < arguments.size(); ++i) {
            Expression argument = (Expression)this.handle((com.github.javaparser.ast.expr.Expression)arguments.get(i));
            argument.setArgumentIndex(i);
            ctor.addArgument(argument);
        }
        newExpression.setInitializer(ctor);
        return newExpression;
    }
}

