/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTParameterDeclaration;

public class ParameterDeclarationHandler
extends Handler<ParamVariableDeclaration, IASTParameterDeclaration, CXXLanguageFrontend> {
    public ParameterDeclarationHandler(CXXLanguageFrontend lang) {
        super(ParamVariableDeclaration::new, lang);
        this.map.put(CPPASTParameterDeclaration.class, ctx -> this.handleParameterDeclaration((CPPASTParameterDeclaration)ctx));
    }

    private ParamVariableDeclaration handleParameterDeclaration(CPPASTParameterDeclaration ctx) {
        Object typeAdjustment = List.of(ctx.getDeclarator().getPointerOperators()).stream().map(IASTNode::getRawSignature).collect(Collectors.joining());
        if (ctx.getDeclarator() instanceof CPPASTArrayDeclarator && ctx.getDeclarator().getInitializer() instanceof InitializerListExpression) {
            typeAdjustment = (String)typeAdjustment + "[" + ((InitializerListExpression)ctx.getDeclarator().getInitializer()).getInitializers().size() + "]";
        } else if (ctx.getDeclarator() instanceof CPPASTArrayDeclarator && ctx.getDeclarator().getInitializer() instanceof Literal && ((Literal)ctx.getDeclarator().getInitializer()).getValue() instanceof String) {
            typeAdjustment = (String)typeAdjustment + "[" + (((String)((Literal)ctx.getDeclarator().getInitializer()).getValue()).length() + 1) + "]";
        } else if (ctx.getDeclarator() instanceof CPPASTArrayDeclarator) {
            typeAdjustment = (String)typeAdjustment + List.of(((CPPASTArrayDeclarator)ctx.getDeclarator()).getArrayModifiers()).stream().map(IASTNode::getRawSignature).collect(Collectors.joining());
        }
        ParamVariableDeclaration paramVariableDeclaration = NodeBuilder.newMethodParameterIn(ctx.getDeclarator().getName().toString(), UnknownType.getUnknownType(), false, ctx.getRawSignature());
        if (!((String)typeAdjustment).isEmpty()) {
            paramVariableDeclaration.setType(TypeParser.createFrom(ctx.getDeclSpecifier().toString() + (String)typeAdjustment, true));
        } else {
            paramVariableDeclaration.setType(TypeParser.createFrom(ctx.getDeclSpecifier().toString(), true));
        }
        return paramVariableDeclaration;
    }
}

