/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.PathEntryTranslator;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.ConfigBasedPathEntryContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class ConfigBasedPathEntryStore
implements IPathEntryStore,
ICProjectDescriptionListener {
    private List<IPathEntryStoreListener> fListeners;
    private IProject fProject;
    static final QualifiedName PATH_ENTRY_COLLECTOR_PROPERTY_NAME = new QualifiedName("org.eclipse.cdt.core", "PathEntryStoreCollector");

    public ConfigBasedPathEntryStore(IProject project) {
        this.fProject = project;
        this.fListeners = Collections.synchronizedList(new ArrayList());
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this, 5);
    }

    @Override
    public void addPathEntryStoreListener(IPathEntryStoreListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    public void removePathEntryStoreListener(IPathEntryStoreListener listener) {
        this.fListeners.remove(listener);
    }

    private void fireContentChangedEvent(IProject project) {
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, project, 1);
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.fListeners.size()];
        this.fListeners.toArray(observers);
        IPathEntryStoreListener[] iPathEntryStoreListenerArray = observers;
        int n = observers.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntryStoreListener observer = iPathEntryStoreListenerArray[n2];
            observer.pathEntryStoreChanged(evt);
            ++n2;
        }
    }

    @Override
    public void close() {
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, this.fProject, 2);
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.fListeners.size()];
        this.fListeners.toArray(observers);
        IPathEntryStoreListener[] iPathEntryStoreListenerArray = observers;
        int n = observers.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntryStoreListener observer = iPathEntryStoreListenerArray[n2];
            observer.pathEntryStoreChanged(evt);
            ++n2;
        }
        CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this);
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    @Deprecated
    public ICExtensionReference getExtensionReference() {
        return null;
    }

    @Override
    public ICConfigExtensionReference getConfigExtensionReference() {
        return null;
    }

    @Override
    public IPathEntry[] getRawPathEntries() throws CoreException {
        ICConfigurationDescription cfg = ConfigBasedPathEntryStore.getIndexCfg(this.fProject);
        List<IPathEntry>[] es = ConfigBasedPathEntryStore.getEntries(this.fProject, cfg);
        if (es != null) {
            ArrayList<IPathEntry> list = new ArrayList<IPathEntry>(es[0].size() + 1);
            list.addAll(es[0]);
            list.add(CoreModel.newContainerEntry(ConfigBasedPathEntryContainer.CONTAINER_PATH));
            return list.toArray(new IPathEntry[list.size()]);
        }
        return new IPathEntry[0];
    }

    @Override
    public void setRawPathEntries(IPathEntry[] entries) throws CoreException {
        ICConfigurationDescription cfg = ConfigBasedPathEntryStore.getIndexCfg(this.fProject);
        List<IPathEntry>[] es = ConfigBasedPathEntryStore.getEntries(this.fProject, cfg);
        if (es != null) {
            List<IPathEntry> sysList = es[1];
            List<IPathEntry> usrList = es[0];
            ArrayList<IPathEntry> newUsrList = new ArrayList<IPathEntry>(entries.length);
            IPathEntry[] iPathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IPathEntry entry = iPathEntryArray[n2];
                if (entry.getEntryKind() != 32) {
                    newUsrList.add(entry);
                }
                ++n2;
            }
            if (!newUsrList.equals(usrList)) {
                ICExternalSetting[] extSettings;
                usrList = newUsrList;
                ICProjectDescription des = CoreModel.getDefault().getProjectDescription(this.fProject, true);
                ICConfigurationDescription cfgDes = des.getDefaultSettingConfiguration();
                CConfigurationData data = cfgDes.getConfigurationData();
                PathEntryTranslator tr = new PathEntryTranslator(this.fProject, data);
                IPathEntry[] usrEntries = usrList.toArray(new IPathEntry[usrList.size()]);
                IPathEntry[] sysEntries = sysList.toArray(new IPathEntry[sysList.size()]);
                PathEntryTranslator.ReferenceSettingsInfo rInfo = tr.applyPathEntries(usrEntries, sysEntries, 3);
                cfgDes.removeExternalSettings();
                ICExternalSetting[] iCExternalSettingArray = extSettings = rInfo.getExternalSettings();
                int n3 = extSettings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICExternalSetting setting = iCExternalSettingArray[n4];
                    cfgDes.createExternalSetting(setting.getCompatibleLanguageIds(), setting.getCompatibleContentTypeIds(), setting.getCompatibleExtensions(), setting.getEntries());
                    ++n4;
                }
                Map<String, String> refMap = rInfo.getRefProjectsMap();
                cfgDes.setReferenceInfo(refMap);
                CoreModel.getDefault().setProjectDescription(this.fProject, des);
            }
        }
    }

    private static void clearCachedEntries(ICProjectDescription des) {
        ICConfigurationDescription[] cfgDess;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDess = des.getConfigurations();
        int n = cfgDess.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfgDes = iCConfigurationDescriptionArray[n2];
            ConfigBasedPathEntryStore.setCachedEntries(cfgDes, null);
            ++n2;
        }
    }

    @Override
    public void handleEvent(CProjectDescriptionEvent event) {
        IProject project = event.getProject();
        if (!this.fProject.equals((Object)project)) {
            return;
        }
        switch (event.getEventType()) {
            case 4: {
                ICProjectDescription des = event.getNewCProjectDescription();
                ICProjectDescription oldDes = event.getOldCProjectDescription();
                List<IPathEntry> oldCrEntries = null;
                if (oldDes != null) {
                    ICConfigurationDescription oldIndexCfg = oldDes.getDefaultSettingConfiguration();
                    List<IPathEntry>[] oldEs = ConfigBasedPathEntryStore.getCachedEntries(oldIndexCfg);
                    if (oldEs != null) {
                        oldCrEntries = oldEs[1];
                    }
                    ConfigBasedPathEntryStore.clearCachedEntries(oldDes);
                }
                if (des != null) {
                    ConfigBasedPathEntryStore.clearCachedEntries(des);
                    if (oldCrEntries != null) {
                        ICConfigurationDescription newIndexCfg = des.getDefaultSettingConfiguration();
                        List<IPathEntry>[] newEs = ConfigBasedPathEntryStore.getEntries(this.fProject, newIndexCfg);
                        List<IPathEntry> newCrEntries = newEs[1];
                        if (!Arrays.equals(oldCrEntries.toArray(), newCrEntries.toArray())) {
                            CModelManager manager = CModelManager.getDefault();
                            ICProject cproject = manager.create(project);
                            try {
                                PathEntryManager.getDefault().clearPathEntryContainer(new ICProject[]{cproject}, ConfigBasedPathEntryContainer.CONTAINER_PATH, new NullProgressMonitor());
                            }
                            catch (CModelException e) {
                                CCorePlugin.log(e);
                            }
                        }
                    }
                }
                this.fireContentChangedEvent(this.fProject);
            }
        }
    }

    private static List<IPathEntry>[] getEntries(IProject project, ICConfigurationDescription cfgDes) {
        if (cfgDes != null) {
            List<IPathEntry>[] es = ConfigBasedPathEntryStore.getCachedEntries(cfgDes);
            if (es == null) {
                PathEntryTranslator.PathEntryCollector cr = PathEntryTranslator.collectEntries(project, cfgDes);
                es = ConfigBasedPathEntryStore.createEntriesList(cfgDes, cr);
                ConfigBasedPathEntryStore.setCachedEntries(cfgDes, es);
            }
            return es;
        }
        return null;
    }

    private static List<IPathEntry>[] createEntriesList(ICConfigurationDescription cfgDes, PathEntryTranslator.PathEntryCollector cr) {
        ArrayList[] es = new ArrayList[2];
        es[0] = new ArrayList();
        cr.getEntries(es[0], 2, cfgDes);
        es[0].trimToSize();
        es[1] = new ArrayList();
        cr.getEntries(es[1], 1, cfgDes);
        es[1].trimToSize();
        return es;
    }

    private static List<IPathEntry>[] getCachedEntries(ICConfigurationDescription cfgDes) {
        return (List[])cfgDes.getSessionProperty(PATH_ENTRY_COLLECTOR_PROPERTY_NAME);
    }

    private static void setCachedEntries(ICConfigurationDescription cfgDes, List<IPathEntry>[] es) {
        cfgDes.setSessionProperty(PATH_ENTRY_COLLECTOR_PROPERTY_NAME, es);
    }

    private static ICConfigurationDescription getIndexCfg(IProject project) {
        ICProjectDescription des = CCorePlugin.getDefault().getProjectDescription(project, false);
        return des != null ? des.getDefaultSettingConfiguration() : null;
    }

    private static List<IPathEntry> getContainerEntries(IProject project) {
        ICProjectDescription des = CCorePlugin.getDefault().getProjectDescription(project, false);
        if (des != null) {
            return ConfigBasedPathEntryStore.getContainerEntries(des);
        }
        return new ArrayList<IPathEntry>(0);
    }

    private static List<IPathEntry> getContainerEntries(ICProjectDescription des) {
        ICConfigurationDescription cfg = des.getDefaultSettingConfiguration();
        List<IPathEntry>[] es = ConfigBasedPathEntryStore.getEntries(des.getProject(), cfg);
        if (es != null) {
            return es[1];
        }
        return new ArrayList<IPathEntry>(0);
    }

    public static ConfigBasedPathEntryContainer createContainer(IProject project) {
        List<IPathEntry> list = ConfigBasedPathEntryStore.getContainerEntries(project);
        return new ConfigBasedPathEntryContainer(list);
    }

    public static ConfigBasedPathEntryContainer createContainer(ICProjectDescription des) {
        List<IPathEntry> list = ConfigBasedPathEntryStore.getContainerEntries(des);
        return new ConfigBasedPathEntryContainer(list);
    }
}

