/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.export;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.index.export.IExportProjectProvider;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.export.GeneratePDOMApplication;
import org.eclipse.cdt.internal.core.pdom.export.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class GeneratePDOM {
    protected IExportProjectProvider pm;
    protected String[] applicationArguments;
    protected File targetLocation;
    protected String indexerID;
    protected boolean deleteOnExit;
    protected boolean checkIndexStatus;

    public GeneratePDOM(IExportProjectProvider pm, String[] applicationArguments, File targetLocation, String indexerID, boolean checkIndexStatus) {
        this.pm = pm;
        this.applicationArguments = applicationArguments;
        this.targetLocation = targetLocation;
        this.indexerID = indexerID;
        this.checkIndexStatus = checkIndexStatus;
    }

    public GeneratePDOM(IExportProjectProvider pm, String[] applicationArguments, File targetLocation, String indexerID) {
        this(pm, applicationArguments, targetLocation, indexerID, true);
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public final IStatus run() throws CoreException {
        this.pm.setApplicationArguments(this.applicationArguments);
        ICProject cproject = this.pm.createProject();
        if (cproject == null) {
            this.fail(MessageFormat.format(Messages.GeneratePDOM_ProjectProviderReturnedNullCProject, this.pm.getClass().getName()));
            return null;
        }
        IIndexLocationConverter converter = this.pm.getLocationConverter(cproject);
        if (converter == null) {
            this.fail(MessageFormat.format(Messages.GeneratePDOM_NullLocationConverter, this.pm.getClass().getName()));
        }
        IndexerPreferences.set(cproject.getProject(), "indexerId", this.indexerID);
        try {
            IStatus syncStatus;
            IIndexManager manager = CCorePlugin.getIndexManager();
            int i = 0;
            while (i < 20) {
                if (CCoreInternals.getPDOMManager().isProjectRegistered(cproject)) {
                    manager.joinIndexer(Integer.MAX_VALUE, new NullProgressMonitor());
                    if (!manager.isIndexerSetupPostponed(cproject)) break;
                }
                Thread.sleep(200L);
                ++i;
            }
            if (this.checkIndexStatus && (syncStatus = CCoreInternals.getPDOMManager().getProjectContentSyncState(cproject)) != null) {
                Status myStatus = new Status(4, "org.eclipse.cdt.core", Messages.GeneratePDOM_Incomplete);
                MultiStatus m3 = new MultiStatus("org.eclipse.cdt.core", 1, new IStatus[]{myStatus, syncStatus}, Messages.GeneratePDOM_Incomplete, null);
                CCorePlugin.log(m3);
                MultiStatus multiStatus = m3;
                return multiStatus;
            }
            try {
                CCoreInternals.getPDOMManager().exportProjectPDOM(cproject, this.targetLocation, converter, null);
                WritablePDOM exportedPDOM = new WritablePDOM(this.targetLocation, converter, LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
                exportedPDOM.acquireWriteLock(0, null);
                try {
                    Map<String, String> exportProperties = this.pm.getExportProperties();
                    if (exportProperties != null) {
                        for (Map.Entry<String, String> entry : exportProperties.entrySet()) {
                            exportedPDOM.setProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    exportedPDOM.close();
                }
                finally {
                    exportedPDOM.releaseWriteLock();
                }
            }
            catch (InterruptedException ie) {
                String msg = MessageFormat.format(Messages.GeneratePDOM_GenericGenerationFailed, ie.getMessage());
                throw new CoreException(CCorePlugin.createStatus(msg, ie));
            }
        }
        finally {
            if (this.deleteOnExit) {
                cproject.getProject().delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return new Status(0, "org.eclipse.cdt.core", Messages.GeneratePDOM_Success);
    }

    private void fail(String message) throws CoreException {
        GeneratePDOMApplication.fail(message);
    }
}

