/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.File;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class IncludeSearchPathElement {
    private static final boolean NON_SLASH_SEPARATOR = File.separatorChar != '/';
    public static final String FRAMEWORK_VAR = "__framework__";
    public static final String FILE_VAR = "__header__";
    private static final String FRAMEWORK_HEADERS = ".framework/Headers";
    private final String fPath;
    private final boolean fForQuoteIncludesOnly;
    private final boolean fIsFrameworkDirectory;
    private final boolean fIsNewFrameworkDirectory;

    IncludeSearchPathElement(String path, boolean forQuoteIncludesOnly) {
        this.fPath = path;
        this.fForQuoteIncludesOnly = forQuoteIncludesOnly;
        if (path.indexOf(95) != -1 && path.indexOf(FRAMEWORK_VAR) != -1 && path.indexOf(FILE_VAR) != -1) {
            this.fIsFrameworkDirectory = true;
            this.fIsNewFrameworkDirectory = false;
        } else if (path.endsWith(FRAMEWORK_HEADERS)) {
            this.fIsFrameworkDirectory = false;
            this.fIsNewFrameworkDirectory = true;
        } else {
            this.fIsFrameworkDirectory = false;
            this.fIsNewFrameworkDirectory = false;
        }
    }

    public boolean isForQuoteIncludesOnly() {
        return this.fForQuoteIncludesOnly;
    }

    public String getLocation(String includeDirective) {
        int firstSep;
        if (this.fIsFrameworkDirectory) {
            int firstSep2 = this.firstSeparator(includeDirective);
            if (firstSep2 <= 0) {
                return null;
            }
            String framework = includeDirective.substring(0, firstSep2);
            String file = includeDirective.substring(firstSep2 + 1);
            if (file.length() == 0) {
                return null;
            }
            StringBuilder buf = new StringBuilder(this.fPath);
            this.replace(buf, FRAMEWORK_VAR, framework);
            this.replace(buf, FILE_VAR, file);
            return ScannerUtility.reconcilePath(buf.toString());
        }
        if (this.fIsNewFrameworkDirectory && (firstSep = this.firstSeparator(includeDirective)) > 0) {
            String framework = includeDirective.substring(0, firstSep);
            String file = includeDirective.substring(firstSep + 1);
            if (file.length() > 0 && this.fPath.endsWith(String.valueOf(framework) + FRAMEWORK_HEADERS)) {
                return ScannerUtility.createReconciledPath(this.fPath, file);
            }
        }
        return ScannerUtility.createReconciledPath(this.fPath, includeDirective);
    }

    public String getIncludeDirective(String location) {
        IPath dirPath = new Path(this.fPath);
        IPath locationPath = new Path(location);
        if (this.fIsFrameworkDirectory) {
            String locationSegment;
            if (dirPath.segmentCount() != locationPath.segmentCount()) {
                return null;
            }
            int i = PathUtil.matchingFirstSegments(dirPath, locationPath);
            String dirSegment = dirPath.segment(i);
            String framework = this.deduceVariable(FRAMEWORK_VAR, dirSegment, locationSegment = locationPath.segment(i));
            if (framework == null) {
                return null;
            }
            ++i;
            if ((i = PathUtil.matchingFirstSegments(dirPath = dirPath.removeFirstSegments(i), locationPath = locationPath.removeFirstSegments(i))) < dirPath.segmentCount() - 1) {
                return null;
            }
            dirSegment = dirPath.segment(i);
            String file = this.deduceVariable(FILE_VAR, dirSegment, locationSegment = locationPath.segment(i));
            if (file == null) {
                return null;
            }
            return String.valueOf(framework) + '/' + file;
        }
        if (!PathUtil.isPrefix(dirPath, locationPath)) {
            return null;
        }
        return locationPath.removeFirstSegments(dirPath.segmentCount()).setDevice(null).toPortableString();
    }

    private int firstSeparator(String path) {
        int firstSep = path.indexOf(47);
        if (NON_SLASH_SEPARATOR) {
            firstSep = Math.max(firstSep, path.indexOf(File.separatorChar));
        }
        return firstSep;
    }

    private void replace(StringBuilder buf, String find, String replace) {
        int idx = buf.indexOf(find);
        if (idx >= 0) {
            buf.replace(idx, idx + find.length(), replace);
        }
    }

    private String deduceVariable(String varName, String raw, String substituted) {
        int pos = raw.indexOf(varName);
        if (pos < 0) {
            return null;
        }
        int suffixLength = raw.length() - pos - varName.length();
        if (substituted.length() <= pos + suffixLength) {
            return null;
        }
        int i = 0;
        while (i < suffixLength) {
            if (raw.charAt(raw.length() - i) != substituted.charAt(substituted.length() - i)) {
                return null;
            }
            ++i;
        }
        return substituted.substring(pos, substituted.length() - suffixLength);
    }

    public String toString() {
        return this.fPath;
    }
}

