/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IBufferChangedListener;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class Buffer
implements IBuffer {
    protected IFile file;
    protected int flags;
    protected char[] contents;
    protected ArrayList<IBufferChangedListener> changeListeners;
    protected IOpenable owner;
    protected int gapStart = -1;
    protected int gapEnd = -1;
    protected Object lock = new Object();
    protected static final int F_HAS_UNSAVED_CHANGES = 1;
    protected static final int F_IS_READ_ONLY = 2;
    protected static final int F_IS_CLOSED = 4;

    protected Buffer(IFile file, IOpenable owner, boolean readOnly) {
        this.file = file;
        this.owner = owner;
        if (file == null) {
            this.setReadOnly(readOnly);
        }
    }

    @Override
    public void addBufferChangedListener(IBufferChangedListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(5);
        }
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    @Override
    public void append(char[] text) {
        if (!this.isReadOnly()) {
            if (text == null || text.length == 0) {
                return;
            }
            int length = this.getLength();
            this.moveAndResizeGap(length, text.length);
            System.arraycopy(text, 0, this.contents, length, text.length);
            this.gapStart += text.length;
            this.flags |= 1;
            this.notifyChanged(new BufferChangedEvent(this, length, 0, new String(text)));
        }
    }

    @Override
    public void append(String text) {
        if (text == null) {
            return;
        }
        this.append(text.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        BufferChangedEvent event = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            event = new BufferChangedEvent(this, 0, 0, null);
            this.contents = null;
            this.flags |= 4;
        }
        this.notifyChanged(event);
        this.changeListeners = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getChar(int position) {
        Object object = this.lock;
        synchronized (object) {
            if (position < this.gapStart) {
                return this.contents[position];
            }
            int gapLength = this.gapEnd - this.gapStart;
            return this.contents[position + gapLength];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] getCharacters() {
        if (this.contents == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.gapStart < 0) {
                return this.contents;
            }
            int length = this.contents.length;
            char[] newContents = new char[length - this.gapEnd + this.gapStart];
            System.arraycopy(this.contents, 0, newContents, 0, this.gapStart);
            System.arraycopy(this.contents, this.gapEnd, newContents, this.gapStart, length - this.gapEnd);
            return newContents;
        }
    }

    @Override
    public String getContents() {
        if (this.contents == null) {
            return null;
        }
        return new String(this.getCharacters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLength() {
        Object object = this.lock;
        synchronized (object) {
            int length = this.gapEnd - this.gapStart;
            return this.contents.length - length;
        }
    }

    @Override
    public IOpenable getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText(int offset, int length) {
        if (this.contents == null) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            if (offset + length < this.gapStart) {
                return new String(this.contents, offset, length);
            }
            if (this.gapStart < offset) {
                int gapLength = this.gapEnd - this.gapStart;
                return new String(this.contents, offset + gapLength, length);
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.contents, offset, this.gapStart - offset);
            buf.append(this.contents, this.gapEnd, offset + length - this.gapStart);
            return buf.toString();
        }
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.file;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isClosed() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isReadOnly() {
        if (this.file == null) {
            return (this.flags & 2) != 0;
        }
        return this.file.isReadOnly();
    }

    protected void notifyChanged(final BufferChangedEvent event) {
        if (this.changeListeners != null) {
            int i = 0;
            int size = this.changeListeners.size();
            while (i < size) {
                final IBufferChangedListener listener = this.changeListeners.get(i);
                SafeRunner.run(new ISafeRunnable(){

                    @Override
                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of buffer change notification", ICLogConstants.CDT);
                    }

                    @Override
                    public void run() throws Exception {
                        listener.bufferChanged(event);
                    }
                });
                ++i;
            }
        }
    }

    @Override
    public void removeBufferChangedListener(IBufferChangedListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int position, int length, char[] text) {
        if (!this.isReadOnly()) {
            int textLength = text == null ? 0 : text.length;
            Object object = this.lock;
            synchronized (object) {
                this.moveAndResizeGap(position + length, textLength - length);
                int min2 = Math.min(textLength, length);
                if (min2 > 0) {
                    System.arraycopy(text, 0, this.contents, position, min2);
                }
                if (length > textLength) {
                    this.gapStart -= length - textLength;
                } else if (textLength > length) {
                    this.gapStart += textLength - length;
                    System.arraycopy(text, 0, this.contents, position, textLength);
                }
            }
            this.flags |= 1;
            String string = null;
            if (textLength > 0) {
                string = new String(text);
            }
            this.notifyChanged(new BufferChangedEvent(this, position, length, string));
        }
    }

    @Override
    public void replace(int position, int length, String text) {
        this.replace(position, length, text == null ? null : text.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(IProgressMonitor progress, boolean force) throws CModelException {
        if (this.isReadOnly() || this.file == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.hasUnsavedChanges()) {
                return;
            }
            try {
                String encoding = null;
                try {
                    encoding = this.file.getCharset();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                String contents = this.getContents();
                if (contents == null) {
                    return;
                }
                byte[] bytes = encoding == null ? contents.getBytes() : contents.getBytes(encoding);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                if (this.file.exists()) {
                    this.file.setContents((InputStream)stream, force ? 3 : 2, null);
                } else {
                    this.file.create((InputStream)stream, force, null);
                }
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
            catch (CoreException e) {
                throw new CModelException(e);
            }
            this.flags &= 0xFFFFFFFE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(char[] newContents) {
        if (this.contents == null) {
            this.contents = newContents;
            this.flags &= 0xFFFFFFFE;
            return;
        }
        if (!this.isReadOnly()) {
            String string = null;
            if (newContents != null) {
                string = new String(newContents);
            }
            BufferChangedEvent event = new BufferChangedEvent(this, 0, this.getLength(), string);
            Object object = this.lock;
            synchronized (object) {
                this.contents = newContents;
                this.flags |= 1;
                this.gapStart = -1;
                this.gapEnd = -1;
            }
            this.notifyChanged(event);
        }
    }

    @Override
    public void setContents(String newContents) {
        this.setContents(newContents.toCharArray());
    }

    protected void moveAndResizeGap(int position, int size) {
        char[] content = null;
        int oldSize = this.gapEnd - this.gapStart;
        if (size < 0) {
            if (oldSize > 0) {
                content = new char[this.contents.length - oldSize];
                System.arraycopy(this.contents, 0, content, 0, this.gapStart);
                System.arraycopy(this.contents, this.gapEnd, content, this.gapStart, content.length - this.gapStart);
                this.contents = content;
            }
            this.gapStart = this.gapEnd = position;
            return;
        }
        content = new char[this.contents.length + (size - oldSize)];
        int newGapStart = position;
        int newGapEnd = newGapStart + size;
        if (oldSize == 0) {
            System.arraycopy(this.contents, 0, content, 0, newGapStart);
            System.arraycopy(this.contents, newGapStart, content, newGapEnd, content.length - newGapEnd);
        } else if (newGapStart < this.gapStart) {
            int delta = this.gapStart - newGapStart;
            System.arraycopy(this.contents, 0, content, 0, newGapStart);
            System.arraycopy(this.contents, newGapStart, content, newGapEnd, delta);
            System.arraycopy(this.contents, this.gapEnd, content, newGapEnd + delta, this.contents.length - this.gapEnd);
        } else {
            int delta = newGapStart - this.gapStart;
            System.arraycopy(this.contents, 0, content, 0, this.gapStart);
            System.arraycopy(this.contents, this.gapEnd, content, this.gapStart, delta);
            System.arraycopy(this.contents, this.gapEnd + delta, content, newGapEnd, content.length - newGapEnd);
        }
        this.contents = content;
        this.gapStart = newGapStart;
        this.gapEnd = newGapEnd;
    }

    protected void setReadOnly(boolean readOnly) {
        this.flags = readOnly ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Owner: ").append(((CElement)((Object)this.owner)).toString());
        buffer.append("\nHas unsaved changes: ").append(this.hasUnsavedChanges());
        buffer.append("\nIs readonly: ").append(this.isReadOnly());
        buffer.append("\nIs closed: ").append(this.isClosed());
        buffer.append("\nContents:\n");
        char[] contents = this.getCharacters();
        if (contents == null) {
            buffer.append("<null>");
        } else {
            int length = contents.length;
            int i = 0;
            while (i < length) {
                char car = contents[i];
                switch (car) {
                    case '\n': {
                        buffer.append("\\n\n");
                        break;
                    }
                    case '\r': {
                        if (i < length - 1 && this.contents[i + 1] == '\n') {
                            buffer.append("\\r\\n\n");
                            ++i;
                            break;
                        }
                        buffer.append("\\r\n");
                        break;
                    }
                    default: {
                        buffer.append(car);
                    }
                }
                ++i;
            }
        }
        return buffer.toString();
    }
}

