/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConversionName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClosureSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethodTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPlaceholderType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.core.runtime.PlatformObject;

public class CPPClosureType
extends PlatformObject
implements ICPPClassType,
ICPPInternalBinding {
    private final ICPPASTLambdaExpression fLambdaExpression;
    private IType[] fParameterTypes;
    private ICPPParameter[] fParameters;
    protected ICPPMethod[] fMethods;
    private ClassScope fScope;
    private ICPPTemplateParameter[] fInventedTemplateParameters;

    public CPPClosureType(ICPPASTLambdaExpression lambdaExpr) {
        this.fLambdaExpression = lambdaExpr;
    }

    private ICPPMethod[] createMethods() {
        boolean needConversionOperator = this.fLambdaExpression.getCaptureDefault() == ICPPASTLambdaExpression.CaptureDefault.UNSPECIFIED && this.fLambdaExpression.getCaptures().length == 0;
        ICPPClassScope scope = this.getCompositeScope();
        ICPPMethod[] result = new ICPPMethod[needConversionOperator ? 6 : 5];
        CPPImplicitConstructor ctor = new CPPImplicitConstructor(scope, CharArrayUtils.EMPTY, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, this.fLambdaExpression);
        ctor.setDeleted(true);
        result[0] = ctor;
        CPPReferenceType pType = new CPPReferenceType(SemanticUtil.constQualify(this), false);
        IParameter[] ps = new ICPPParameter[]{new CPPParameter(pType, 0)};
        ctor = new CPPImplicitConstructor(scope, CharArrayUtils.EMPTY, (ICPPParameter[])ps, this.fLambdaExpression);
        result[1] = ctor;
        CPPReferenceType refType = new CPPReferenceType(this, false);
        ICPPFunctionType ft = CPPVisitor.createImplicitFunctionType(refType, ps, false, false);
        CPPImplicitMethod m3 = new CPPImplicitMethod(scope, OverloadableOperator.ASSIGN.toCharArray(), ft, (ICPPParameter[])ps, false);
        result[2] = m3;
        ft = CPPVisitor.createImplicitFunctionType(CPPBasicType.UNSPECIFIED_TYPE, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, false, false);
        m3 = new CPPImplicitMethod(scope, new char[]{'~'}, ft, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, false);
        result[3] = m3;
        IType returnType = this.getReturnType();
        IType[] parameterTypes = this.getParameterTypes();
        ft = new CPPFunctionType(returnType, parameterTypes, this.getNoexceptEvaluation(), !this.isMutable(), false, false, false, false);
        ICPPParameter[] params = this.getParameters();
        char[] operatorParensName = OverloadableOperator.PAREN.toCharArray();
        m3 = this.isGeneric() ? new CPPImplicitMethodTemplate(this.getInventedTemplateParameterList(), scope, operatorParensName, ft, params, false){

            @Override
            public boolean isImplicit() {
                return false;
            }
        } : new CPPImplicitMethod(scope, operatorParensName, ft, params, false){

            @Override
            public boolean isImplicit() {
                return false;
            }
        };
        result[4] = m3;
        if (needConversionOperator) {
            CPPFunctionType conversionTarget = new CPPFunctionType(returnType, parameterTypes, null);
            ft = new CPPFunctionType(conversionTarget, IType.EMPTY_TYPE_ARRAY, CPPASTFunctionDeclarator.NOEXCEPT_TRUE, true, false, false, false, false);
            char[] conversionOperatorName = CPPASTConversionName.createName("__fptr");
            if (this.isGeneric()) {
                ICPPTemplateParameter[] templateParams = this.getInventedTemplateParameterList();
                ICPPTemplateParameter[] templateParamClones = new ICPPTemplateParameter[templateParams.length];
                int i = 0;
                while (i < templateParams.length) {
                    templateParamClones[i] = (ICPPTemplateParameter)((IType)((Object)templateParams[i])).clone();
                    ++i;
                }
                m3 = new CPPImplicitMethodTemplate(templateParamClones, scope, conversionOperatorName, ft, params, false){

                    @Override
                    public boolean isImplicit() {
                        return false;
                    }
                };
            } else {
                m3 = new CPPImplicitMethod(scope, conversionOperatorName, ft, params, false){

                    @Override
                    public boolean isImplicit() {
                        return false;
                    }
                };
            }
            result[5] = m3;
        }
        return result;
    }

    public ICPPMethod getFunctionCallOperator() {
        return this.getMethods()[4];
    }

    public ICPPMethod getConversionOperator() {
        ICPPMethod[] methods = this.getMethods();
        return methods.length >= 6 ? methods[5] : null;
    }

    private boolean isMutable() {
        ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
        return lambdaDtor != null && lambdaDtor.isMutable();
    }

    private IType getReturnType() {
        IASTCompoundStatement body;
        IASTTypeId trailingReturnType;
        IASTDeclSpecifier declSpecForDeduction = null;
        IASTDeclarator declaratorForDeduction = null;
        ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
        CPPPlaceholderType.PlaceholderKind placeholder = null;
        if (lambdaDtor != null && (trailingReturnType = lambdaDtor.getTrailingReturnType()) != null) {
            IASTDeclSpecifier declSpec = trailingReturnType.getDeclSpecifier();
            placeholder = CPPVisitor.usesAuto(declSpec);
            if (placeholder != null) {
                declSpecForDeduction = declSpec;
                declaratorForDeduction = trailingReturnType.getAbstractDeclarator();
            } else {
                return CPPVisitor.createType(trailingReturnType);
            }
        }
        if ((body = this.fLambdaExpression.getBody()) != null) {
            return CPPVisitor.deduceReturnType(body, declSpecForDeduction, declaratorForDeduction, placeholder);
        }
        return ProblemType.CANNOT_DEDUCE_AUTO_TYPE;
    }

    public boolean isGeneric() {
        return this.getInventedTemplateParameterList().length > 0;
    }

    public ICPPTemplateParameter[] getInventedTemplateParameterList() {
        if (this.fInventedTemplateParameters == null) {
            this.fInventedTemplateParameters = this.computeInventedTemplateParameterList();
        }
        return this.fInventedTemplateParameters;
    }

    public ICPPTemplateParameter[] computeInventedTemplateParameterList() {
        ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
        ICPPTemplateParameter[] result = ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
        if (lambdaDtor != null) {
            ICPPASTParameterDeclaration[] params;
            int position = 0;
            ICPPASTParameterDeclaration[] iCPPASTParameterDeclarationArray = params = lambdaDtor.getParameters();
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTParameterDeclaration param = iCPPASTParameterDeclarationArray[n2];
                IASTDeclSpecifier declSpec = param.getDeclSpecifier();
                if (declSpec instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)declSpec).getType() == 10) {
                    boolean isPack = param.getDeclarator().declaresParameterPack();
                    result = ArrayUtil.append(result, new CPPImplicitTemplateTypeParameter(this.fLambdaExpression, position, isPack));
                    ++position;
                }
                ++n2;
            }
        }
        return ArrayUtil.trim(result);
    }

    private IType[] getParameterTypes() {
        if (this.fParameterTypes == null) {
            ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
            this.fParameterTypes = lambdaDtor != null ? CPPVisitor.createParameterTypes(lambdaDtor) : IType.EMPTY_TYPE_ARRAY;
        }
        return this.fParameterTypes;
    }

    private ICPPEvaluation getNoexceptEvaluation() {
        ICPPEvaluation eval = null;
        if (this.fLambdaExpression.getDeclarator() != null) {
            eval = this.fLambdaExpression.getDeclarator().getNoexceptEvaluation();
        }
        return eval;
    }

    public ICPPParameter[] getParameters() {
        if (this.fParameters == null) {
            IType[] parameterTypes = this.getParameterTypes();
            this.fParameters = new ICPPParameter[parameterTypes.length];
            ICPPASTFunctionDeclarator lambdaDtor = this.fLambdaExpression.getDeclarator();
            if (lambdaDtor != null) {
                ICPPASTParameterDeclaration[] paramDecls = lambdaDtor.getParameters();
                int i = 0;
                while (i < this.fParameters.length) {
                    CPPParameter param = new CPPParameter(parameterTypes[i], i);
                    param.addDeclaration(paramDecls[i].getDeclarator().getName());
                    this.fParameters[i] = param;
                    ++i;
                }
            }
        }
        return this.fParameters;
    }

    @Override
    public final String getName() {
        return "";
    }

    @Override
    public char[] getNameCharArray() {
        return CharArrayUtils.EMPTY;
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.fLambdaExpression);
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        if (this.fScope == null) {
            this.fScope = new ClassScope();
        }
        return this.fScope;
    }

    @Override
    public int getKey() {
        return 3;
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() {
        return this.getOwner() == null;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == null) {
            return false;
        }
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        if (!this.getClass().equals(type.getClass())) {
            return false;
        }
        return this.fLambdaExpression.getFileLocation().equals(((CPPClosureType)type).fLambdaExpression.getFileLocation());
    }

    @Override
    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    public ICPPField[] getFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public ICPPMethod[] getMethods() {
        if (this.fMethods == null) {
            this.fMethods = this.createMethods();
        }
        return this.fMethods;
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        ICPPMethod[] methods = this.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!(methods[i] instanceof ICPPConstructor)) break;
            ++i;
        }
        ICPPConstructor[] result = new ICPPConstructor[i];
        System.arraycopy(methods, 0, result, 0, i);
        return result;
    }

    @Override
    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public ICPPUsingDeclaration[] getUsingDeclarations() {
        return ICPPUsingDeclaration.EMPTY_USING_DECL_ARRAY;
    }

    @Override
    public IField findField(String name) {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return this.fLambdaExpression.getRawSignature();
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findDeclarationOwner(this.fLambdaExpression, true);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public IASTNode getDefinition() {
        return this.fLambdaExpression;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return IASTNode.EMPTY_NODE_ARRAY;
    }

    @Override
    public void addDefinition(IASTNode node) {
    }

    @Override
    public void addDeclaration(IASTNode node) {
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public int getVisibility(IBinding member) {
        ICPPMethod[] iCPPMethodArray = this.fMethods;
        int n = this.fMethods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (method.equals(member)) {
                return 1;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(member.getName()) + " is not a member of closure type '" + this.fLambdaExpression.getRawSignature() + "'");
    }

    public CPPClosureType instantiate(InstantiationContext context) {
        return new CPPClosureSpecialization(this.fLambdaExpression, this, context);
    }

    private final class ClassScope
    implements ICPPClassScope {
        private ClassScope() {
        }

        @Override
        public EScopeKind getKind() {
            return EScopeKind.eClassType;
        }

        @Override
        public IName getScopeName() {
            return null;
        }

        @Override
        public IScope getParent() {
            return CPPClosureType.this.getScope();
        }

        private IBinding getBinding(char[] name) {
            ICPPMethod[] iCPPMethodArray = CPPClosureType.this.getMethods();
            int n = iCPPMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod m3 = iCPPMethodArray[n2];
                if (!(m3 instanceof ICPPConstructor) && CharArrayUtils.equals(name, m3.getNameCharArray())) {
                    return m3;
                }
                ++n2;
            }
            return null;
        }

        private IBinding[] getBindings(char[] name) {
            IBinding m3 = this.getBinding(name);
            if (m3 != null) {
                return new IBinding[]{m3};
            }
            return IBinding.EMPTY_BINDING_ARRAY;
        }

        private IBinding[] getPrefixBindings(char[] name) {
            ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
            IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(name);
            ICPPMethod[] iCPPMethodArray = CPPClosureType.this.getMethods();
            int n = iCPPMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod m3 = iCPPMethodArray[n2];
                if (!(m3 instanceof ICPPConstructor) && matcher.match(m3.getNameCharArray())) {
                    result.add(m3);
                }
                ++n2;
            }
            return result.toArray(new IBinding[result.size()]);
        }

        @Override
        public IBinding[] find(String name, IASTTranslationUnit tu) {
            return this.find(name);
        }

        @Override
        public IBinding[] find(String name) {
            return this.getBindings(name.toCharArray());
        }

        @Override
        public IBinding getBinding(IASTName name, boolean resolve) {
            if (name instanceof ICPPASTTemplateId) {
                return null;
            }
            return this.getBinding(name.getSimpleID());
        }

        @Override
        public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet acceptLocalBindings) {
            return this.getBinding(name, resolve);
        }

        @Override
        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) {
            return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
        }

        @Override
        @Deprecated
        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet acceptLocalBindings) {
            return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
        }

        @Override
        public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
            if (lookup.getLookupName() instanceof ICPPASTTemplateId) {
                return IBinding.EMPTY_BINDING_ARRAY;
            }
            if (lookup.isPrefixLookup()) {
                return this.getPrefixBindings(lookup.getLookupKey());
            }
            return this.getBindings(lookup.getLookupKey());
        }

        @Override
        public ICPPClassType getClassType() {
            return CPPClosureType.this;
        }

        @Override
        public ICPPMethod[] getImplicitMethods() {
            return CPPClosureType.this.getMethods();
        }

        @Override
        public ICPPConstructor[] getConstructors() {
            return CPPClosureType.this.getConstructors();
        }
    }
}

