/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalInitList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalUtil;
import org.eclipse.core.runtime.CoreException;

public final class CompositeValue
implements IValue {
    public static boolean sDEBUG;
    private final ICPPEvaluation evaluation;
    private final ICPPEvaluation[] values;
    private static final ThreadLocal<Set<ICPPClassType>> fCreateInProgress;

    static {
        fCreateInProgress = new ThreadLocal<Set<ICPPClassType>>(){

            @Override
            protected Set<ICPPClassType> initialValue() {
                return new TreeSet<ICPPClassType>((type1, type2) -> {
                    if (type1.isSameType((IType)type2)) {
                        return 0;
                    }
                    return ASTTypeUtil.getType(type1, true).compareTo(ASTTypeUtil.getType(type2, true));
                });
            }
        };
    }

    public CompositeValue(ICPPEvaluation evaluation, ICPPEvaluation[] values) {
        this.evaluation = evaluation;
        int i = 0;
        while (i < values.length) {
            if (values[i] == null) {
                values[i] = EvalFixed.INCOMPLETE;
            }
            ++i;
        }
        this.values = values;
    }

    @Override
    public Number numberValue() {
        return null;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return this.evaluation;
    }

    @Override
    public char[] getSignature() {
        if (this.evaluation != null) {
            return this.evaluation.getSignature();
        }
        return new char[0];
    }

    @Override
    public int numberOfSubValues() {
        return this.values.length;
    }

    @Override
    public ICPPEvaluation getSubValue(int index) {
        return this.rangeIsValid(index) ? this.values[index] : EvalFixed.INCOMPLETE;
    }

    private boolean rangeIsValid(int index) {
        return index >= 0 && index < this.values.length;
    }

    public static IValue create(EvalInitList initList) {
        ICPPEvaluation[] clauses = initList.getClauses();
        ICPPEvaluation[] values = new ICPPEvaluation[clauses.length];
        int i = 0;
        while (i < clauses.length) {
            ICPPEvaluation eval = clauses[i];
            values[i] = new EvalFixed(eval.getType(), eval.getValueCategory(), eval.getValue());
            ++i;
        }
        return new CompositeValue(initList, values);
    }

    public static IValue create(EvalInitList initList, IArrayType type) {
        Number arraySize = type.getSize().numberValue();
        if (arraySize == null) {
            return IntegralValue.UNKNOWN;
        }
        if (arraySize.intValue() < initList.getClauses().length) {
            return IntegralValue.ERROR;
        }
        IType elementType = type.getType();
        ICPPEvaluation[] values = new ICPPEvaluation[arraySize.intValue()];
        int i = 0;
        while (i < initList.getClauses().length) {
            ICPPEvaluation eval = initList.getClauses()[i];
            IValue value = CompositeValue.getValue(elementType, eval);
            values[i] = new EvalFixed(elementType, eval.getValueCategory(), value);
            ++i;
        }
        return new CompositeValue(initList, values);
    }

    private static IValue getValue(IType type, ICPPEvaluation eval) {
        IValue value = type instanceof IArrayType && eval instanceof EvalInitList ? CompositeValue.create((EvalInitList)eval, (IArrayType)type) : (type instanceof ICompositeType && eval instanceof EvalInitList ? CompositeValue.create((EvalInitList)eval, (ICompositeType)type) : (eval instanceof EvalInitList ? IntegralValue.UNKNOWN : eval.getValue()));
        return value;
    }

    public static IValue create(EvalInitList initList, ICompositeType type) {
        IField[] fields = type instanceof ICPPClassType ? ClassTypeHelper.getFields((ICPPClassType)type) : type.getFields();
        ICPPEvaluation[] values = new ICPPEvaluation[fields.length];
        ICPPEvaluation[] clauses = initList.getClauses();
        int i = 0;
        while (i < fields.length) {
            if (i == clauses.length) break;
            IField field = fields[i];
            ICPPEvaluation eval = clauses[i];
            IType fieldType = field.getType();
            IValue value = CompositeValue.getValue(fieldType, eval);
            values[i] = new EvalFixed(fieldType, eval.getValueCategory(), value);
            ++i;
        }
        return new CompositeValue(initList, values);
    }

    public static CompositeValue create(ICPPClassType classType) {
        return CompositeValue.create(classType, 0);
    }

    public static CompositeValue create(ICPPClassType classType, int nestingLevel) {
        Set<ICPPClassType> recursionProtectionSet = fCreateInProgress.get();
        if (!recursionProtectionSet.add(classType)) {
            return new CompositeValue(null, ICPPEvaluation.EMPTY_ARRAY);
        }
        try {
            ICPPField[] fields;
            ICPPBase[] bases;
            if (sDEBUG && nestingLevel > 0) {
                System.out.println("CompositeValue.create(" + ASTTypeUtil.getType(classType) + ", " + nestingLevel + ")");
                System.out.flush();
            }
            ActivationRecord record = new ActivationRecord();
            ICPPEvaluation[] values = new ICPPEvaluation[ClassTypeHelper.getFields(classType).length];
            ICPPBase[] iCPPBaseArray = bases = classType.getBases();
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase base = iCPPBaseArray[n2];
                IBinding baseClass = base.getBaseClass();
                if (baseClass instanceof ICPPClassType) {
                    ICPPClassType baseClassType = (ICPPClassType)baseClass;
                    ICPPField[] baseFields = baseClassType.getDeclaredFields();
                    CompositeValue compValue = CompositeValue.create(baseClassType, nestingLevel + 1);
                    ICPPField[] iCPPFieldArray = baseFields;
                    int n3 = baseFields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICPPField baseField = iCPPFieldArray[n4];
                        int fieldPos = CPPASTFieldReference.getFieldPosition(baseField);
                        if (fieldPos != -1) {
                            record.update(baseField, compValue.getSubValue(fieldPos));
                            values[fieldPos] = compValue.getSubValue(fieldPos);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            ICPPField[] iCPPFieldArray = fields = classType.getDeclaredFields();
            int n5 = fields.length;
            n = 0;
            while (n < n5) {
                ICPPField field = iCPPFieldArray[n];
                if (!field.isStatic()) {
                    ICPPEvaluation value = EvalUtil.getVariableValue(field, record);
                    int fieldPos = CPPASTFieldReference.getFieldPosition(field);
                    if (fieldPos != -1) {
                        record.update(field, value);
                        values[fieldPos] = value;
                    }
                }
                ++n;
            }
            CompositeValue compositeValue = new CompositeValue(null, values);
            return compositeValue;
        }
        finally {
            recursionProtectionSet.remove(classType);
        }
    }

    @Override
    public ICPPEvaluation[] getAllSubValues() {
        return this.values;
    }

    @Override
    public void setSubValue(int position, ICPPEvaluation newValue) {
        if (position >= 0 && position < this.values.length) {
            this.values[position] = newValue == null ? EvalFixed.INCOMPLETE : newValue;
        } else {
            CCorePlugin.log(2, "Out-of-bounds access to composite value: " + position + " (length is " + this.values.length + ")");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int i = 0;
        while (i < this.values.length) {
            if (i != 0) {
                builder.append(',').append(' ');
            }
            builder.append(this.values[i].toString());
            ++i;
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public IValue clone() {
        ICPPEvaluation[] newValues = new ICPPEvaluation[this.values.length];
        int i = 0;
        while (i < newValues.length) {
            ICPPEvaluation eval = this.values[i];
            if (eval == EvalFixed.INCOMPLETE) {
                newValues[i] = eval;
            } else {
                IValue newValue = eval.getValue().clone();
                newValues[i] = new EvalFixed(eval.getType(), eval.getValueCategory(), newValue);
            }
            ++i;
        }
        return new CompositeValue(this.evaluation, newValues);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buf) throws CoreException {
        buf.putShort((short)4);
        buf.marshalEvaluation(this.evaluation, true);
        buf.putInt(this.values.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation value = iCPPEvaluationArray[n2];
            buf.marshalEvaluation(value, true);
            ++n2;
        }
    }

    public static IValue unmarshal(short firstBytes, ITypeMarshalBuffer buf) throws CoreException {
        ICPPEvaluation evaluation = buf.unmarshalEvaluation();
        int len = buf.getInt();
        ICPPEvaluation[] values = new ICPPEvaluation[len];
        int i = 0;
        while (i < len) {
            values[i] = buf.unmarshalEvaluation();
            ++i;
        }
        return new CompositeValue(evaluation, values);
    }

    @Override
    public boolean isEquivalentTo(IValue other) {
        if (!(other instanceof CompositeValue)) {
            return false;
        }
        CompositeValue o = (CompositeValue)other;
        if (!(this.evaluation == null && o.evaluation == null || this.evaluation.isEquivalentTo(o.evaluation))) {
            return false;
        }
        if (this.values.length != o.values.length) {
            return false;
        }
        int i = 0;
        while (i < this.values.length) {
            if (!this.values[i].isEquivalentTo(o.values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

