/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.LRUCache;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class Cygwin {
    public static final String ENV_CYGWIN_HOME = "CYGWIN_HOME";
    private static final String ENV_PATH = "PATH";
    private static final String CYGPATH = "cygpath";
    private static final String DEFAULT_ROOT = "C:\\cygwin";
    private static final String CYGWIN_DLL = "cygwin1.dll";
    private static final String REGISTRY_KEY_SETUP = "SOFTWARE\\Cygwin\\setup";
    private static final String REGISTRY_KEY_SETUP_WIN64 = "SOFTWARE\\Wow6432Node\\Cygwin\\setup";
    private static final String REGISTRY_KEY_MOUNTS = "SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\";
    private static final String PATH_NAME = "native";
    private static final String ROOTPATTERN = "/";
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private static final boolean isWindowsPlatform = Platform.getOS().equals("win32");
    private static String envPathValueCached = null;
    private static String envCygwinHomeValueCached = null;
    private static String cygwinLocation = null;
    private static boolean isCygwinLocationCached = false;
    private static final Map<String, String> cygpathLocationCache = Collections.synchronizedMap(new LRUCache(1, 20));
    private static final Map<String, String> translatedPathsCache = Collections.synchronizedMap(new LRUCache(10, 500));

    private static String findCygpathLocation(String envPath) {
        String cygpathLocation;
        IEnvironmentVariable varPath;
        if (envPath == null && (varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, (ICConfigurationDescription)null, true)) != null) {
            envPath = varPath.getValue();
        }
        if ((cygpathLocation = cygpathLocationCache.get(envPath)) == null) {
            IPath loc = PathUtil.findProgramLocation(CYGPATH, envPath);
            cygpathLocation = loc != null ? loc.toOSString() : null;
            cygpathLocationCache.put(envPath, cygpathLocation);
        }
        return cygpathLocation;
    }

    public static boolean isAvailable(String envPath) {
        return isWindowsPlatform && Cygwin.findCygpathLocation(envPath) != null;
    }

    public static boolean isAvailable() {
        return isWindowsPlatform && Cygwin.findCygpathLocation(null) != null;
    }

    private static String runCygpath(String[] args) throws IOException {
        String command = Cygwin.getCommand(args);
        String translatedPath = translatedPathsCache.get(command);
        if (translatedPath == null) {
            Process cygpathProcess = Runtime.getRuntime().exec(args);
            String firstLine = null;
            try (BufferedReader stdout = new BufferedReader(new InputStreamReader(cygpathProcess.getInputStream()));){
                firstLine = stdout.readLine();
            }
            if (firstLine == null) {
                throw new IOException("Unable read output from command=[" + command + "]");
            }
            translatedPath = firstLine.trim();
            translatedPathsCache.put(command, translatedPath);
        }
        return translatedPath;
    }

    private static String getCommand(String[] args) {
        String command = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            command = String.valueOf(command) + arg + ' ';
            ++n2;
        }
        return command.trim();
    }

    public static String cygwinToWindowsPath(String cygwinPath, String envPath) throws IOException, UnsupportedOperationException {
        if (cygwinPath == null || cygwinPath.trim().length() == 0) {
            return cygwinPath;
        }
        if (!isWindowsPlatform) {
            throw new UnsupportedOperationException("Not a Windows system, Cygwin is unavailable.");
        }
        String cygpathLocation = Cygwin.findCygpathLocation(envPath);
        if (cygpathLocation == null) {
            throw new UnsupportedOperationException("cygpath is not in the system search path.");
        }
        String windowsPath = Cygwin.runCygpath(new String[]{cygpathLocation, "-w", cygwinPath});
        return windowsPath;
    }

    public static String cygwinToWindowsPath(String cygwinPath) throws IOException, UnsupportedOperationException {
        return Cygwin.cygwinToWindowsPath(cygwinPath, null);
    }

    public static String windowsToCygwinPath(String windowsPath, String envPath) throws IOException, UnsupportedOperationException {
        if (windowsPath == null || windowsPath.trim().length() == 0) {
            return windowsPath;
        }
        if (!isWindowsPlatform) {
            throw new UnsupportedOperationException("Not a Windows system, Cygwin is unavailable.");
        }
        String cygpathLocation = Cygwin.findCygpathLocation(envPath);
        if (cygpathLocation == null) {
            throw new UnsupportedOperationException("cygpath is not in the system search path.");
        }
        String cygwinPath = Cygwin.runCygpath(new String[]{cygpathLocation, "-u", windowsPath});
        return cygwinPath;
    }

    public static String windowsToCygwinPath(String windowsPath) throws IOException, UnsupportedOperationException {
        return Cygwin.windowsToCygwinPath(windowsPath, null);
    }

    public static String getCygwinHome() {
        String envCygwinHomeValue;
        if (!isWindowsPlatform) {
            return null;
        }
        IEnvironmentVariable varPath = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_PATH, (ICConfigurationDescription)null, true);
        String envPathValue = varPath != null ? varPath.getValue() : null;
        IEnvironmentVariable varCygwinHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable(ENV_CYGWIN_HOME, (ICConfigurationDescription)null, true);
        String string = envCygwinHomeValue = varCygwinHome != null ? varCygwinHome.getValue() : null;
        if (isCygwinLocationCached && CDataUtil.objectsEqual(envPathValue, envPathValueCached) && CDataUtil.objectsEqual(envCygwinHomeValue, envCygwinHomeValueCached)) {
            return cygwinLocation;
        }
        cygwinLocation = Cygwin.findCygwinRoot(envPathValue, envCygwinHomeValue);
        envPathValueCached = envPathValue;
        envCygwinHomeValueCached = envCygwinHomeValue;
        isCygwinLocationCached = true;
        return cygwinLocation;
    }

    private static String readValueFromRegistry(String key, String name) {
        WindowsRegistry registry = WindowsRegistry.getRegistry();
        if (registry != null) {
            String s2 = registry.getCurrentUserValue(key, name);
            if (s2 == null) {
                s2 = registry.getLocalMachineValue(key, name);
            }
            if (s2 != null) {
                return s2.replace('\\', '/');
            }
        }
        return null;
    }

    private static String findCygwinRoot(String envPathValue, String envCygwinHomeValue) {
        File file;
        IPath location;
        String rootValue = null;
        if (envCygwinHomeValue != null && !envCygwinHomeValue.isEmpty() && (location = new Path(String.valueOf(envCygwinHomeValue) + "/bin/" + CYGWIN_DLL)).toFile().exists()) {
            rootValue = location.removeLastSegments(2).toOSString();
        }
        if (rootValue == null && (location = PathUtil.findProgramLocation(CYGWIN_DLL, envPathValue)) != null) {
            rootValue = location.removeLastSegments(2).toOSString();
        }
        if (rootValue == null) {
            rootValue = Cygwin.readValueFromRegistry(REGISTRY_KEY_SETUP, "rootdir");
        }
        if (rootValue == null) {
            rootValue = Cygwin.readValueFromRegistry(REGISTRY_KEY_SETUP_WIN64, "rootdir");
        }
        if (rootValue == null) {
            rootValue = Cygwin.readValueFromRegistry("SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/", PATH_NAME);
        }
        if (rootValue == null && (file = new File(DEFAULT_ROOT)).exists() && file.isDirectory()) {
            rootValue = DEFAULT_ROOT;
        }
        if (rootValue != null) {
            rootValue = rootValue.replace('\\', '/');
        }
        return rootValue;
    }
}

