/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.templateengine.SharedDefaults;
import org.eclipse.cdt.core.templateengine.TemplateCategory;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine2;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.core.templateengine.TemplateInfo2;
import org.eclipse.cdt.core.templateengine.TemplateInitializationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateEngine {
    public static String TEMPLATES_EXTENSION_ID = "org.eclipse.cdt.core.templates";
    public static String TEMPLATE_ASSOCIATIONS_EXTENSION_ID = "org.eclipse.cdt.core.templateAssociations";
    private static TemplateEngine TEMPLATE_ENGINE;
    private Map<String, List<TemplateInfo>> templateInfoMap = new LinkedHashMap<String, List<TemplateInfo>>();
    Map<String, TemplateCategory> categoryMap = new HashMap<String, TemplateCategory>();

    TemplateEngine() {
        this.initializeTemplateInfoMap();
    }

    public TemplateCore[] getTemplates() {
        TemplateInfo[] templateInfoArray = this.getTemplateInfos();
        ArrayList<TemplateCore> tcores = new ArrayList<TemplateCore>();
        int i = 0;
        while (i < templateInfoArray.length) {
            TemplateInfo info = templateInfoArray[i];
            try {
                tcores.add(TemplateCore.getTemplate(info));
            }
            catch (TemplateInitializationException e) {
                CCorePlugin.log(CCorePlugin.createStatus(e.getMessage(), e));
            }
            ++i;
        }
        return tcores.toArray(new TemplateCore[tcores.size()]);
    }

    public TemplateCore getFirstTemplate(String projectType, String toolChain, String usageFilter) {
        TemplateInfo[] infos = this.getTemplateInfos(projectType, toolChain, usageFilter);
        if (infos.length > 0) {
            try {
                return TemplateCore.getTemplate(infos[0]);
            }
            catch (TemplateInitializationException tie) {
                CCorePlugin.log(tie);
            }
        }
        return null;
    }

    public TemplateCore getFirstTemplate(String projectType) {
        return this.getFirstTemplate(projectType, null, null);
    }

    public TemplateCore[] getTemplates(String projectType, String toolChain, String usageFilter) {
        TemplateInfo[] templateInfoArray = this.getTemplateInfos(projectType, toolChain, usageFilter);
        ArrayList<TemplateCore> templatesList = new ArrayList<TemplateCore>();
        int i = 0;
        while (i < templateInfoArray.length) {
            TemplateInfo info = templateInfoArray[i];
            try {
                templatesList.add(TemplateCore.getTemplate(info));
            }
            catch (TemplateInitializationException tie) {
                CCorePlugin.log(tie);
            }
            ++i;
        }
        return templatesList.toArray(new TemplateCore[templatesList.size()]);
    }

    public TemplateCore[] getTemplates(String projectType, String toolChain) {
        return this.getTemplates(projectType, toolChain, null);
    }

    public TemplateCore[] getTemplates(String projectType) {
        return this.getTemplates(projectType, null);
    }

    public TemplateCore getTemplateById(String templateId) {
        TemplateCore[] templates = this.getTemplates();
        int i = 0;
        while (i < templates.length) {
            TemplateCore template = templates[i];
            if (template.getTemplateId().equalsIgnoreCase(templateId)) {
                return template;
            }
            ++i;
        }
        return null;
    }

    public static Map<String, String> getSharedDefaults() {
        return SharedDefaults.getInstance().getSharedDefaultsMap();
    }

    public void updateSharedDefaults(TemplateCore template) {
        HashMap<String, String> tobePersisted = new HashMap<String, String>();
        Map<String, String> valueStore = template.getValueStore();
        for (String key : template.getPersistTrueIDs()) {
            tobePersisted.put(key, valueStore.get(key));
        }
        SharedDefaults.getInstance().updateShareDefaultsMap(tobePersisted);
    }

    public static TemplateEngine getDefault() {
        if (TEMPLATE_ENGINE == null) {
            TEMPLATE_ENGINE = new TemplateEngine2();
        }
        return TEMPLATE_ENGINE;
    }

    private void initializeTemplateInfoMap() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(TEMPLATES_EXTENSION_ID).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            String pluginId = extension.getNamespaceIdentifier();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement config = configElements[j];
                String configName = config.getName();
                if (configName.equals("template")) {
                    Object extraPagesProvider = null;
                    String templateId = config.getAttribute("id");
                    String location = config.getAttribute("location");
                    String projectType = config.getAttribute("projectType");
                    if (projectType == null || projectType.isEmpty()) {
                        projectType = "newTemplate";
                    }
                    String filterPattern = config.getAttribute("filterPattern");
                    boolean isCategory = Boolean.valueOf(config.getAttribute("isCategory"));
                    String providerAttribute = config.getAttribute("pagesAfterTemplateSelectionProvider");
                    if (providerAttribute != null) {
                        try {
                            extraPagesProvider = config.createExecutableExtension("pagesAfterTemplateSelectionProvider");
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(CCorePlugin.createStatus("Unable to create extra pages for " + providerAttribute, e));
                        }
                    }
                    IConfigurationElement[] toolChainConfigs = config.getChildren("toolChain");
                    LinkedHashSet<String> toolChainIdSet = new LinkedHashSet<String>();
                    IConfigurationElement[] iConfigurationElementArray = toolChainConfigs;
                    int n = toolChainConfigs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement toolChainConfig = iConfigurationElementArray[n2];
                        toolChainIdSet.add(toolChainConfig.getAttribute("id"));
                        ++n2;
                    }
                    IConfigurationElement[] parentCategoryConfigs = config.getChildren("parentCategory");
                    ArrayList<String> parentCategoryIds = new ArrayList<String>();
                    IConfigurationElement[] iConfigurationElementArray2 = parentCategoryConfigs;
                    int n3 = parentCategoryConfigs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement parentCategoryConfig = iConfigurationElementArray2[n4];
                        parentCategoryIds.add(parentCategoryConfig.getAttribute("id"));
                        ++n4;
                    }
                    TemplateInfo2 templateInfo = new TemplateInfo2(templateId, projectType, filterPattern, location, pluginId, toolChainIdSet, extraPagesProvider, isCategory, parentCategoryIds);
                    if (!this.templateInfoMap.containsKey(projectType)) {
                        this.templateInfoMap.put(projectType, new ArrayList());
                    }
                    this.templateInfoMap.get(projectType).add(templateInfo);
                } else if (configName.equals("category")) {
                    String id = config.getAttribute("id");
                    if (!id.contains(".")) {
                        id = String.valueOf(pluginId) + "." + id;
                    }
                    String label = config.getAttribute("label");
                    IConfigurationElement[] parentCategoryConfigs = config.getChildren("parentCategory");
                    ArrayList<String> parentCategoryIds = new ArrayList<String>();
                    IConfigurationElement[] iConfigurationElementArray = parentCategoryConfigs;
                    int n = parentCategoryConfigs.length;
                    int n5 = 0;
                    while (n5 < n) {
                        IConfigurationElement parentCategoryConfig = iConfigurationElementArray[n5];
                        parentCategoryIds.add(parentCategoryConfig.getAttribute("id"));
                        ++n5;
                    }
                    this.categoryMap.put(id, new TemplateCategory(id, label, parentCategoryIds));
                }
                ++j;
            }
            ++i;
        }
        this.addToolChainsToTemplates();
    }

    private void addToolChainsToTemplates() {
        String templateId = null;
        TemplateCore[] templates = this.getTemplates();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(TEMPLATE_ASSOCIATIONS_EXTENSION_ID).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement config = configElements[j];
                templateId = config.getAttribute("id");
                IConfigurationElement[] toolChainConfigs = config.getChildren("toolChain");
                LinkedHashSet<String> toolChainIdSet = new LinkedHashSet<String>();
                int k = 0;
                while (k < toolChainConfigs.length) {
                    toolChainIdSet.add(toolChainConfigs[k].getAttribute("id"));
                    ++k;
                }
                k = 0;
                while (k < templates.length) {
                    String id = templates[k].getTemplateInfo().getTemplateId();
                    if (id == null) {
                        id = templates[k].getTemplateId();
                    }
                    if (id != null && id.equals(templateId)) {
                        toolChainIdSet.addAll(Arrays.asList(templates[k].getTemplateInfo().getToolChainIds()));
                        templates[k].getTemplateInfo().setToolChainSet(toolChainIdSet);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public TemplateInfo[] getTemplateInfos(String projectType, String toolChain, String usageFilter) {
        List<TemplateInfo> templateInfoList = this.templateInfoMap.get(projectType.trim());
        ArrayList<TemplateInfo> matchedTemplateInfoList = new ArrayList<TemplateInfo>();
        if (templateInfoList != null) {
            for (TemplateInfo templateInfo : templateInfoList) {
                String filterPattern = templateInfo.getFilterPattern();
                String[] toolChains = templateInfo.getToolChainIds();
                if (toolChain != null) {
                    int j = 0;
                    while (j < toolChains.length) {
                        if (toolChains[j].equals(toolChain)) {
                            if (usageFilter != null && filterPattern != null && usageFilter.matches(filterPattern)) {
                                matchedTemplateInfoList.add(templateInfo);
                            } else if (usageFilter == null || filterPattern == null) {
                                matchedTemplateInfoList.add(templateInfo);
                            }
                        }
                        ++j;
                    }
                    continue;
                }
                if (usageFilter != null && filterPattern != null && usageFilter.matches(filterPattern)) {
                    matchedTemplateInfoList.add(templateInfo);
                    continue;
                }
                if (usageFilter != null && filterPattern != null) continue;
                matchedTemplateInfoList.add(templateInfo);
            }
        }
        return matchedTemplateInfoList.toArray(new TemplateInfo[matchedTemplateInfoList.size()]);
    }

    public TemplateInfo[] getTemplateInfos(String projectType, String toolChain) {
        return this.getTemplateInfos(projectType, toolChain, null);
    }

    public TemplateInfo[] getTemplateInfos(String projectType) {
        return this.getTemplateInfos(projectType, null, null);
    }

    public TemplateInfo[] getTemplateInfos() {
        ArrayList<TemplateInfo> infoList = new ArrayList<TemplateInfo>();
        for (List<TemplateInfo> infos : this.templateInfoMap.values()) {
            infoList.addAll(infos);
        }
        return infoList.toArray(new TemplateInfo[infoList.size()]);
    }

    public Map<String, List<TemplateInfo>> getTemplateInfoMap() {
        return this.templateInfoMap;
    }

    public URL getTemplateSchemaURL() throws IOException {
        return FileLocator.toFileURL(Platform.getBundle("org.eclipse.cdt.core").getEntry("schema/TemplateDescriptorSchema.xsd"));
    }

    public static List<Element> getChildrenOfElement(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                list.add((Element)child);
            }
            ++i;
        }
        return list;
    }

    public static List<Element> getChildrenOfElementByTag(Element element, String tag) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        int i = 0;
        int l = children.getLength();
        while (i < l) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(tag)) {
                list.add((Element)child);
            }
            ++i;
        }
        return list;
    }
}

