/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerListener;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PatternNameMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class PathSettingsContainer {
    private static final Object INEXISTENT_VALUE = new Object();
    private static final String ROOY_PATH_NAME = Path.ROOT.toString();
    private PatternNameMap fPatternChildrenMap;
    private Object fValue;
    private IPath fPath;
    private String fName;
    private PathSettingsContainer fRootContainer;
    private PathSettingsContainer fDirectParentContainer;
    private List<IPathSettingsContainerListener> fListeners;
    private boolean fIsPatternMode;
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private static final int VALUE_CHANGED = 3;
    private static final int PATH_CHANGED = 4;

    public static PathSettingsContainer createRootContainer() {
        return PathSettingsContainer.createRootContainer(false);
    }

    public static PathSettingsContainer createRootContainer(boolean patternMode) {
        return new PathSettingsContainer(patternMode);
    }

    private PathSettingsContainer(boolean pattternMode) {
        this(null, null, ROOY_PATH_NAME, pattternMode);
    }

    private PathSettingsContainer(PathSettingsContainer root, PathSettingsContainer parent, String name, boolean patternMode) {
        this.fRootContainer = root;
        this.fDirectParentContainer = parent;
        this.fName = name;
        this.fIsPatternMode = patternMode;
        if (this.fRootContainer == null) {
            this.fRootContainer = this;
        } else {
            this.fValue = INEXISTENT_VALUE;
        }
    }

    private PatternNameMap getPatternChildrenMap(boolean create) {
        if (this.fPatternChildrenMap == null && create) {
            this.fPatternChildrenMap = new PatternNameMap();
        }
        return this.fPatternChildrenMap;
    }

    private PathSettingsContainer getExacChild(String name, boolean create) {
        PatternNameMap pMap = this.getPatternChildrenMap(create);
        if (pMap != null) {
            PathSettingsContainer child = (PathSettingsContainer)pMap.get(name);
            if (child == null && create) {
                child = new PathSettingsContainer(this.fRootContainer, this, name, this.fIsPatternMode);
                this.connectChild(child);
            }
            return child;
        }
        return null;
    }

    private boolean isDoubleStarName() {
        return "**".equals(this.getName());
    }

    private PathSettingsContainer getDoubleStarChild() {
        PatternNameMap pMap = this.getPatternChildrenMap(false);
        if (pMap != null) {
            return pMap.containsDoubleStar() ? (PathSettingsContainer)pMap.get("**") : null;
        }
        return null;
    }

    private List<PathSettingsContainer> getChildren(String name) {
        PatternNameMap pMap = this.getPatternChildrenMap(false);
        if (pMap != null) {
            return pMap.getValues(name);
        }
        return null;
    }

    private void notifyChange(PathSettingsContainer container, int type, Object oldValue, boolean childrenAffected) {
        PathSettingsContainer parent;
        List<IPathSettingsContainerListener> list = this.getListenersList(false);
        if (list != null && list.size() > 0) {
            for (IPathSettingsContainerListener listener : list) {
                switch (type) {
                    case 1: {
                        listener.containerAdded(container);
                        break;
                    }
                    case 2: {
                        listener.aboutToRemove(container);
                        break;
                    }
                    case 3: {
                        listener.containerValueChanged(container, oldValue);
                        break;
                    }
                    case 4: {
                        listener.containerPathChanged(container, (IPath)oldValue, childrenAffected);
                    }
                }
            }
        }
        if ((parent = this.getParentContainer()) != null) {
            parent.notifyChange(container, type, oldValue, childrenAffected);
        }
    }

    private List<IPathSettingsContainerListener> getListenersList(boolean create) {
        if (this.fListeners == null && create) {
            this.fListeners = new ArrayList<IPathSettingsContainerListener>();
        }
        return this.fListeners;
    }

    public boolean hasChildren() {
        PatternNameMap pMap = this.getPatternChildrenMap(false);
        return pMap != null && pMap.size() != 0;
    }

    public PathSettingsContainer getChildContainer(IPath path, boolean create, boolean exactPath) {
        return this.getChildContainer(path, create, exactPath, this.fIsPatternMode);
    }

    public PathSettingsContainer getChildContainer(IPath path, boolean create, boolean exactPath, boolean patternSearch) {
        PathSettingsContainer container = this.findContainer(path, create, exactPath, patternSearch, -1, null);
        if (container != null && container.internalGetValue() == INEXISTENT_VALUE) {
            if (create) {
                container.internalSetValue(null);
                this.notifyChange(container, 1, null, false);
            } else if (!exactPath) {
                while (container.internalGetValue() == INEXISTENT_VALUE) {
                    container = container.getDirectParentContainer();
                }
            } else if (container.internalGetValue() == INEXISTENT_VALUE) {
                container = null;
            }
        }
        return container;
    }

    static IPath toNormalizedContainerPath(IPath path) {
        return Path.ROOT.append(path);
    }

    public PathSettingsContainer[] getChildren(final boolean includeThis) {
        final ArrayList list = new ArrayList();
        this.accept(new IPathSettingsContainerVisitor(){

            @Override
            public boolean visit(PathSettingsContainer container) {
                if (container != PathSettingsContainer.this || includeThis) {
                    list.add(container);
                }
                return true;
            }
        });
        return list.toArray(new PathSettingsContainer[list.size()]);
    }

    public PathSettingsContainer[] getChildrenForPath(IPath path, boolean includePath) {
        PathSettingsContainer cr = this.findContainer(path, false, true, this.fIsPatternMode, -1, null);
        if (cr != null) {
            return cr.getChildren(includePath);
        }
        return new PathSettingsContainer[0];
    }

    public PathSettingsContainer[] getDirectChildrenForPath(IPath path) {
        PathSettingsContainer cr = this.findContainer(path, false, true, this.fIsPatternMode, -1, null);
        if (cr != null) {
            return cr.getDirectChildren();
        }
        return new PathSettingsContainer[0];
    }

    public PathSettingsContainer[] getDirectChildren() {
        List<PathSettingsContainer> list = this.doGetDirectChildren(null);
        if (list == null || list.size() == 0) {
            return new PathSettingsContainer[0];
        }
        return list.toArray(new PathSettingsContainer[list.size()]);
    }

    private List<PathSettingsContainer> doGetDirectChildren(List<PathSettingsContainer> list) {
        PatternNameMap pMap = this.getPatternChildrenMap(false);
        if (pMap != null) {
            if (list == null) {
                list = new ArrayList<PathSettingsContainer>();
            }
            for (PathSettingsContainer cr : pMap.values()) {
                if (cr.fValue == INEXISTENT_VALUE) {
                    cr.doGetDirectChildren(list);
                    continue;
                }
                list.add(cr);
            }
        }
        return list;
    }

    public Object[] getValues(final boolean includeThis) {
        final ArrayList list = new ArrayList();
        this.accept(new IPathSettingsContainerVisitor(){

            @Override
            public boolean visit(PathSettingsContainer container) {
                if (container != PathSettingsContainer.this || includeThis) {
                    list.add(container.getValue());
                }
                return true;
            }
        });
        return list.toArray();
    }

    public PathSettingsContainer getParentContainer() {
        if (this.fDirectParentContainer != null) {
            return this.fDirectParentContainer.getValidContainer();
        }
        return null;
    }

    private PathSettingsContainer getValidContainer() {
        if (this.internalGetValue() == INEXISTENT_VALUE) {
            return this.getDirectParentContainer().getValidContainer();
        }
        return this;
    }

    public Object removeChildContainer(IPath path) {
        PathSettingsContainer container = this.getChildContainer(path, false, true);
        Object value = null;
        if (container != null) {
            value = container.getValue();
            container.remove();
        }
        return value;
    }

    public void remove() {
        if (!this.isValid()) {
            return;
        }
        if (this.fValue != INEXISTENT_VALUE) {
            this.notifyChange(this, 2, null, false);
            this.internalSetValue(INEXISTENT_VALUE);
        }
        if (!this.hasChildren()) {
            if (this.fDirectParentContainer != null) {
                this.fDirectParentContainer.deleteChild(this);
                this.fDirectParentContainer.checkRemove();
                this.fDirectParentContainer = null;
            }
            this.fRootContainer = null;
        }
    }

    private void checkRemove() {
        if (this.fValue == INEXISTENT_VALUE && !this.hasChildren()) {
            this.remove();
        }
    }

    private void disconnectChild(PathSettingsContainer child) {
        this.getPatternChildrenMap(true).remove(child.getName());
    }

    private void connectChild(PathSettingsContainer child) {
        this.getPatternChildrenMap(true).put(child.getName(), (Object)child);
    }

    public boolean isValid() {
        return this.fValue != INEXISTENT_VALUE && this.fRootContainer != null;
    }

    public void removeChildren() {
        PathSettingsContainer[] childContainers;
        PatternNameMap pMap = this.getPatternChildrenMap(false);
        if (pMap == null || pMap.size() == 0) {
            return;
        }
        Collection<PathSettingsContainer> c = pMap.values();
        PathSettingsContainer[] pathSettingsContainerArray = childContainers = c.toArray(new PathSettingsContainer[c.size()]);
        int n = childContainers.length;
        int n2 = 0;
        while (n2 < n) {
            PathSettingsContainer childContainer = pathSettingsContainerArray[n2];
            childContainer.removeChildren();
            childContainer.remove();
            ++n2;
        }
    }

    private void deleteChild(PathSettingsContainer child) {
        this.getPatternChildrenMap(false).remove(child.getName());
    }

    private String getName() {
        return this.fName;
    }

    private PathSettingsContainer findContainer(IPath path, boolean create, boolean exactPath, boolean patternSearch, int matchDepth, PatternSearchInfo psi) {
        PathSettingsContainer container = null;
        if (path.segmentCount() == 0) {
            container = this;
        } else if (create || exactPath || !patternSearch || !this.fIsPatternMode) {
            PathSettingsContainer child = this.getExacChild(path.segment(0), create);
            if (child != null) {
                container = child.findContainer(path.removeFirstSegments(1), create, exactPath, patternSearch, this.stepDepth(matchDepth), psi);
            } else if (!exactPath) {
                container = this;
            }
        } else {
            if (psi == null) {
                psi = new PatternSearchInfo();
            }
            container = this.processPatterns(path, matchDepth, 0, psi);
        }
        return container;
    }

    /*
     * Unable to fully structure code
     */
    static boolean pathsEqual(IPath p1, IPath p2) {
        if (p1 == p2) {
            return true;
        }
        i = p1.segmentCount();
        if (i == p2.segmentCount()) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (p1.segment(i).equals(p2.segment(i))) continue;
            return false;
lbl8:
            // 2 sources

            ** while (--i >= 0)
        }
lbl9:
        // 1 sources

        return true;
    }

    private PathSettingsContainer processPatterns(IPath path, int matchDepth, int depth, PatternSearchInfo psi) {
        PathSettingsContainer childFound;
        PathSettingsContainer child;
        Set<PathSettingsContainer> storeSet = psi.fStoreSet;
        PathSettingsContainer container = null;
        String name = path.segment(0);
        List<PathSettingsContainer> list = this.getChildren(name);
        boolean exactPathFound = false;
        if (list != null) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                child = list.get(i);
                childFound = matchDepth == 0 && child.fValue != INEXISTENT_VALUE ? child : child.findContainer(path.removeFirstSegments(1), false, false, true, this.stepDepth(matchDepth), psi);
                if (childFound != null && childFound.fValue != INEXISTENT_VALUE) {
                    if (!exactPathFound && path.segmentCount() == 1 && child != childFound && name.equals(childFound.fName)) {
                        container = childFound;
                        exactPathFound = true;
                    } else if (container == null || container.getValue() == INEXISTENT_VALUE || container.getPath().segmentCount() < childFound.getPath().segmentCount()) {
                        container = childFound;
                    }
                    if (storeSet != null) {
                        storeSet.add(container);
                    } else if (exactPathFound) break;
                }
                ++i;
            }
        }
        if (!exactPathFound || storeSet != null) {
            child = this.getDoubleStarChild();
            if (child != null && (childFound = matchDepth == 0 && child.fValue != INEXISTENT_VALUE ? child : child.findContainer(path, false, false, true, matchDepth, psi)) != null && childFound.fValue != INEXISTENT_VALUE) {
                ++psi.fNumDoubleStarEls;
                if (container == null || container.getValue() == INEXISTENT_VALUE || container.getPath().segmentCount() < childFound.getPath().segmentCount() + depth - psi.fNumDoubleStarEls) {
                    container = childFound;
                }
                if (storeSet != null) {
                    storeSet.add(container);
                }
            }
            if (container == null) {
                if (this.isDoubleStarName()) {
                    if (path.segmentCount() > 1 && (childFound = this.processPatterns(path.removeFirstSegments(1), this.stepDepth(matchDepth), depth + 1, psi)) != null && childFound.fValue != INEXISTENT_VALUE) {
                        container = childFound;
                        if (storeSet != null) {
                            storeSet.add(container);
                        }
                    }
                } else if (matchDepth < 0 && this.fValue != INEXISTENT_VALUE) {
                    container = this;
                    if (storeSet != null) {
                        storeSet.add(container);
                    }
                }
            }
        }
        return container;
    }

    private int stepDepth(int depth) {
        return depth == 0 ? depth : depth - 1;
    }

    public void accept(IPathSettingsContainerVisitor visitor) {
        this.doAccept(visitor);
    }

    private boolean doAccept(IPathSettingsContainerVisitor visitor) {
        if (this.fValue != INEXISTENT_VALUE && !visitor.visit(this)) {
            return false;
        }
        PatternNameMap pMap = this.getPatternChildrenMap(false);
        if (pMap != null) {
            for (PathSettingsContainer child : pMap.values()) {
                if (child.doAccept(visitor)) continue;
                return false;
            }
        }
        return true;
    }

    public IPath getPath() {
        if (this.fPath == null) {
            this.fPath = this.fDirectParentContainer != null ? this.fDirectParentContainer.getPath().append(this.fName) : Path.ROOT;
        }
        return this.fPath;
    }

    public void setPath(IPath path, boolean moveChildren) {
        if (path == null || this.isRoot() || path.equals(this.getPath()) || path.segmentCount() == 0) {
            return;
        }
        IPath oldPath = this.getPath();
        this.fDirectParentContainer.disconnectChild(this);
        if (!moveChildren && this.hasChildren()) {
            PathSettingsContainer cr = new PathSettingsContainer(this.fRootContainer, this.fDirectParentContainer, this.fName, this.fIsPatternMode);
            Iterator<PathSettingsContainer> iter = this.fPatternChildrenMap.values().iterator();
            while (iter.hasNext()) {
                PathSettingsContainer child = iter.next();
                iter.remove();
                child.setParent(cr);
                cr.connectChild(child);
            }
        }
        PathSettingsContainer newParent = this.fRootContainer.findContainer(path.removeLastSegments(1), true, true, false, -1, null);
        PathSettingsContainer oldParent = this.fDirectParentContainer;
        this.fName = path.segment(path.segmentCount() - 1);
        this.fPath = path;
        this.setParent(newParent);
        newParent.connectChild(this);
        oldParent.checkRemove();
        this.notifyChange(this, 4, oldPath, moveChildren);
    }

    private Object internalGetValue() {
        return this.fValue;
    }

    public boolean isRoot() {
        return this.fRootContainer == this;
    }

    private Object internalSetValue(Object value) {
        Object oldValue = this.fValue;
        this.fValue = value;
        if (oldValue == INEXISTENT_VALUE) {
            oldValue = null;
        } else if (this.fValue != INEXISTENT_VALUE) {
            this.notifyChange(this, 3, oldValue, false);
        }
        return oldValue;
    }

    public Object setValue(Object value) {
        if (this.fValue == INEXISTENT_VALUE) {
            throw new IllegalStateException();
        }
        return this.internalSetValue(value);
    }

    public Object getValue() {
        if (this.fValue == INEXISTENT_VALUE) {
            throw new IllegalStateException();
        }
        return this.fValue;
    }

    public PathSettingsContainer getRootContainer() {
        return this.fRootContainer;
    }

    private PathSettingsContainer getDirectParentContainer() {
        return this.fDirectParentContainer;
    }

    public void addContainerListener(IPathSettingsContainerListener listenet) {
        List<IPathSettingsContainerListener> list = this.getListenersList(true);
        list.add(listenet);
    }

    public void removeContainerListener(IPathSettingsContainerListener listenet) {
        List<IPathSettingsContainerListener> list = this.getListenersList(false);
        if (list != null) {
            list.remove(listenet);
        }
    }

    private void setParent(PathSettingsContainer parent) {
        this.fDirectParentContainer = parent;
    }

    public String toString() {
        return this.contributeToString(new StringBuilder(), 0).toString();
    }

    private StringBuilder contributeToString(StringBuilder buf, int depth) {
        int i = 0;
        while (i < depth) {
            buf.append('\t');
            ++i;
        }
        buf.append('[').append(this.getPath()).append(']').append('\n');
        PathSettingsContainer[] directChildren = this.getDirectChildren();
        if (directChildren.length != 0) {
            int nextDepth = depth + 1;
            PathSettingsContainer[] pathSettingsContainerArray = directChildren;
            int n = directChildren.length;
            int n2 = 0;
            while (n2 < n) {
                PathSettingsContainer child = pathSettingsContainerArray[n2];
                child.contributeToString(buf, nextDepth);
                ++n2;
            }
        }
        return buf;
    }

    static boolean hasSpecChars(IPath path) {
        int count = path.segmentCount();
        int i = 0;
        while (i < count) {
            if (PatternNameMap.isPatternName(path.segment(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class PatternSearchInfo {
        Set<PathSettingsContainer> fStoreSet;
        int fNumDoubleStarEls;

        private PatternSearchInfo() {
        }
    }
}

