/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ACSettingEntry;
import org.eclipse.cdt.core.settings.model.CIncludeFileEntry;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.CLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.CMacroFileEntry;
import org.eclipse.cdt.core.settings.model.COutputEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultLanguageData;
import org.eclipse.cdt.core.settings.model.util.EntryContentsKey;
import org.eclipse.cdt.core.settings.model.util.EntryNameKey;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.WeakHashSet;
import org.eclipse.cdt.internal.core.WeakHashSetSynchronized;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class CDataUtil {
    private static final String EMPTY = "";
    private static final String DELIM = " ";
    private static Random randomNumber;
    public static final String[] EMPTY_STRING_ARRAY;
    private static WeakHashSet<ICSettingEntry> settingEntriesPool;

    static {
        EMPTY_STRING_ARRAY = new String[0];
        settingEntriesPool = new WeakHashSetSynchronized<ICSettingEntry>();
    }

    public static int genRandomNumber() {
        int i;
        if (randomNumber == null) {
            randomNumber = new Random();
            randomNumber.setSeed(System.currentTimeMillis());
        }
        if ((i = randomNumber.nextInt()) < 0) {
            i *= -1;
        }
        return i;
    }

    public static String genId(String baseId) {
        String suffix = Integer.toString(CDataUtil.genRandomNumber());
        return baseId != null ? baseId + "." + suffix : suffix;
    }

    public static boolean objectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String arrayToString(String[] array, String separator) {
        return CDataUtil.arrayToString((Object[])array, separator);
    }

    public static String arrayToString(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY;
        }
        if (array.length == 1) {
            return array[0].toString();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(array[0]);
        int i = 1;
        while (i < array.length) {
            buf.append(separator).append(array[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String[] stringToArray(String string, String separator) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer t = new StringTokenizer(string, separator);
        ArrayList<String> list = new ArrayList<String>(t.countTokens());
        while (t.hasMoreElements()) {
            list.add(t.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static ICSettingEntry[] resolveEntries(ICSettingEntry[] entries, ICConfigurationDescription cfgDes) {
        if (entries.length == 0) {
            return entries;
        }
        ArrayList<ICSettingEntry> out = new ArrayList<ICSettingEntry>(entries.length);
        ICdtVariableManager mngr = CCorePlugin.getDefault().getCdtVariableManager();
        int i = 0;
        while (i < entries.length) {
            ICSettingEntry entry = entries[i];
            out.addAll(Arrays.asList(CDataUtil.createResolvedEntry(entry, cfgDes, mngr)));
            ++i;
        }
        return out.toArray(new ICSettingEntry[out.size()]);
    }

    public static ICLanguageSettingEntry[] resolveEntries(ICLanguageSettingEntry[] entries, ICConfigurationDescription cfgDes) {
        if (entries.length == 0) {
            return entries;
        }
        ICSettingEntry[] resolved = CDataUtil.resolveEntries((ICSettingEntry[])entries, cfgDes);
        ICLanguageSettingEntry[] resolvedLangEntries = new ICLanguageSettingEntry[resolved.length];
        System.arraycopy(resolved, 0, resolvedLangEntries, 0, resolved.length);
        return resolvedLangEntries;
    }

    public static ICSourceEntry[] resolveEntries(ICSourceEntry[] entries, ICConfigurationDescription cfgDes) {
        if (entries.length == 0) {
            return entries;
        }
        ICSettingEntry[] resolved = CDataUtil.resolveEntries((ICSettingEntry[])entries, cfgDes);
        ICSourceEntry[] resolvedLangEntries = new ICSourceEntry[resolved.length];
        System.arraycopy(resolved, 0, resolvedLangEntries, 0, resolved.length);
        return resolvedLangEntries;
    }

    public static ICOutputEntry[] resolveEntries(ICOutputEntry[] entries, ICConfigurationDescription cfgDes) {
        if (entries.length == 0) {
            return entries;
        }
        ICSettingEntry[] resolved = CDataUtil.resolveEntries((ICSettingEntry[])entries, cfgDes);
        ICOutputEntry[] resolvedLangEntries = new ICOutputEntry[resolved.length];
        System.arraycopy(resolved, 0, resolvedLangEntries, 0, resolved.length);
        return resolvedLangEntries;
    }

    private static ICSettingEntry[] createResolvedEntry(ICSettingEntry entry, ICConfigurationDescription cfg, ICdtVariableManager mngr) {
        if (entry.isResolved()) {
            return new ICSettingEntry[]{entry};
        }
        String name = entry.getName();
        String[] names = new String[]{name};
        try {
            if (entry.getKind() != 4 && mngr.isStringListValue(name, cfg)) {
                names = mngr.resolveStringListValue(name, EMPTY, DELIM, cfg);
            } else {
                names[0] = mngr.resolveValue(name, EMPTY, DELIM, cfg);
            }
        }
        catch (CdtVariableException e) {
            CCorePlugin.log(e);
        }
        ICSettingEntry[] result = new ICSettingEntry[names.length];
        int k = 0;
        while (k < names.length) {
            String value = null;
            IPath[] exclusionFilters = null;
            IPath srcPath = null;
            IPath srcRootPath = null;
            IPath srcPrefixMapping = null;
            switch (entry.getKind()) {
                case 4: {
                    value = entry.getValue();
                    try {
                        value = mngr.resolveValue(value, EMPTY, DELIM, cfg);
                    }
                    catch (CdtVariableException e) {
                        CCorePlugin.log(e);
                    }
                    break;
                }
                case 32: {
                    ICLibraryFileEntry libFile = (ICLibraryFileEntry)entry;
                    srcPath = libFile.getSourceAttachmentPath();
                    srcRootPath = libFile.getSourceAttachmentRootPath();
                    srcPrefixMapping = libFile.getSourceAttachmentPrefixMapping();
                    if (srcPath != null) {
                        srcPath = CDataUtil.resolvePath(mngr, cfg, srcPath);
                    }
                    if (srcRootPath != null) {
                        srcRootPath = CDataUtil.resolvePath(mngr, cfg, srcRootPath);
                    }
                    if (srcPrefixMapping == null) break;
                    srcPrefixMapping = CDataUtil.resolvePath(mngr, cfg, srcPrefixMapping);
                    break;
                }
                case 64: 
                case 128: {
                    exclusionFilters = ((ICExclusionPatternPathEntry)entry).getExclusionPatterns();
                    int i = 0;
                    while (i < exclusionFilters.length) {
                        String exclString = exclusionFilters[i].toString();
                        try {
                            exclString = mngr.resolveValue(exclString, EMPTY, DELIM, cfg);
                        }
                        catch (CdtVariableException e) {
                            CCorePlugin.log(e);
                        }
                        exclusionFilters[i] = new Path(exclString);
                        ++i;
                    }
                    break;
                }
            }
            result[k] = CDataUtil.createEntry(entry.getKind(), names[k], value, exclusionFilters, entry.getFlags() | 0x10, srcPath, srcRootPath, srcPrefixMapping);
            ++k;
        }
        return result;
    }

    private static IPath resolvePath(ICdtVariableManager mngr, ICConfigurationDescription cfg, IPath path) {
        if (path == null) {
            return null;
        }
        try {
            String unresolved = path.toString();
            String resolved = mngr.resolveValue(unresolved, EMPTY, DELIM, cfg);
            if (resolved != null && !resolved.equals(unresolved)) {
                path = new Path(resolved);
            }
        }
        catch (CdtVariableException e) {
            CCorePlugin.log(e);
        }
        return path;
    }

    public static <T extends ICSettingEntry> T getPooledEntry(T entry) {
        return (T)settingEntriesPool.add(entry);
    }

    public static ICLanguageSettingEntry createEntry(ICLanguageSettingEntry entry, int flagsToAdd, int flafsToClear) {
        return CDataUtil.createEntry(entry, (entry.getFlags() | flagsToAdd) & ~flafsToClear);
    }

    public static ICLanguageSettingEntry createEntry(ICLanguageSettingEntry entry, int flags) {
        switch (entry.getKind()) {
            case 1: {
                entry = new CIncludePathEntry(entry.getName(), flags);
                break;
            }
            case 4: {
                entry = new CMacroEntry(entry.getName(), entry.getValue(), flags);
                break;
            }
            case 2: {
                entry = new CIncludeFileEntry(entry.getName(), flags);
                break;
            }
            case 8: {
                entry = new CMacroFileEntry(entry.getName(), flags);
                break;
            }
            case 16: {
                entry = new CLibraryPathEntry(entry.getName(), flags);
                break;
            }
            case 32: {
                ICLibraryFileEntry libFile = (ICLibraryFileEntry)entry;
                entry = new CLibraryFileEntry(entry.getName(), flags, libFile.getSourceAttachmentPath(), libFile.getSourceAttachmentRootPath(), libFile.getSourceAttachmentPrefixMapping());
            }
        }
        return CDataUtil.getPooledEntry(entry);
    }

    public static ICSettingEntry createEntry(int kind, String name, String value, IPath[] exclusionPatterns, int flags) {
        return CDataUtil.createEntry(kind, name, value, exclusionPatterns, flags, null, null, null);
    }

    public static ICSettingEntry createEntry(int kind, String name, String value, IPath[] exclusionPatterns, int flags, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath sourceAttachmentPrefixMapping) {
        ACSettingEntry entry = null;
        switch (kind) {
            case 1: {
                entry = new CIncludePathEntry(name, flags);
                break;
            }
            case 4: {
                entry = new CMacroEntry(name, value, flags);
                break;
            }
            case 2: {
                entry = new CIncludeFileEntry(name, flags);
                break;
            }
            case 8: {
                entry = new CMacroFileEntry(name, flags);
                break;
            }
            case 16: {
                entry = new CLibraryPathEntry(name, flags);
                break;
            }
            case 32: {
                entry = new CLibraryFileEntry(name, flags, sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping);
                break;
            }
            case 64: {
                entry = new COutputEntry(name, exclusionPatterns, flags);
                break;
            }
            case 128: {
                entry = new CSourceEntry(name, exclusionPatterns, flags);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return CDataUtil.getPooledEntry(entry);
    }

    public static CIncludePathEntry createCIncludePathEntry(String name, int flags) {
        return CDataUtil.getPooledEntry(new CIncludePathEntry(name, flags));
    }

    public static CIncludeFileEntry createCIncludeFileEntry(String name, int flags) {
        return CDataUtil.getPooledEntry(new CIncludeFileEntry(name, flags));
    }

    public static CMacroEntry createCMacroEntry(String name, String value, int flags) {
        return CDataUtil.getPooledEntry(new CMacroEntry(name, value, flags));
    }

    public static CMacroFileEntry createCMacroFileEntry(String name, int flags) {
        return CDataUtil.getPooledEntry(new CMacroFileEntry(name, flags));
    }

    public static CLibraryPathEntry createCLibraryPathEntry(String name, int flags) {
        return CDataUtil.getPooledEntry(new CLibraryPathEntry(name, flags));
    }

    public static CLibraryFileEntry createCLibraryFileEntry(String name, int flags) {
        return CDataUtil.getPooledEntry(new CLibraryFileEntry(name, flags));
    }

    public static String[] getSourceExtensions(IProject project, CLanguageData data) {
        String[] exts = null;
        String[] typeIds = data.getSourceContentTypeIds();
        exts = typeIds != null && typeIds.length != 0 ? CDataUtil.getExtensionsFromContentTypes(project, typeIds) : ((exts = data.getSourceExtensions()) != null && exts.length != 0 ? (String[])exts.clone() : CDefaultLanguageData.EMPTY_STRING_ARRAY);
        if (exts == null) {
            exts = CDefaultLanguageData.EMPTY_STRING_ARRAY;
        }
        return exts;
    }

    public static String[] getExtensionsFromContentTypes(IProject project, String[] typeIds) {
        String[] exts = null;
        if (typeIds != null && typeIds.length != 0) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            if (typeIds.length == 1) {
                IContentType type = manager.getContentType(typeIds[0]);
                if (type != null) {
                    exts = CDataUtil.getContentTypeFileSpecs(project, type);
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < typeIds.length) {
                    IContentType type = manager.getContentType(typeIds[i]);
                    if (type != null) {
                        list.addAll(Arrays.asList(CDataUtil.getContentTypeFileSpecs(project, type)));
                    }
                    ++i;
                }
                exts = list.toArray(new String[list.size()]);
            }
        }
        if (exts == null) {
            exts = CDefaultLanguageData.EMPTY_STRING_ARRAY;
        }
        return exts;
    }

    public static String[] getContentTypeFileSpecs(IProject project, IContentType type) {
        String[] globalSpecs = type.getFileSpecs(8);
        IContentTypeSettings settings = null;
        if (project != null) {
            String[] specs;
            ProjectScope projectScope = new ProjectScope(project);
            try {
                settings = type.getSettings((IScopeContext)projectScope);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (settings != null && (specs = settings.getFileSpecs(8)).length > 0) {
                int total = globalSpecs.length + specs.length;
                String[] projSpecs = new String[total];
                int i = 0;
                int j = 0;
                while (j < specs.length) {
                    projSpecs[i] = specs[j];
                    ++i;
                    ++j;
                }
                j = 0;
                while (j < globalSpecs.length) {
                    projSpecs[i] = globalSpecs[j];
                    ++i;
                    ++j;
                }
                return projSpecs;
            }
        }
        return globalSpecs;
    }

    public static CLanguageData findLanguagDataForFile(String fileName, IProject project, CFolderData fData) {
        return CDataUtil.findLanguagDataForFile(fileName, project, fData.getLanguageDatas());
    }

    public static CLanguageData findLanguagDataForFile(String fileName, IProject project, CLanguageData[] datas) {
        String ext;
        CLanguageData data = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && (ext = fileName.substring(index + 1).trim()).length() > 0) {
            data = CDataUtil.findLanguageDataForExtension(ext, datas);
        }
        return data;
    }

    public static CLanguageData findLanguageDataForExtension(String ext, CLanguageData[] datas) {
        int i = 0;
        while (i < datas.length) {
            CLanguageData data = datas[i];
            String[] exts = data.getSourceExtensions();
            if (exts != null && exts.length != 0) {
                int j = 0;
                while (j < exts.length) {
                    if (ext.equals(exts[j])) {
                        return data;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static Map<IPath, CResourceData> createPathRcDataMap(CConfigurationData data) {
        HashMap<IPath, CResourceData> map = new HashMap<IPath, CResourceData>();
        CResourceData[] rcDatas = data.getResourceDatas();
        int i = 0;
        while (i < rcDatas.length) {
            CResourceData rcData = rcDatas[i];
            map.put(rcData.getPath(), rcData);
            ++i;
        }
        return map;
    }

    public static PathSettingsContainer createRcDataHolder(CConfigurationData data) {
        PathSettingsContainer h2 = PathSettingsContainer.createRootContainer();
        h2.setValue(data.getRootFolderData());
        CResourceData[] rcDatas = data.getResourceDatas();
        int i = 0;
        while (i < rcDatas.length) {
            CResourceData rcData = rcDatas[i];
            PathSettingsContainer child = h2.getChildContainer(rcData.getPath(), true, true);
            child.setValue(rcData);
            ++i;
        }
        return h2;
    }

    public static CConfigurationData createEmptyData(String id, String name, CDataFactory factory, boolean performLangAdjustment) {
        CConfigurationData data;
        if (id == null) {
            id = CDataUtil.genId(null);
        }
        if ((data = factory.createConfigurationdata(id, name, null, false)).getRootFolderData() == null) {
            CFolderData foData = factory.createFolderData(data, null, CDataUtil.genId(data.getId()), false, Path.EMPTY);
            factory.link(data, foData);
        }
        if (data.getBuildData() == null) {
            CBuildData bData = factory.createBuildData(data, null, CDataUtil.genId(data.getId()), null, false);
            factory.link(data, bData);
        }
        if (data.getTargetPlatformData() == null) {
            CTargetPlatformData tpData = factory.createTargetPlatformData(data, null, CDataUtil.genId(data.getId()), null, false);
            factory.link(data, tpData);
        }
        if (performLangAdjustment) {
            CDataUtil.adjustConfig(data, factory);
        }
        return data;
    }

    public static CConfigurationData adjustConfig(CConfigurationData cfg, CDataFactory factory) {
        LanguageManager mngr = LanguageManager.getInstance();
        ILanguageDescriptor[] dess = mngr.getLanguageDescriptors();
        Map<String, ILanguageDescriptor[]> map = mngr.getContentTypeIdToLanguageDescriptionsMap();
        CResourceData[] rcDatas = cfg.getResourceDatas();
        int i = 0;
        while (i < rcDatas.length) {
            if (rcDatas[i].getType() == 4) {
                CDataUtil.adjustFolderData(cfg, (CFolderData)rcDatas[i], factory, dess, new HashMap<String, ILanguageDescriptor[]>(map));
            }
            ++i;
        }
        return cfg;
    }

    private static void adjustFolderData(CConfigurationData cfgData, CFolderData data, CDataFactory factory, ILanguageDescriptor[] dess, HashMap<String, ILanguageDescriptor[]> map) {
        HashMap<String, ILanguageDescriptor> langMap = new HashMap<String, ILanguageDescriptor>();
        int i = 0;
        while (i < dess.length) {
            langMap.put(dess[i].getId(), dess[i]);
            ++i;
        }
        CLanguageData[] lDatas = data.getLanguageDatas();
        int i2 = 0;
        while (i2 < lDatas.length) {
            CLanguageData lData = lDatas[i2];
            String langId = lData.getLanguageId();
            if (langId != null) {
                ILanguageDescriptor des = (ILanguageDescriptor)langMap.remove(langId);
                CDataUtil.adjustLanguageData(data, lData, des);
            } else {
                String[] cTypeIds = lData.getSourceContentTypeIds();
                int c = 0;
                while (c < cTypeIds.length) {
                    String cTypeId = cTypeIds[c];
                    ILanguageDescriptor[] langs = map.remove(cTypeId);
                    if (langs != null && langs.length != 0) {
                        int q = 0;
                        while (q < langs.length) {
                            langMap.remove(langs[q].getId());
                            ++q;
                        }
                        CDataUtil.adjustLanguageData(data, lData, langs[0]);
                    }
                    ++c;
                }
            }
            ++i2;
        }
        if (!langMap.isEmpty()) {
            CDataUtil.addLangs(cfgData, data, factory, langMap, map);
        }
    }

    private static CLanguageData adjustLanguageData(CFolderData data, CLanguageData lData, ILanguageDescriptor des) {
        String[] cTypeIds = des.getContentTypeIds();
        String[] srcIds = lData.getSourceContentTypeIds();
        HashSet<String> landTypes = new HashSet<String>(Arrays.asList(cTypeIds));
        landTypes.removeAll(Arrays.asList(srcIds));
        if (landTypes.size() != 0) {
            ArrayList<String> srcList = new ArrayList<String>();
            srcList.addAll(landTypes);
            lData.setSourceContentTypeIds(srcList.toArray(new String[srcList.size()]));
        }
        if (!des.getId().equals(lData.getLanguageId())) {
            lData.setLanguageId(des.getId());
        }
        return lData;
    }

    private static void addLangs(CConfigurationData cfgData, CFolderData data, CDataFactory factory, Map<String, ILanguageDescriptor> langMap, Map<String, ILanguageDescriptor[]> cTypeToLangMap) {
        ArrayList<ILanguageDescriptor> list = new ArrayList<ILanguageDescriptor>(langMap.values());
        while (list.size() != 0) {
            ILanguageDescriptor des = (ILanguageDescriptor)list.remove(list.size() - 1);
            String[] ctypeIds = des.getContentTypeIds();
            boolean addLang = false;
            int i = 0;
            while (i < ctypeIds.length) {
                ILanguageDescriptor[] langs = cTypeToLangMap.remove(ctypeIds[i]);
                if (langs != null && langs.length != 0) {
                    addLang = true;
                    int q = 0;
                    while (q < langs.length) {
                        list.remove(langs[q]);
                        ++q;
                    }
                }
                ++i;
            }
            if (!addLang) continue;
            CLanguageData lData = factory.createLanguageData(cfgData, data, CDataUtil.genId(data.getId()), des.getName(), des.getId(), 15, ctypeIds, true);
            factory.link(data, lData);
        }
    }

    public static boolean isExcluded(IPath path, ICSourceEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            if (!CDataUtil.isExcluded(path, entries[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isExcluded(IPath path, ICSourceEntry entry) {
        Path entryPath = new Path(entry.getName());
        if (path.isPrefixOf(entryPath)) {
            return false;
        }
        if (!entryPath.isPrefixOf(path)) {
            return true;
        }
        if (path.segmentCount() == 0) {
            return false;
        }
        char[][] exclusions = entry.fullExclusionPatternChars();
        return CoreModelUtil.isExcluded(path, exclusions);
    }

    public static boolean isOnSourceEntry(IPath path, ICSourceEntry entry) {
        Path entryPath = new Path(entry.getName());
        if (path.equals(entryPath)) {
            return true;
        }
        if (!entryPath.isPrefixOf(path)) {
            return false;
        }
        if (path.segmentCount() == 0) {
            return true;
        }
        char[][] exclusions = entry.fullExclusionPatternChars();
        return !CoreModelUtil.isExcluded(path, exclusions);
    }

    public static boolean canExclude(IPath path, boolean isFolder, boolean excluded, ICSourceEntry[] entries) {
        try {
            ICSourceEntry[] out = CDataUtil.setExcluded(path, isFolder, excluded, entries, false);
            return !CDataUtil.isEqual(entries, out);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isEqual(ICSourceEntry[] ein, ICSourceEntry[] aus) {
        if (ein == null || aus == null) {
            return ein == null && aus == null;
        }
        if (ein.length != aus.length) {
            return false;
        }
        int i = 0;
        while (i < ein.length) {
            boolean found = false;
            int j = 0;
            while (j < aus.length) {
                if (ein[i].equalsByName(aus[j])) {
                    if (ein[i].equalsByContents(aus[j])) {
                        found = true;
                        break;
                    }
                    return false;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ICSourceEntry[] setExcluded(IPath path, boolean isFolder, boolean excluded, ICSourceEntry[] entries) throws CoreException {
        return CDataUtil.setExcluded(path, isFolder, excluded, entries, true);
    }

    public static ICSourceEntry[] setExcludedIfPossible(IPath path, boolean isFolder, boolean excluded, ICSourceEntry[] entries) {
        try {
            ICSourceEntry[] newEntries = CDataUtil.setExcluded(path, isFolder, excluded, entries, false);
            if (newEntries == null) {
                newEntries = entries;
            }
            return newEntries;
        }
        catch (CoreException coreException) {
            return entries;
        }
    }

    public static ICSourceEntry[] setExcluded(IPath path, boolean isFolder, boolean excluded, ICSourceEntry[] entries, boolean throwExceptionOnErr) throws CoreException {
        ICSourceEntry[] newEntries;
        if (CDataUtil.isExcluded(path, entries) == excluded) {
            return entries;
        }
        if (excluded) {
            ArrayList<ICSourceEntry> includeList = new ArrayList<ICSourceEntry>(entries.length);
            ArrayList<ICSourceEntry> excludeList = new ArrayList<ICSourceEntry>(entries.length);
            CDataUtil.sortEntries(path, false, entries, includeList, excludeList);
            int i = 0;
            while (i < includeList.size()) {
                ICSourceEntry oldEntry = (ICSourceEntry)includeList.get(i);
                ArrayList<IPath> tmp = new ArrayList<IPath>(1);
                tmp.add(path);
                ICSourceEntry newEntry = CDataUtil.addExcludePaths(oldEntry, tmp, true);
                if (newEntry != null) {
                    excludeList.add(newEntry);
                }
                ++i;
            }
            newEntries = excludeList.toArray(new ICSourceEntry[excludeList.size()]);
        } else {
            ArrayList<ICSourceEntry> includeList = new ArrayList<ICSourceEntry>(entries.length + 1);
            ArrayList<ICSourceEntry> excludeList = new ArrayList<ICSourceEntry>(entries.length);
            CDataUtil.sortIncludingExcludingEntries(path, entries, includeList, excludeList);
            boolean included = false;
            if (includeList.size() != 0 && CDataUtil.includeExclusion(path, includeList) >= 0) {
                included = true;
            }
            if (!included) {
                if (isFolder) {
                    includeList.add(new CSourceEntry(path, null, 24));
                } else {
                    if (throwExceptionOnErr) {
                        throw ExceptionFactory.createCoreException("can not create a source entry for individual file");
                    }
                    return null;
                }
            }
            includeList.addAll(excludeList);
            newEntries = includeList.toArray(new ICSourceEntry[includeList.size()]);
        }
        return newEntries;
    }

    private static int includeExclusion(IPath path, List<ICSourceEntry> entries) {
        int i = 0;
        while (i < entries.size()) {
            ICSourceEntry entry = entries.get(i);
            if ((entry = CDataUtil.include(path, entry)) != null) {
                entries.set(i, entry);
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static ICSourceEntry include(IPath path, ICSourceEntry entry) {
        IPath[] exclusions = entry.getExclusionPatterns();
        Path entryPath = new Path(entry.getName());
        IPath relPath = path.removeFirstSegments(entryPath.segmentCount()).makeRelative();
        int k = 0;
        while (k < exclusions.length) {
            if (exclusions[k].equals(relPath)) {
                IPath[] updatedExclusions = new IPath[exclusions.length - 1];
                System.arraycopy(exclusions, 0, updatedExclusions, 0, k);
                System.arraycopy(exclusions, k + 1, updatedExclusions, k, updatedExclusions.length - k);
                CSourceEntry updatedEntry = new CSourceEntry(entry.getName(), updatedExclusions, entry.getFlags());
                if (CDataUtil.isOnSourceEntry(path, updatedEntry)) {
                    return updatedEntry;
                }
                exclusions = updatedExclusions;
                entry = updatedEntry;
            }
            ++k;
        }
        return null;
    }

    private static void sortIncludingExcludingEntries(IPath path, ICSourceEntry[] entries, List<ICSourceEntry> including, List<ICSourceEntry> excluding) {
        int i = 0;
        while (i < entries.length) {
            Path entryPath = new Path(entries[i].getName());
            if (entryPath.isPrefixOf(path)) {
                including.add(entries[i]);
            } else {
                excluding.add(entries[i]);
            }
            ++i;
        }
    }

    public static ICSourceEntry[] adjustEntries(ICSourceEntry[] entries) {
        return CDataUtil.adjustEntries(entries, false, null);
    }

    private static ICSourceEntry[] getDefaultSourceEntries(boolean absolute, IProject project) {
        CSourceEntry entry = absolute ? (project != null ? new CSourceEntry(project.getFullPath(), null, 24) : new CSourceEntry(Path.EMPTY, null, 24)) : new CSourceEntry(Path.EMPTY, null, 24);
        return new ICSourceEntry[]{entry};
    }

    private static ICOutputEntry[] getDefaultOutputEntries(boolean absolute, IProject project) {
        COutputEntry entry = absolute ? (project != null ? new COutputEntry(project.getFullPath(), null, 24) : new COutputEntry(Path.EMPTY, null, 24)) : new COutputEntry(Path.EMPTY, null, 24);
        return new ICOutputEntry[]{entry};
    }

    public static ICOutputEntry[] adjustEntries(ICOutputEntry[] entries, boolean makeAbsolute, IProject project) {
        if (entries == null || entries.length == 0) {
            return CDataUtil.getDefaultOutputEntries(makeAbsolute, project);
        }
        return makeAbsolute ? CDataUtil.makeAbsolute(project, entries) : CDataUtil.makeRelative(project, entries);
    }

    public static ICSourceEntry[] adjustEntries(ICSourceEntry[] entries, boolean makeAbsolute, IProject project) {
        if (entries == null || entries.length == 0) {
            return CDataUtil.getDefaultSourceEntries(makeAbsolute, project);
        }
        LinkedHashMap map = new LinkedHashMap();
        int i = 0;
        while (i < entries.length) {
            ICSourceEntry ei = entries[i];
            ArrayList<Path> list = null;
            int j = 0;
            while (j < entries.length) {
                Path ejPath;
                ICSourceEntry ej = entries[j];
                if (ei != ej && !CDataUtil.isExcluded((IPath)(ejPath = new Path(ej.getName())), ei)) {
                    if (list == null) {
                        list = new ArrayList<Path>();
                    }
                    list.add(ejPath);
                }
                ++j;
            }
            map.put(ei, list);
            ++i;
        }
        List<ICSourceEntry> resultList = new ArrayList<ICSourceEntry>(entries.length);
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            if (list == null) {
                resultList.add((ICSourceEntry)entry.getKey());
                continue;
            }
            ICSourceEntry se = (ICSourceEntry)entry.getKey();
            if ((se = CDataUtil.addExcludePaths(se, list, true)) == null) continue;
            resultList.add(se);
        }
        if (makeAbsolute) {
            if (project != null) {
                resultList = CDataUtil.makeAbsolute(project, resultList);
            }
        } else {
            resultList = CDataUtil.makeRelative(project, resultList);
        }
        ICSourceEntry[] resultArray = resultList.toArray(new ICSourceEntry[resultList.size()]);
        Arrays.sort(resultArray, new Comparator<ICSourceEntry>(){

            @Override
            public int compare(ICSourceEntry o1, ICSourceEntry o2) {
                return o1.getFullPath().toString().compareTo(o2.getFullPath().toString());
            }
        });
        return resultArray;
    }

    private static List<ICSourceEntry> makeRelative(IProject project, List<ICSourceEntry> list) {
        int size = list.size();
        int i = 0;
        while (i < size) {
            list.set(i, CDataUtil.makeRelative(project, list.get(i)));
            ++i;
        }
        return list;
    }

    private static List<ICSourceEntry> makeAbsolute(IProject project, List<ICSourceEntry> list) {
        int size = list.size();
        int i = 0;
        while (i < size) {
            list.set(i, CDataUtil.makeAbsolute(project, list.get(i)));
            ++i;
        }
        return list;
    }

    public static ICSourceEntry makeAbsolute(IProject project, ICSourceEntry entry) {
        return (ICSourceEntry)CDataUtil.makeAbsolute(project, entry, true);
    }

    public static ICSourceEntry makeRelative(IProject project, ICSourceEntry entry) {
        return (ICSourceEntry)CDataUtil.makeRelative(project, entry, true);
    }

    public static ICSourceEntry[] makeRelative(IProject project, ICSourceEntry[] entries) {
        return (ICSourceEntry[])CDataUtil.makeRelative(project, entries, true);
    }

    public static ICSourceEntry[] makeAbsolute(IProject project, ICSourceEntry[] entries) {
        return (ICSourceEntry[])CDataUtil.makeAbsolute(project, entries, true);
    }

    public static ICOutputEntry makeAbsolute(IProject project, ICOutputEntry entry) {
        return (ICOutputEntry)CDataUtil.makeAbsolute(project, entry, true);
    }

    public static ICOutputEntry makeRelative(IProject project, ICOutputEntry entry) {
        return (ICOutputEntry)CDataUtil.makeRelative(project, entry, true);
    }

    public static ICOutputEntry[] makeAbsolute(IProject project, ICOutputEntry[] entries) {
        return (ICOutputEntry[])CDataUtil.makeAbsolute(project, entries, true);
    }

    public static ICOutputEntry[] makeRelative(IProject project, ICOutputEntry[] entries) {
        return (ICOutputEntry[])CDataUtil.makeRelative(project, entries, true);
    }

    private static Collection<IPath> removePrefix(IPath prefix, Collection<IPath> paths, Collection<IPath> result) {
        if (result == null) {
            result = new ArrayList<IPath>(paths.size());
        }
        for (IPath path : paths) {
            if (!prefix.isPrefixOf(path)) continue;
            result.add(path.removeFirstSegments(prefix.segmentCount()));
        }
        return result;
    }

    public static ICSourceEntry addExcludePaths(ICSourceEntry entry, Collection<IPath> paths, boolean removePrefix) {
        Path entryPath = new Path(entry.getName());
        IPath[] oldExclusions = entry.getExclusionPatterns();
        LinkedHashSet<IPath> newSet = new LinkedHashSet<IPath>();
        if (removePrefix) {
            CDataUtil.removePrefix(entryPath, paths, newSet);
        } else {
            newSet.addAll(paths);
        }
        for (IPath path : newSet) {
            if (path.segmentCount() != 0) continue;
            return null;
        }
        newSet.addAll(Arrays.asList(oldExclusions));
        IPath[] newExclusions = newSet.toArray(new IPath[newSet.size()]);
        return new CSourceEntry(entry.getName(), newExclusions, entry.getFlags());
    }

    private static void sortEntries(IPath path, boolean byExclude, ICSourceEntry[] entries, List<ICSourceEntry> included, List<ICSourceEntry> excluded) {
        int i = 0;
        while (i < entries.length) {
            if (byExclude ? CDataUtil.isExcluded(path, entries[i]) : !CDataUtil.isOnSourceEntry(path, entries[i])) {
                if (excluded != null) {
                    excluded.add(entries[i]);
                }
            } else if (included != null) {
                included.add(entries[i]);
            }
            ++i;
        }
    }

    public static Map<EntryNameKey, ICSettingEntry> fillEntriesMapByNameKey(Map<EntryNameKey, ICSettingEntry> map, ICSettingEntry[] entries) {
        if (map == null) {
            map = new LinkedHashMap<EntryNameKey, ICSettingEntry>();
        }
        int i = 0;
        while (i < entries.length) {
            ICSettingEntry entry = entries[i];
            map.put(new EntryNameKey(entry), entry);
            ++i;
        }
        return map;
    }

    public static Map<EntryContentsKey, ICSettingEntry> fillEntriesMapByContentsKey(Map<EntryContentsKey, ICSettingEntry> map, ICSettingEntry[] entries) {
        if (map == null) {
            map = new LinkedHashMap<EntryContentsKey, ICSettingEntry>();
        }
        int i = 0;
        while (i < entries.length) {
            ICSettingEntry entry = entries[i];
            map.put(new EntryContentsKey(entry), entry);
            ++i;
        }
        return map;
    }

    public static boolean getBoolean(ICStorageElement el, String attr, boolean defaultValue) {
        String tmp;
        if (el != null && (tmp = el.getAttribute(attr)) != null) {
            return Boolean.valueOf(tmp);
        }
        return defaultValue;
    }

    public static void setBoolean(ICStorageElement el, String attr, boolean value) {
        el.setAttribute(attr, String.valueOf(value));
    }

    public static int getInteger(ICStorageElement el, String attr, int defaultValue) {
        String tmp;
        if (el != null && (tmp = el.getAttribute(attr)) != null) {
            try {
                return Integer.parseInt(tmp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void setInteger(ICStorageElement el, String attr, int value) {
        el.setAttribute(attr, Integer.toString(value));
    }

    public static ICExclusionPatternPathEntry addRemoveExclusionsToEntry(ICExclusionPatternPathEntry entry, IPath[] paths, boolean add) throws IllegalArgumentException {
        if (paths == null || paths.length == 0) {
            return entry;
        }
        Set<IPath> set = CDataUtil.mergeRemovingDups(entry.getExclusionPatterns(), paths, add);
        IPath[] exclusions = set.toArray(new IPath[set.size()]);
        return (ICExclusionPatternPathEntry)CDataUtil.createEntry(entry.getKind(), entry.getName(), null, exclusions, entry.getFlags());
    }

    private static Set<IPath> mergeRemovingDups(IPath[] o1, IPath[] o2, boolean add) {
        LinkedHashSet<IPath> set = new LinkedHashSet<IPath>();
        set.addAll(Arrays.asList(o1));
        if (add) {
            set.addAll(Arrays.asList(o2));
        } else {
            set.removeAll(Arrays.asList(o2));
        }
        return set;
    }

    public static ICExclusionPatternPathEntry makeAbsolute(IProject project, ICExclusionPatternPathEntry entry, boolean force) {
        if (!entry.isValueWorkspacePath() && !force) {
            return entry;
        }
        IPath path = new Path(entry.getName());
        IPath projPath = project.getFullPath();
        if (!path.isAbsolute() || force && !projPath.isPrefixOf(path)) {
            path = projPath.append(path).makeAbsolute();
            return (ICExclusionPatternPathEntry)CDataUtil.createEntry(entry.getKind(), path.toString(), null, entry.getExclusionPatterns(), entry.getFlags());
        }
        return entry;
    }

    public static ICExclusionPatternPathEntry makeRelative(IProject project, ICExclusionPatternPathEntry entry, boolean force) {
        if (!entry.isValueWorkspacePath() && !force) {
            return entry;
        }
        IPath path = new Path(entry.getName());
        IPath projPath = project.getFullPath();
        if (path.isAbsolute()) {
            if (projPath.isPrefixOf(path)) {
                path = path.removeFirstSegments(projPath.segmentCount()).makeRelative();
            } else if (force) {
                path = path.makeRelative();
            }
            return (ICExclusionPatternPathEntry)CDataUtil.createEntry(entry.getKind(), path.toString(), null, entry.getExclusionPatterns(), entry.getFlags());
        }
        return entry;
    }

    public static ICExclusionPatternPathEntry[] makeRelative(IProject project, ICExclusionPatternPathEntry[] entries, boolean force) {
        if (entries == null) {
            return null;
        }
        ICExclusionPatternPathEntry[] relEntries = (ICExclusionPatternPathEntry[])Array.newInstance(entries.getClass().getComponentType(), entries.length);
        int i = 0;
        while (i < entries.length) {
            relEntries[i] = CDataUtil.makeRelative(project, entries[i], force);
            ++i;
        }
        return relEntries;
    }

    public static ICExclusionPatternPathEntry[] makeAbsolute(IProject project, ICExclusionPatternPathEntry[] entries, boolean force) {
        if (entries == null) {
            return null;
        }
        ICExclusionPatternPathEntry[] relEntries = (ICExclusionPatternPathEntry[])Array.newInstance(entries.getClass().getComponentType(), entries.length);
        int i = 0;
        while (i < entries.length) {
            relEntries[i] = CDataUtil.makeAbsolute(project, entries[i], force);
            ++i;
        }
        return relEntries;
    }
}

