/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import org.eclipse.cdt.core.settings.model.ACSettingEntry;
import org.eclipse.cdt.core.settings.model.ICPathEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class ACPathEntry
extends ACSettingEntry
implements ICPathEntry {
    ACPathEntry(IResource rc, int flags) {
        super(rc.getFullPath().toString(), flags | 0x10 | 8);
    }

    ACPathEntry(String name, int flags) {
        super(name, flags);
    }

    ACPathEntry(IPath path, int flags) {
        super(path.toString(), flags);
    }

    @Override
    public IPath getFullPath() {
        if (this.isValueWorkspacePath()) {
            return new Path(this.getValue());
        }
        if (this.isResolved()) {
            Path path = new Path(this.getValue());
            return this.fullPathForLocation(path);
        }
        return null;
    }

    protected IPath fullPathForLocation(IPath location) {
        IFile[] rcs;
        Object[] objectArray = rcs = this.isFile() ? ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(location) : ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(location);
        if (rcs.length > 0) {
            return rcs[0].getFullPath();
        }
        return null;
    }

    public abstract boolean isFile();

    @Override
    public IPath getLocation() {
        if (!this.isValueWorkspacePath()) {
            return new Path(this.getValue());
        }
        if (this.isResolved()) {
            Path path = new Path(this.getValue());
            IResource rc = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (rc != null) {
                return rc.getLocation();
            }
        }
        return null;
    }

    @Override
    public boolean isValueWorkspacePath() {
        return this.checkFlags(8);
    }

    @Override
    protected String contentsToString() {
        return this.getName();
    }
}

