/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public class EFSFileStorage
extends PlatformObject
implements IStorage {
    private URI locationURI;
    private InputStream inputStream;

    public EFSFileStorage(URI locationURI) {
        this.locationURI = locationURI;
    }

    public InputStream getContents() throws CoreException {
        IFileStore fileStore;
        if (this.inputStream == null && (fileStore = EFS.getStore((URI)this.locationURI)) != null) {
            this.inputStream = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
        }
        return this.inputStream;
    }

    public IPath getFullPath() {
        return URIUtil.toPath((URI)this.locationURI);
    }

    public String getName() {
        IFileStore fileStore = null;
        try {
            fileStore = EFS.getStore((URI)this.locationURI);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        if (fileStore != null) {
            return fileStore.getName();
        }
        return null;
    }

    public boolean isReadOnly() {
        IFileInfo info;
        IFileStore fileStore = null;
        try {
            fileStore = EFS.getStore((URI)this.locationURI);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (fileStore != null && (info = fileStore.fetchInfo()) != null) {
            return info.getAttribute(2);
        }
        return false;
    }

    public URI getLocationURI() {
        return this.locationURI;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EFSFileStorage && this.locationURI != null) {
            return this.locationURI.equals(((EFSFileStorage)obj).getLocationURI());
        }
        return false;
    }
}

