/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.formatter;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.formatter.Messages;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterApplication
implements IApplication {
    private static final String ARG_CONFIG = "-config";
    private static final String ARG_HELP = "-help";
    private static final String ARG_QUIET = "-quiet";
    private static final String ARG_VERBOSE = "-verbose";
    private String configName;
    private Map options = null;
    private boolean quiet = false;
    private boolean verbose = false;

    private void displayHelp() {
        System.out.println(Messages.CommandLineUsage);
    }

    private void displayHelp(String message) {
        System.err.println(message);
        System.out.println();
        this.displayHelp();
    }

    private void formatDirTree(File dir, CodeFormatter codeFormatter) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                this.formatDirTree(file, codeFormatter);
            } else if (this.hasSuitableFileExtension(file)) {
                this.formatFile(file, codeFormatter);
            }
            ++i;
        }
    }

    private void formatFile(File file, CodeFormatter codeFormatter) {
        Document doc = new Document();
        try {
            if (this.verbose) {
                System.out.println(Messages.bind(Messages.CommandLineFormatting, file.getAbsolutePath()));
            }
            String contents = new String(Files.readAllBytes(file.toPath()));
            doc.set(contents);
            TextEdit edit = codeFormatter.format(8, contents, 0, contents.length(), 0, null);
            if (edit == null) {
                System.err.println(Messages.bind(Messages.FormatProblem, file.getAbsolutePath()));
                return;
            }
            edit.apply((IDocument)doc);
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            try {
                out.write(doc.get());
                out.flush();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            String errorMessage = Messages.bind(Messages.CaughtException, "IOException", e.getLocalizedMessage());
            System.err.println(Messages.bind(Messages.ExceptionSkip, errorMessage));
        }
        catch (BadLocationException e) {
            String errorMessage = Messages.bind(Messages.CaughtException, "BadLocationException", e.getLocalizedMessage());
            System.err.println(Messages.bind(Messages.ExceptionSkip, errorMessage));
        }
    }

    private File[] processCommandLine(String[] argsArray) {
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        int max = argsArray.length;
        while (i < max) {
            args.add(argsArray[i]);
            ++i;
        }
        int index = 0;
        int argCount = argsArray.length;
        boolean DEFAULT_MODE = false;
        boolean CONFIG_MODE = true;
        int mode = 0;
        ArrayList<File> filesToFormat = new ArrayList<File>();
        while (index < argCount) {
            String currentArg = argsArray[index++];
            switch (mode) {
                case 0: {
                    String canonicalPath;
                    if (ARG_HELP.equals(currentArg)) {
                        this.displayHelp();
                        return null;
                    }
                    if (ARG_VERBOSE.equals(currentArg)) {
                        this.verbose = true;
                        break;
                    }
                    if (ARG_QUIET.equals(currentArg)) {
                        this.quiet = true;
                        break;
                    }
                    if (ARG_CONFIG.equals(currentArg)) {
                        mode = 1;
                        break;
                    }
                    File file = new File(currentArg);
                    if (file.exists()) {
                        filesToFormat.add(file);
                        break;
                    }
                    try {
                        canonicalPath = file.getCanonicalPath();
                    }
                    catch (IOException e2) {
                        canonicalPath = file.getAbsolutePath();
                    }
                    String errorMsg = file.isAbsolute() ? Messages.bind(Messages.CommandLineErrorFile, canonicalPath) : Messages.bind(Messages.CommandLineErrorFileTryFullPath, canonicalPath);
                    this.displayHelp(errorMsg);
                    return null;
                }
                case 1: {
                    this.configName = currentArg;
                    this.options = this.readConfig(currentArg);
                    boolean validConfig = false;
                    if (this.options != null && !this.options.isEmpty()) {
                        Iterator it = this.options.keySet().iterator();
                        while (it.hasNext()) {
                            if (!((String)it.next()).startsWith(this.getClass().getPackage().getName())) continue;
                            validConfig = true;
                            break;
                        }
                    }
                    if (!validConfig) {
                        this.displayHelp(Messages.bind(Messages.CommandLineErrorConfig, currentArg));
                        return null;
                    }
                    mode = 0;
                }
            }
        }
        if (this.quiet && this.verbose) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorQuietVerbose, new String[]{ARG_QUIET, ARG_VERBOSE}));
            return null;
        }
        if (filesToFormat.isEmpty()) {
            this.displayHelp(Messages.CommandLineErrorFileDir);
            return null;
        }
        return filesToFormat.toArray(new File[0]);
    }

    private Properties readConfig(String filename) {
        File configFile = new File(filename);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(configFile));){
                Properties formatterOptions = new Properties();
                formatterOptions.load(stream);
                return formatterOptions;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String canonicalPath = null;
            try {
                canonicalPath = configFile.getCanonicalPath();
            }
            catch (IOException e2) {
                canonicalPath = configFile.getAbsolutePath();
            }
            String errorMessage = !configFile.exists() && !configFile.isAbsolute() ? Messages.bind(Messages.ConfigFileNotFoundErrorTryFullPath, new Object[]{canonicalPath, System.getProperty("user.dir")}) : Messages.bind(Messages.ConfigFileReadingError, canonicalPath);
            System.err.println(errorMessage);
            return null;
        }
    }

    private boolean hasSuitableFileExtension(File file) {
        String id;
        IContentType ct = CCorePlugin.getContentType(null, file.getName());
        return ct != null && ("org.eclipse.cdt.core.cSource".equals(id = ct.getId()) || "org.eclipse.cdt.core.cHeader".equals(id) || "org.eclipse.cdt.core.cxxSource".equals(id) || "org.eclipse.cdt.core.cxxHeader".equals(id));
    }

    @Override
    public Object start(IApplicationContext context) throws Exception {
        File[] filesToFormat = this.processCommandLine((String[])context.getArguments().get("application.args"));
        if (filesToFormat == null) {
            return IApplication.EXIT_OK;
        }
        if (!this.quiet) {
            if (this.configName != null) {
                System.out.println(Messages.bind(Messages.CommandLineConfigFile, this.configName));
            }
            System.out.println(Messages.CommandLineStart);
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(this.options);
        int i = 0;
        int max = filesToFormat.length;
        while (i < max) {
            File file = filesToFormat[i];
            if (file.isDirectory()) {
                this.formatDirTree(file, codeFormatter);
            } else {
                this.formatFile(file, codeFormatter);
            }
            ++i;
        }
        if (!this.quiet) {
            System.out.println(Messages.CommandLineDone);
        }
        return IApplication.EXIT_OK;
    }

    @Override
    public void stop() {
    }
}

