/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.scopes;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueDeclarationScope
extends Scope {
    protected static final Logger log = LoggerFactory.getLogger(ValueDeclarationScope.class);
    private @NonNull List<ValueDeclaration> valueDeclarations = new ArrayList<ValueDeclaration>();
    private @NonNull List<TypedefDeclaration> typedefs = new ArrayList<TypedefDeclaration>();

    public ValueDeclarationScope(Node node) {
        this.astNode = node;
    }

    public @NonNull List<ValueDeclaration> getValueDeclarations() {
        return this.valueDeclarations;
    }

    public void setValueDeclarations(@NonNull List<ValueDeclaration> valueDeclarations) {
        this.valueDeclarations = valueDeclarations;
    }

    public List<TypedefDeclaration> getTypedefs() {
        return this.typedefs;
    }

    public void setTypedefs(List<TypedefDeclaration> typedefs) {
        this.typedefs = typedefs;
    }

    public void addTypedef(TypedefDeclaration typedef) {
        this.typedefs.add(typedef);
    }

    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof ValueDeclaration) {
            this.addValueDeclaration((ValueDeclaration)declaration);
        } else {
            Util.errorWithFileLocation(declaration, log, "A non ValueDeclaration can not be added to a DeclarationScope", new Object[0]);
        }
    }

    void addValueDeclaration(ValueDeclaration valueDeclaration) {
        this.valueDeclarations.add(valueDeclaration);
        if (this.astNode instanceof DeclarationHolder) {
            DeclarationHolder holder = (DeclarationHolder)((Object)this.astNode);
            holder.addDeclaration(valueDeclaration);
        } else {
            Util.errorWithFileLocation(valueDeclaration, log, "Trying to add a value declaration to a scope which does not have a declaration holder AST node", new Object[0]);
        }
    }
}

