/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.scopes;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.TryStatement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.types.FunctionPointerType;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.scopes.BlockScope;
import de.fraunhofer.aisec.cpg.passes.scopes.FunctionScope;
import de.fraunhofer.aisec.cpg.passes.scopes.GlobalScope;
import de.fraunhofer.aisec.cpg.passes.scopes.IBreakable;
import de.fraunhofer.aisec.cpg.passes.scopes.IContinuable;
import de.fraunhofer.aisec.cpg.passes.scopes.LoopScope;
import de.fraunhofer.aisec.cpg.passes.scopes.NameScope;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.StructureDeclarationScope;
import de.fraunhofer.aisec.cpg.passes.scopes.SwitchScope;
import de.fraunhofer.aisec.cpg.passes.scopes.TryScope;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeManager.class);
    private final Map<Node, Scope> scopeMap = new HashMap<Node, Scope>();
    private final Map<String, Scope> fqnScopeMap = new HashMap<String, Scope>();
    private Scope currentScope = null;
    private LanguageFrontend lang;

    public ScopeManager() {
        this.pushScope(new GlobalScope());
    }

    public LanguageFrontend getLang() {
        return this.lang;
    }

    public void setLang(LanguageFrontend lang) {
        this.lang = lang;
    }

    private void pushScope(Scope scope) {
        if (this.scopeMap.containsKey(scope.astNode)) {
            LOGGER.error("Node cannot be scoped twice. A node at most one associated scope apart from the parent scopes.");
            return;
        }
        this.scopeMap.put(scope.astNode, scope);
        if (scope instanceof NameScope || scope instanceof RecordScope) {
            this.fqnScopeMap.put(scope.getAstNode().getName(), scope);
        }
        if (this.currentScope != null) {
            this.currentScope.getChildren().add(scope);
            scope.setParent(this.currentScope);
        }
        this.currentScope = scope;
    }

    public boolean isInBlock() {
        return this.getFirstScopeThat(scope -> scope instanceof BlockScope) != null;
    }

    public boolean isInFunction() {
        return this.getFirstScopeThat(scope -> scope instanceof FunctionScope) != null;
    }

    public boolean isInRecord() {
        return this.getFirstScopeThat(scope -> scope instanceof RecordScope) != null;
    }

    public Map<String, Scope> getFqnScopeMap() {
        return this.fqnScopeMap;
    }

    public @Nullable CompoundStatement getCurrentBlock() {
        Scope blockScope = this.getFirstScopeThat(scope -> scope instanceof BlockScope);
        if (blockScope == null) {
            LOGGER.error("Cannot get current block. No scope.");
            return null;
        }
        Node node = blockScope.getAstNode();
        if (!(node instanceof CompoundStatement)) {
            LOGGER.error("Cannot get current block. No AST node {}", (Object)blockScope.toString());
            return null;
        }
        return (CompoundStatement)node;
    }

    public @Nullable FunctionDeclaration getCurrentFunction() {
        Scope functionScope = this.getFirstScopeThat(scope -> scope instanceof FunctionScope);
        if (functionScope == null) {
            LOGGER.error("Cannot get current function. No scope.");
            return null;
        }
        Node node = functionScope.getAstNode();
        if (!(node instanceof FunctionDeclaration)) {
            LOGGER.error("Cannot get current function. No AST node {}", (Object)functionScope.toString());
            return null;
        }
        return (FunctionDeclaration)node;
    }

    public @Nullable RecordDeclaration getCurrentRecord() {
        Scope recordScope = this.getFirstScopeThat(scope -> scope instanceof RecordScope);
        if (recordScope == null) {
            LOGGER.error("Cannot get current Record. No scope.");
            return null;
        }
        Node node = recordScope.getAstNode();
        if (!(node instanceof RecordDeclaration)) {
            LOGGER.error("Cannot get current Record. No AST node {}", (Object)recordScope);
            return null;
        }
        return (RecordDeclaration)node;
    }

    public List<ValueDeclaration> getGlobals() {
        GlobalScope globalS = (GlobalScope)this.getFirstScopeThat(scope -> scope instanceof GlobalScope);
        if (globalS != null) {
            return globalS.getValueDeclarations();
        }
        return new ArrayList<ValueDeclaration>();
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    public void addGlobal(VariableDeclaration global) {
        this.getGlobals().add(global);
    }

    public void enterScopeIfExists(Node nodeToScope) {
        if (this.scopeMap.containsKey(nodeToScope)) {
            this.currentScope = this.scopeMap.get(nodeToScope);
        }
    }

    public @Nullable Scope leaveScopeIfExists(Node nodeToLeave) {
        Scope leaveScope = this.scopeMap.getOrDefault(nodeToLeave, null);
        if (leaveScope != null) {
            this.currentScope = leaveScope.parent;
        }
        return leaveScope;
    }

    public void enterScope(Node nodeToScope) {
        ValueDeclarationScope newScope = null;
        if (!this.scopeMap.containsKey(nodeToScope)) {
            if (nodeToScope instanceof CompoundStatement) {
                newScope = new BlockScope((CompoundStatement)nodeToScope);
            } else if (nodeToScope instanceof WhileStatement || nodeToScope instanceof DoStatement || nodeToScope instanceof AssertStatement) {
                newScope = new LoopScope((Statement)nodeToScope);
            } else if (nodeToScope instanceof ForStatement || nodeToScope instanceof ForEachStatement) {
                newScope = new LoopScope((Statement)nodeToScope);
            } else if (nodeToScope instanceof SwitchStatement) {
                newScope = new SwitchScope((SwitchStatement)nodeToScope);
            } else if (nodeToScope instanceof FunctionDeclaration) {
                newScope = new FunctionScope((FunctionDeclaration)nodeToScope);
            } else if (nodeToScope instanceof IfStatement) {
                newScope = new ValueDeclarationScope(nodeToScope);
            } else if (nodeToScope instanceof CatchClause) {
                newScope = new ValueDeclarationScope(nodeToScope);
            } else if (nodeToScope instanceof RecordDeclaration) {
                newScope = new RecordScope(nodeToScope, this.getCurrentNamePrefix(), this.lang.getNamespaceDelimiter());
            } else if (nodeToScope instanceof TryStatement) {
                newScope = new TryScope(nodeToScope);
            } else if (nodeToScope instanceof NamespaceDeclaration) {
                newScope = new NameScope(nodeToScope, this.getCurrentNamePrefix(), this.lang.getNamespaceDelimiter());
            } else {
                LOGGER.error("No known scope for AST-nodes of type {}", (Object)nodeToScope.getClass());
                return;
            }
            this.pushScope(newScope);
        }
        this.currentScope = this.scopeMap.get(nodeToScope);
        if (newScope != null) {
            newScope.setScopedName(this.getCurrentNamePrefix());
        }
    }

    public boolean isBreakable(Scope scope) {
        return scope instanceof LoopScope || scope instanceof SwitchScope;
    }

    public boolean isContinuable(Scope scope) {
        return scope instanceof LoopScope;
    }

    public @Nullable Scope leaveScope(@NonNull Node nodeToLeave) {
        if (!this.scopeMap.containsKey(nodeToLeave)) {
            return null;
        }
        Scope leaveScope = this.getFirstScopeThat(scope -> Objects.equals(scope.astNode, nodeToLeave));
        if (leaveScope == null) {
            if (this.scopeMap.containsKey(nodeToLeave)) {
                Util.errorWithFileLocation(nodeToLeave, LOGGER, "Node of type {} has a scope but is not active in the moment.", nodeToLeave.getClass());
            } else {
                Util.errorWithFileLocation(nodeToLeave, LOGGER, "Node of type {} is not associated with a scope.", nodeToLeave.getClass());
            }
            return null;
        }
        this.currentScope = leaveScope.parent;
        return leaveScope;
    }

    public @Nullable Scope getFirstScopeThat(Predicate<Scope> predicate) {
        return this.getFirstScopeThat(this.currentScope, predicate);
    }

    public @Nullable Scope getFirstScopeThat(Scope searchScope, Predicate<Scope> predicate) {
        while (searchScope != null) {
            if (predicate.test(searchScope)) {
                return searchScope;
            }
            searchScope = searchScope.parent;
        }
        return null;
    }

    public List<Scope> getScopesThat(Predicate<Scope> predicate) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (Scope scope : this.scopeMap.values()) {
            if (!predicate.test(scope)) continue;
            scopes.add(scope);
        }
        return scopes;
    }

    public <T> List<Scope> getUniqueScopesThat(Predicate<Scope> predicate, Function<Scope, T> uniqueProperty) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        HashSet<T> seen = new HashSet<T>();
        for (Scope scope : this.scopeMap.values()) {
            if (!predicate.test(scope) || !seen.add(uniqueProperty.apply(scope))) continue;
            scopes.add(scope);
        }
        return scopes;
    }

    public void addBreakStatement(BreakStatement breakStatement) {
        if (breakStatement.getLabel() == null) {
            Scope scope = this.getFirstScopeThat(this::isBreakable);
            if (scope == null) {
                LOGGER.error("Break inside of unbreakable scope. The break will be ignored, but may lead to an incorrect graph. The source code is not valid or incomplete.");
                return;
            }
            ((IBreakable)((Object)scope)).addBreakStatement(breakStatement);
        } else {
            LabelStatement labelStatement = this.getLabelStatement(breakStatement.getLabel());
            if (labelStatement != null) {
                Scope scope = this.getScopeOfStatment(labelStatement.getSubStatement());
                ((IBreakable)((Object)scope)).addBreakStatement(breakStatement);
            }
        }
    }

    public void addContinueStatement(ContinueStatement continueStatement) {
        if (continueStatement.getLabel() == null) {
            Scope scope = this.getFirstScopeThat(this::isContinuable);
            if (scope == null) {
                LOGGER.error("Continue inside of not continuable scope. The continue will be ignored, but may lead to an incorrect graph. The source code is not valid or incomplete.");
                return;
            }
            ((IContinuable)((Object)scope)).addContinueStatement(continueStatement);
        } else {
            LabelStatement labelStatement = this.getLabelStatement(continueStatement.getLabel());
            if (labelStatement != null) {
                Scope scope = this.getScopeOfStatment(labelStatement.getSubStatement());
                ((IContinuable)((Object)scope)).addContinueStatement(continueStatement);
            }
        }
    }

    public void addLabelStatement(LabelStatement labelStatement) {
        this.currentScope.addLabelStatement(labelStatement);
    }

    public @Nullable LabelStatement getLabelStatement(String labelString) {
        Scope searchScope = this.currentScope;
        while (searchScope != null) {
            LabelStatement labelStatement = searchScope.getLabelStatements().getOrDefault(labelString, null);
            if (labelStatement != null) {
                return labelStatement;
            }
            searchScope = searchScope.parent;
        }
        return null;
    }

    public void removeDeclaration(Declaration declaration) {
        Scope toIterate = this.currentScope;
        do {
            ValueDeclarationScope declScope;
            if (!(toIterate instanceof ValueDeclarationScope) || !(declScope = (ValueDeclarationScope)toIterate).getValueDeclarations().contains(declaration)) continue;
            declScope.getValueDeclarations().remove(declaration);
            if (declScope.getAstNode() instanceof RecordDeclaration) {
                RecordDeclaration rec = (RecordDeclaration)declScope.getAstNode();
                rec.removeField((FieldDeclaration)declaration);
                rec.removeMethod((MethodDeclaration)declaration);
                rec.removeConstructor((ConstructorDeclaration)declaration);
                rec.removeRecord((RecordDeclaration)declaration);
                continue;
            }
            if (declScope.getAstNode() instanceof FunctionDeclaration) {
                ((FunctionDeclaration)declScope.getAstNode()).removeParameter((ParamVariableDeclaration)declaration);
                continue;
            }
            if (declScope.getAstNode() instanceof Statement) {
                if (!(declaration instanceof VariableDeclaration)) continue;
                ((Statement)declScope.getAstNode()).removeLocal((VariableDeclaration)declaration);
                continue;
            }
            if (!(declScope.getAstNode() instanceof EnumDeclaration)) continue;
            ((EnumDeclaration)declScope.getAstNode()).getEntries().remove(declaration);
        } while ((toIterate = toIterate.getParent()) != null);
    }

    public void resetToGlobal(TranslationUnitDeclaration declaration) {
        GlobalScope global = (GlobalScope)this.getFirstScopeThat(scope -> scope instanceof GlobalScope);
        if (global != null) {
            global.astNode = declaration;
            this.currentScope = global;
        }
    }

    public void addDeclaration(Declaration declaration) {
        if (declaration instanceof ProblemDeclaration) {
            GlobalScope globalScope = (GlobalScope)this.getFirstScopeThat(scope -> scope instanceof GlobalScope);
            globalScope.addDeclaration(declaration);
        } else if (declaration instanceof ValueDeclaration) {
            ValueDeclarationScope scopeForValueDeclaration = (ValueDeclarationScope)this.getFirstScopeThat(scope -> scope instanceof ValueDeclarationScope);
            scopeForValueDeclaration.addValueDeclaration((ValueDeclaration)declaration);
        } else if (declaration instanceof RecordDeclaration || declaration instanceof NamespaceDeclaration || declaration instanceof EnumDeclaration) {
            StructureDeclarationScope scopeForStructureDeclaration = (StructureDeclarationScope)this.getFirstScopeThat(scope -> scope instanceof StructureDeclarationScope);
            scopeForStructureDeclaration.addDeclaration(declaration);
        }
    }

    public void addTypedef(TypedefDeclaration typedef) {
        ValueDeclarationScope scope = (ValueDeclarationScope)this.getFirstScopeThat(ValueDeclarationScope.class::isInstance);
        if (scope == null) {
            LOGGER.error("Cannot add typedef. Not in declaration scope.");
            return;
        }
        scope.addTypedef(typedef);
        if (scope.astNode == null) {
            this.lang.getCurrentTU().addTypedef(typedef);
        } else {
            scope.astNode.addTypedef(typedef);
        }
    }

    public List<TypedefDeclaration> getCurrentTypedefs() {
        return this.getCurrentTypedefs(this.currentScope);
    }

    private List<TypedefDeclaration> getCurrentTypedefs(Scope scope) {
        ArrayList<TypedefDeclaration> curr = new ArrayList<TypedefDeclaration>();
        if (scope instanceof ValueDeclarationScope) {
            curr.addAll(((ValueDeclarationScope)scope).getTypedefs());
        }
        if (scope.getParent() != null) {
            for (TypedefDeclaration parentTypedef : this.getCurrentTypedefs(scope.getParent())) {
                if (!curr.stream().map(TypedefDeclaration::getAlias).noneMatch(parentTypedef.getAlias()::equals)) continue;
                curr.add(parentTypedef);
            }
        }
        return curr;
    }

    public String getCurrentNamePrefix() {
        Scope namedScope = this.getFirstScopeThat(scope -> scope instanceof NameScope || scope instanceof RecordScope);
        if (namedScope instanceof NameScope) {
            return ((NameScope)namedScope).getNamePrefix();
        }
        if (namedScope instanceof RecordScope) {
            return namedScope.getAstNode().getName();
        }
        return "";
    }

    public String getCurrentNamePrefixWithDelimiter() {
        Object namePrefix = this.getCurrentNamePrefix();
        if (!((String)namePrefix).isEmpty()) {
            namePrefix = (String)namePrefix + this.lang.getNamespaceDelimiter();
        }
        return namePrefix;
    }

    public @Nullable ValueDeclaration resolve(DeclaredReferenceExpression ref) {
        return this.resolve(this.currentScope, ref);
    }

    private @Nullable ValueDeclaration resolve(Scope scope, DeclaredReferenceExpression ref) {
        if (scope instanceof ValueDeclarationScope) {
            for (ValueDeclaration valDecl : ((ValueDeclarationScope)scope).getValueDeclarations()) {
                if (!valDecl.getName().equals(ref.getName())) continue;
                if (ref.getType() instanceof FunctionPointerType && valDecl instanceof FunctionDeclaration) {
                    FunctionPointerType fptrType = (FunctionPointerType)ref.getType();
                    FunctionDeclaration d = (FunctionDeclaration)valDecl;
                    if (!d.getType().equals(fptrType.getReturnType()) || !d.hasSignature(fptrType.getParameters())) continue;
                    return valDecl;
                }
                return valDecl;
            }
        }
        return scope.getParent() != null ? this.resolve(scope.getParent(), ref) : null;
    }

    private Scope resolveScopeWithPath(@Nullable String astNodeName) {
        if (astNodeName == null || astNodeName.isEmpty()) {
            return this.currentScope;
        }
        List<String> namePath = Arrays.asList(astNodeName.split(Pattern.quote(this.lang.getNamespaceDelimiter())));
        List<String> currentPath = Arrays.asList(this.getCurrentNamePrefix().split(Pattern.quote(this.lang.getNamespaceDelimiter())));
        int nameIndexInCurrent = currentPath.lastIndexOf(namePath.get(0));
        if (nameIndexInCurrent >= 0) {
            List<String> mergedPath = currentPath.subList(0, nameIndexInCurrent);
            mergedPath.addAll(namePath);
            return this.fqnScopeMap.getOrDefault(String.join((CharSequence)this.lang.getNamespaceDelimiter(), mergedPath), null);
        }
        String relativeToAbsolute = this.getCurrentNamePrefixWithDelimiter() + this.lang.getNamespaceDelimiter() + String.join((CharSequence)this.lang.getNamespaceDelimiter(), namePath);
        Scope scope = this.fqnScopeMap.getOrDefault(relativeToAbsolute, null);
        if (scope != null) {
            return scope;
        }
        return this.fqnScopeMap.getOrDefault(astNodeName, null);
    }

    private @Nullable ValueDeclaration resolveInSingleScope(Scope scope, DeclaredReferenceExpression ref) {
        if (scope instanceof ValueDeclarationScope) {
            for (ValueDeclaration valDecl : ((ValueDeclarationScope)scope).getValueDeclarations()) {
                if (!valDecl.getName().equals(ref.getName())) continue;
                return valDecl;
            }
        }
        return null;
    }

    public @Nullable Declaration resolveInRecord(RecordDeclaration recordDeclaration, DeclaredReferenceExpression ref) {
        ArrayList<Declaration> members = new ArrayList<Declaration>();
        members.addAll(recordDeclaration.getFields());
        members.addAll(recordDeclaration.getMethods());
        members.addAll(recordDeclaration.getRecords());
        for (Declaration member : members) {
            if (!member.getName().equals(ref.getName())) continue;
            return member;
        }
        return null;
    }

    public @Nullable Declaration resolveInInheritanceHierarchy(RecordDeclaration recordDeclaration, DeclaredReferenceExpression ref) {
        Declaration resolved = this.resolveInRecord(recordDeclaration, ref);
        if (resolved != null) {
            return resolved;
        }
        for (RecordDeclaration ancestor : recordDeclaration.getSuperTypeDeclarations()) {
            resolved = this.resolveInInheritanceHierarchy(ancestor, ref);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    public Scope getScopeOfStatment(Node node) {
        return this.scopeMap.getOrDefault(node, null);
    }

    public void connectToLocal(DeclaredReferenceExpression referenceExpression) {
        RecordDeclaration currentRecord;
        FunctionDeclaration currentFunction;
        CompoundStatement currentBlock;
        if (this.isInBlock() && this.expressionRefersToDeclaration(referenceExpression, (currentBlock = this.getCurrentBlock()).getLocals())) {
            return;
        }
        if (this.isInFunction() && (currentFunction = this.getCurrentFunction()) != null && this.expressionRefersToDeclaration(referenceExpression, currentFunction.getParameters())) {
            return;
        }
        if (this.isInRecord() && this.expressionRefersToDeclaration(referenceExpression, (currentRecord = this.getCurrentRecord()).getFields())) {
            return;
        }
        this.expressionRefersToDeclaration(referenceExpression, this.getGlobals());
    }

    private <T extends ValueDeclaration> boolean expressionRefersToDeclaration(DeclaredReferenceExpression referenceExpression, List<T> variables) {
        Optional<ValueDeclaration> any = variables.stream().filter(param -> Objects.equals(param.getName(), referenceExpression.getName())).findAny();
        if (any.isPresent()) {
            ValueDeclaration declaration = any.get();
            referenceExpression.setRefersTo(declaration);
            referenceExpression.setType(declaration.getType());
            LOGGER.debug("Connecting {} to method parameter {} of type {}", referenceExpression, declaration, declaration.getType());
            return true;
        }
        return false;
    }

    public @Nullable RecordDeclaration getRecordForName(Scope scope, String name) {
        Optional<Object> o = Optional.empty();
        if (scope instanceof StructureDeclarationScope) {
            o = ((StructureDeclarationScope)scope).getStructureDeclarations().stream().filter(d -> d instanceof RecordDeclaration && Objects.equals(d.getName(), name)).map(d -> (RecordDeclaration)d).findFirst();
        }
        if (o.isPresent()) {
            return (RecordDeclaration)o.get();
        }
        if (scope.getParent() == null) {
            return null;
        }
        return this.getRecordForName(scope.getParent(), name);
    }
}

