/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.CallableInterface;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CatchClause;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DefaultStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ForStatement;
import de.fraunhofer.aisec.cpg.graph.statements.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.SynchronizedStatement;
import de.fraunhofer.aisec.cpg.graph.statements.TryStatement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CastExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.CompoundStatementExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeleteExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Literal;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.NewExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.TypeIdExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.UninitializedValue;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.scopes.FunctionScope;
import de.fraunhofer.aisec.cpg.passes.scopes.LoopScope;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.SwitchScope;
import de.fraunhofer.aisec.cpg.passes.scopes.TryScope;
import de.fraunhofer.aisec.cpg.passes.scopes.ValueDeclarationScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationOrderGraphPass
extends Pass {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluationOrderGraphPass.class);
    protected final Map<Class<? extends Node>, CallableInterface<? extends Node>> map = new HashMap<Class<? extends Node>, CallableInterface<? extends Node>>();
    private List<Node> currentEOG = new ArrayList<Node>();
    private EnumMap<Properties, Object> currentProperties = new EnumMap(Properties.class);
    private List<Node> intermediateNodes = new ArrayList<Node>();

    public EvaluationOrderGraphPass() {
        this.map.put(TranslationUnitDeclaration.class, this::handleTranslationUnitDeclaration);
        this.map.put(NamespaceDeclaration.class, this::handleNamespaceDeclaration);
        this.map.put(RecordDeclaration.class, this::handleRecordDeclaration);
        this.map.put(FunctionDeclaration.class, this::handleFunctionDeclaration);
        this.map.put(VariableDeclaration.class, this::handleVariableDeclaration);
        this.map.put(CallExpression.class, this::handleCallExpression);
        this.map.put(MemberExpression.class, this::handleMemberExpression);
        this.map.put(ArraySubscriptionExpression.class, this::handleArraySubscriptionExpression);
        this.map.put(ArrayCreationExpression.class, this::handleArrayCreationExpression);
        this.map.put(DeclarationStatement.class, this::handleDeclarationStatement);
        this.map.put(ReturnStatement.class, this::handleReturnStatement);
        this.map.put(BinaryOperator.class, this::handleBinaryOperator);
        this.map.put(UnaryOperator.class, this::handleUnaryOperator);
        this.map.put(CompoundStatement.class, this::handleCompoundStatement);
        this.map.put(CompoundStatementExpression.class, this::handleCompoundStatementExpression);
        this.map.put(IfStatement.class, this::handleIfStatement);
        this.map.put(AssertStatement.class, this::handleAssertStatement);
        this.map.put(WhileStatement.class, this::handleWhileStatement);
        this.map.put(DoStatement.class, this::handleDoStatement);
        this.map.put(ForStatement.class, this::handleForStatement);
        this.map.put(ForEachStatement.class, this::handleForEachStatement);
        this.map.put(TryStatement.class, this::handleTryStatement);
        this.map.put(ContinueStatement.class, this::handleContinueStatement);
        this.map.put(DeleteExpression.class, this::handleDeleteExpression);
        this.map.put(BreakStatement.class, this::handleBreakStatement);
        this.map.put(SwitchStatement.class, this::handleSwitchStatement);
        this.map.put(LabelStatement.class, this::handleLabelStatement);
        this.map.put(GotoStatement.class, this::handleGotoStatement);
        this.map.put(CaseStatement.class, this::handleCaseStatement);
        this.map.put(SynchronizedStatement.class, this::handleSynchronizedStatement);
        this.map.put(NewExpression.class, this::handleNewExpression);
        this.map.put(CastExpression.class, this::handleCastExpression);
        this.map.put(ExpressionList.class, this::handleExpressionList);
        this.map.put(ConditionalExpression.class, this::handleConditionalExpression);
        this.map.put(InitializerListExpression.class, this::handleInitializerListExpression);
        this.map.put(ConstructExpression.class, this::handleConstructExpression);
        this.map.put(EmptyStatement.class, this::handleDefault);
        this.map.put(Literal.class, this::handleDefault);
        this.map.put(UninitializedValue.class, this::handleDefault);
        this.map.put(DefaultStatement.class, this::handleDefault);
        this.map.put(TypeIdExpression.class, this::handleDefault);
        this.map.put(DeclaredReferenceExpression.class, this::handleDefault);
    }

    private static boolean reachableFromValidEOGRoot(@NonNull Node node) {
        HashSet<Node> passedBy = new HashSet<Node>();
        ArrayList<Node> workList = new ArrayList<Node>(node.getPrevEOG());
        while (!workList.isEmpty()) {
            Node toProcess = (Node)workList.get(0);
            workList.remove(toProcess);
            passedBy.add(toProcess);
            if (toProcess instanceof FunctionDeclaration) {
                return true;
            }
            for (Node pred : toProcess.getPrevEOG()) {
                if (passedBy.contains(pred) || workList.contains(pred)) continue;
                workList.add(pred);
            }
        }
        return false;
    }

    @Override
    public void cleanup() {
        this.intermediateNodes.clear();
        this.currentEOG.clear();
    }

    @Override
    public void accept(TranslationResult result) {
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.createEOG(tu);
            this.removeUnreachableEOGEdges(tu);
        }
    }

    private void truncateLooseEdges(@NonNull List<Node> eogSources) {
        for (Node eogSourceNode : eogSources) {
            if (eogSourceNode instanceof FunctionDeclaration) continue;
            ArrayList<Node> nextNodes = new ArrayList<Node>(eogSourceNode.getNextEOG());
            eogSourceNode.clearNextEOG();
            nextNodes.forEach(node -> node.removePrevEOGEntry(eogSourceNode));
            this.truncateLooseEdges(nextNodes.stream().filter(node -> node.getPrevEOG().isEmpty() && !node.getNextEOG().isEmpty()).collect(Collectors.toList()));
        }
    }

    private void removeUnreachableEOGEdges(@NonNull TranslationUnitDeclaration tu) {
        List eognodes = SubgraphWalker.flattenAST(tu).stream().filter(node -> !node.getPrevEOG().isEmpty() || !node.getNextEOG().isEmpty()).collect(Collectors.toList());
        Set validStarts = eognodes.stream().filter(node -> node instanceof FunctionDeclaration).collect(Collectors.toSet());
        while (!validStarts.isEmpty()) {
            eognodes.removeAll(validStarts);
            validStarts = validStarts.stream().flatMap(node -> node.getNextEOG().stream()).filter(eognodes::contains).collect(Collectors.toSet());
        }
        for (Node unvisitedNode : eognodes) {
            unvisitedNode.getNextEOGPropertyEdge().forEach(next -> ((Node)next.getEnd()).removePrevEOGEntry(unvisitedNode));
            unvisitedNode.getNextEOGPropertyEdge().clear();
        }
    }

    private void handleTranslationUnitDeclaration(@NonNull Node node) {
        TranslationUnitDeclaration declaration = (TranslationUnitDeclaration)node;
        for (Declaration child : declaration.getDeclarations()) {
            this.createEOG(child);
        }
        this.lang.clearProcessed();
    }

    private void handleNamespaceDeclaration(@NonNull Node node) {
        NamespaceDeclaration declaration = (NamespaceDeclaration)node;
        for (Declaration child : declaration.getDeclarations()) {
            this.createEOG(child);
        }
        this.lang.clearProcessed();
    }

    private void handleVariableDeclaration(@NonNull Node node) {
        Declaration declaration = (Declaration)node;
        this.createEOG(((VariableDeclaration)declaration).getInitializer());
        this.pushToEOG(declaration);
    }

    private void handleRecordDeclaration(@NonNull Node node) {
        Declaration declaration = (Declaration)node;
        this.lang.getScopeManager().enterScope(declaration);
        this.currentEOG.clear();
        for (ConstructorDeclaration constructor : ((RecordDeclaration)declaration).getConstructors()) {
            this.createEOG(constructor);
        }
        for (MethodDeclaration method : ((RecordDeclaration)declaration).getMethods()) {
            this.createEOG(method);
        }
        this.lang.getScopeManager().leaveScope(declaration);
    }

    private void handleFunctionDeclaration(@NonNull Node node) {
        FunctionDeclaration funcDecl = (FunctionDeclaration)node;
        this.currentEOG.clear();
        this.lang.getScopeManager().enterScope(funcDecl);
        this.pushToEOG(funcDecl);
        if (funcDecl.hasBody()) {
            this.createEOG(funcDecl.getBody());
        }
        FunctionScope scope = (FunctionScope)this.lang.getScopeManager().getCurrentScope();
        List<Node> uncaughtEOGThrows = scope.getCatchesOrRelays().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        this.addMultipleIncomingEOGEdges(uncaughtEOGThrows, funcDecl.getBody());
        this.lang.getScopeManager().leaveScope(funcDecl);
    }

    public void createEOG(@Nullable Node node) {
        if (node == null) {
            return;
        }
        this.intermediateNodes.add(node);
        Class<?> toHandle = node.getClass();
        CallableInterface<? extends Node> callable = this.map.get(toHandle);
        while (callable == null) {
            toHandle = toHandle.getSuperclass();
            callable = this.map.get(toHandle);
            if (toHandle != Node.class && Node.class.isAssignableFrom(toHandle)) continue;
        }
        if (callable != null) {
            callable.dispatch(node);
        } else {
            LOGGER.info("Parsing of type " + node.getClass() + " is not supported (yet)");
        }
    }

    private void handleDefault(@NonNull Node node) {
        this.pushToEOG(node);
    }

    private void handleCallExpression(@NonNull Node node) {
        CallExpression callExpression = (CallExpression)node;
        if (callExpression instanceof MemberCallExpression && callExpression.getBase() instanceof Statement) {
            this.createEOG(callExpression.getBase());
        }
        for (Expression arg : callExpression.getArguments()) {
            this.createEOG(arg);
        }
        this.pushToEOG(callExpression);
    }

    private void handleMemberExpression(@NonNull Node node) {
        MemberExpression memberExpression = (MemberExpression)node;
        this.createEOG(memberExpression.getBase());
        this.pushToEOG(memberExpression);
    }

    private void handleArraySubscriptionExpression(@NonNull Node node) {
        ArraySubscriptionExpression arraySubs = (ArraySubscriptionExpression)node;
        this.createEOG(arraySubs.getArrayExpression());
        this.createEOG(arraySubs.getSubscriptExpression());
        this.pushToEOG(arraySubs);
    }

    private void handleArrayCreationExpression(@NonNull Node node) {
        ArrayCreationExpression arrayCreate = (ArrayCreationExpression)node;
        for (Expression dimension : arrayCreate.getDimensions()) {
            if (dimension == null) continue;
            this.createEOG(dimension);
        }
        this.createEOG(arrayCreate.getInitializer());
        this.pushToEOG(arrayCreate);
    }

    private void handleDeclarationStatement(@NonNull Node node) {
        DeclarationStatement declarationStatement = (DeclarationStatement)node;
        for (Declaration declaration : declarationStatement.getDeclarations()) {
            if (!(declaration instanceof VariableDeclaration)) continue;
            this.createEOG(declaration);
        }
        this.pushToEOG(declarationStatement);
    }

    private void handleReturnStatement(@NonNull Node node) {
        ReturnStatement returnStatement = (ReturnStatement)node;
        this.createEOG(returnStatement.getReturnValue());
        this.pushToEOG(returnStatement);
        this.currentEOG.clear();
    }

    private void handleBinaryOperator(@NonNull Node node) {
        BinaryOperator binOp = (BinaryOperator)node;
        this.createEOG(binOp.getLhs());
        ArrayList<Node> shortCircuitNodes = new ArrayList<Node>();
        if (binOp.getOperatorCode().equals("&&") || binOp.getOperatorCode().equals("||")) {
            shortCircuitNodes.addAll(this.currentEOG);
        }
        this.createEOG(binOp.getRhs());
        shortCircuitNodes.addAll(this.currentEOG);
        this.setCurrentEOGs(shortCircuitNodes);
        this.pushToEOG(binOp);
    }

    private void handleCompoundStatement(@NonNull Node node) {
        CompoundStatement compoundStatement = (CompoundStatement)node;
        this.lang.getScopeManager().enterScope(compoundStatement);
        for (Statement child : compoundStatement.getStatements()) {
            this.createEOG(child);
        }
        this.lang.getScopeManager().leaveScope(compoundStatement);
        this.pushToEOG(compoundStatement);
    }

    private void handleUnaryOperator(@NonNull Node node) {
        UnaryOperator unaryOperator = (UnaryOperator)node;
        Expression input = unaryOperator.getInput();
        this.createEOG(input);
        if (unaryOperator.getOperatorCode().equals("throw")) {
            Type throwType;
            Scope catchingScope = this.lang.getScopeManager().getFirstScopeThat(scope -> scope instanceof TryScope || scope instanceof FunctionScope);
            if (input != null) {
                throwType = input.getType();
            } else {
                Scope decl = this.lang.getScopeManager().getFirstScopeThat(scope -> scope.getClass().equals(ValueDeclarationScope.class));
                if (decl != null && decl.getAstNode() instanceof CatchClause && ((CatchClause)decl.getAstNode()).getParameter() != null) {
                    VariableDeclaration param = ((CatchClause)decl.getAstNode()).getParameter();
                    assert (param != null);
                    throwType = param.getType();
                } else {
                    LOGGER.info("Unknown throw type, potentially throw; in a method");
                    throwType = TypeParser.createFrom("UNKNOWN_THROW_TYPE", true);
                }
            }
            this.pushToEOG(unaryOperator);
            if (catchingScope instanceof TryScope) {
                ((TryScope)catchingScope).getCatchesOrRelays().put(throwType, new ArrayList<Node>(this.currentEOG));
            } else if (catchingScope instanceof FunctionScope) {
                ((FunctionScope)catchingScope).getCatchesOrRelays().put(throwType, new ArrayList<Node>(this.currentEOG));
            }
            this.currentEOG.clear();
        } else {
            this.pushToEOG(unaryOperator);
        }
    }

    private void handleCompoundStatementExpression(@NonNull Node node) {
        this.createEOG(((CompoundStatementExpression)node).getStatement());
        this.pushToEOG(node);
    }

    private void handleAssertStatement(@NonNull Node node) {
        AssertStatement ifs = (AssertStatement)node;
        this.createEOG(ifs.getCondition());
        ArrayList<Node> openConditionEOGs = new ArrayList<Node>(this.currentEOG);
        this.createEOG(ifs.getMessage());
        this.setCurrentEOGs(openConditionEOGs);
        this.pushToEOG(node);
    }

    private void handleTryStatement(@NonNull Node node) {
        Scope scope2;
        TryStatement tryStatement = (TryStatement)node;
        this.lang.getScopeManager().enterScope(tryStatement);
        TryScope tryScope = (TryScope)this.lang.getScopeManager().getCurrentScope();
        TryStatement tryStmt = tryStatement;
        if (tryStmt.getResources() != null) {
            tryStmt.getResources().forEach(this::createEOG);
        }
        this.createEOG(tryStmt.getTryBlock());
        ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
        Map<Type, List<Node>> catchesOrRelays = tryScope.getCatchesOrRelays();
        for (CatchClause catchClause : tryStmt.getCatchClauses()) {
            this.currentEOG.clear();
            HashSet<Type> hashSet = new HashSet<Type>();
            for (Map.Entry<Type, List<Node>> entry2 : catchesOrRelays.entrySet()) {
                Type throwType = entry2.getKey();
                List<Node> eogEdges = entry2.getValue();
                if (catchClause.getParameter() == null) {
                    this.currentEOG.addAll(eogEdges);
                    continue;
                }
                if (!TypeManager.getInstance().isSupertypeOf(catchClause.getParameter().getType(), throwType)) continue;
                this.currentEOG.addAll(eogEdges);
                hashSet.add(throwType);
            }
            hashSet.forEach(catchesOrRelays::remove);
            this.createEOG(catchClause.getBody());
            tmpEOGNodes.addAll(this.currentEOG);
        }
        boolean canTerminateExceptionfree = tmpEOGNodes.stream().anyMatch(EvaluationOrderGraphPass::reachableFromValidEOGRoot);
        this.currentEOG.clear();
        this.currentEOG.addAll(tmpEOGNodes);
        if (tryStmt.getFinallyBlock() != null) {
            this.currentEOG.addAll(catchesOrRelays.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList()));
            this.createEOG(tryStmt.getFinallyBlock());
            for (Map.Entry<Type, List<Node>> entry2 : catchesOrRelays.entrySet()) {
                entry2.getValue().clear();
                entry2.getValue().addAll(this.currentEOG);
            }
        }
        if ((scope2 = this.lang.getScopeManager().getFirstScopeThat(this.lang.getScopeManager().getCurrentScope().getParent(), scope -> scope instanceof TryScope || scope instanceof FunctionScope)) != null) {
            Map<Type, List<Node>> map = scope2 instanceof TryScope ? ((TryScope)scope2).getCatchesOrRelays() : ((FunctionScope)scope2).getCatchesOrRelays();
            for (Map.Entry<Type, List<Node>> entry3 : catchesOrRelays.entrySet()) {
                List catches = map.getOrDefault(entry3.getKey(), new ArrayList());
                catches.addAll(entry3.getValue());
                map.put(entry3.getKey(), catches);
            }
        }
        this.lang.getScopeManager().leaveScope(tryStatement);
        if (!canTerminateExceptionfree) {
            this.currentEOG.clear();
        }
        this.pushToEOG(tryStatement);
    }

    private void handleContinueStatement(@NonNull Node node) {
        this.pushToEOG(node);
        this.lang.getScopeManager().addContinueStatement((ContinueStatement)node);
        this.currentEOG.clear();
    }

    private void handleDeleteExpression(@NonNull Node node) {
        this.createEOG(((DeleteExpression)node).getOperand());
        this.pushToEOG(node);
    }

    private void handleBreakStatement(@NonNull Node node) {
        this.pushToEOG(node);
        this.lang.getScopeManager().addBreakStatement((BreakStatement)node);
        this.currentEOG.clear();
    }

    private void handleLabelStatement(@NonNull Node node) {
        LabelStatement labelStatement = (LabelStatement)node;
        this.lang.getScopeManager().addLabelStatement(labelStatement);
        this.createEOG(labelStatement.getSubStatement());
    }

    private void handleGotoStatement(@NonNull Node node) {
        GotoStatement gotoStatement = (GotoStatement)node;
        this.pushToEOG(gotoStatement);
        if (gotoStatement.getTargetLabel() != null) {
            this.lang.registerObjectListener(gotoStatement.getTargetLabel(), (from, to) -> this.addEOGEdge(gotoStatement, (Node)to));
        }
        this.currentEOG.clear();
    }

    private void handleCaseStatement(@NonNull Node node) {
        this.createEOG(((CaseStatement)node).getCaseExpression());
        this.pushToEOG(node);
    }

    private void handleNewExpression(@NonNull Node node) {
        NewExpression newStmt = (NewExpression)node;
        this.createEOG(newStmt.getInitializer());
        this.pushToEOG(node);
    }

    private void handleCastExpression(@NonNull Node node) {
        CastExpression castExpr = (CastExpression)node;
        this.createEOG(castExpr.getExpression());
        this.pushToEOG(castExpr);
    }

    private void handleExpressionList(@NonNull Node node) {
        ExpressionList exprList = (ExpressionList)node;
        for (Statement expr : exprList.getExpressions()) {
            this.createEOG(expr);
        }
        this.pushToEOG(exprList);
    }

    private void handleInitializerListExpression(@NonNull Node node) {
        InitializerListExpression initList = (InitializerListExpression)node;
        for (Expression inits : initList.getInitializers()) {
            this.createEOG(inits);
        }
        this.pushToEOG(initList);
    }

    private void handleConstructExpression(@NonNull Node node) {
        ConstructExpression constructExpr = (ConstructExpression)node;
        for (Expression arg : constructExpr.getArguments()) {
            this.createEOG(arg);
        }
        this.pushToEOG(constructExpr);
    }

    public void pushToEOG(@NonNull Node node) {
        LOGGER.trace("Pushing {} {} to EOG", (Object)node.getClass().getSimpleName(), (Object)node);
        for (Node intermediate : this.intermediateNodes) {
            this.lang.process(intermediate, node);
        }
        this.addMultipleIncomingEOGEdges(this.currentEOG, node);
        this.intermediateNodes.clear();
        this.currentEOG.clear();
        this.currentProperties.clear();
        this.currentEOG.add(node);
    }

    public List<Node> getCurrentEOG() {
        return this.currentEOG;
    }

    public void setCurrentEOG(List<Node> currentEOG) {
        this.currentEOG = currentEOG;
    }

    public void setCurrentEOG(Node node) {
        LOGGER.trace("Setting {} to EOG", (Object)node);
        this.currentEOG = new ArrayList<Node>();
        this.currentEOG.add(node);
    }

    public <T extends Node> void setCurrentEOGs(List<T> nodes) {
        LOGGER.trace("Setting {} to EOGs", (Object)nodes);
        this.currentEOG = new ArrayList<T>(nodes);
    }

    public void addToCurrentEOG(List<Node> nodes) {
        LOGGER.trace("Adding {} to current EOG", (Object)nodes);
        this.currentEOG.addAll(nodes);
    }

    public void exitLoop(@NonNull Statement loopStatement, @NonNull LoopScope loopScope) {
        this.currentEOG.addAll(loopScope.getBreakStatements());
        ArrayList<ContinueStatement> continues = new ArrayList<ContinueStatement>(loopScope.getContinueStatements());
        if (!continues.isEmpty()) {
            Statement condition = loopStatement instanceof DoStatement ? ((DoStatement)loopStatement).getCondition() : (loopStatement instanceof ForStatement ? ((ForStatement)loopStatement).getCondition() : (loopStatement instanceof ForEachStatement ? loopStatement : (loopStatement instanceof AssertStatement ? loopStatement : ((WhileStatement)loopStatement).getCondition())));
            List<Node> conditions = SubgraphWalker.getEOGPathEdges(condition).getEntries();
            conditions.forEach(node -> this.addMultipleIncomingEOGEdges((List<Node>)continues, (Node)node));
        }
    }

    public void connectCurrentToLoopStart() {
        if (this.lang == null) {
            LOGGER.warn("Skipping connection of EOG loop to start - no information about frontend available.");
            return;
        }
        LoopScope loopScope = (LoopScope)this.lang.getScopeManager().getFirstScopeThat(scope -> scope instanceof LoopScope);
        if (loopScope == null) {
            LOGGER.error("I am unexpectedly not in a loop, cannot add edge to loop start");
            return;
        }
        loopScope.starts().forEach(node -> this.addMultipleIncomingEOGEdges(this.currentEOG, (Node)node));
    }

    public void addEOGEdge(Node prev, Node next) {
        PropertyEdge<Node> propertyEdge = new PropertyEdge<Node>(prev, next);
        propertyEdge.addProperties(this.currentProperties);
        propertyEdge.addProperty(Properties.INDEX, prev.getNextEOG().size());
        prev.addNextEOG(propertyEdge);
        next.addPrevEOG(propertyEdge);
    }

    public void addMultipleIncomingEOGEdges(List<Node> prevs, Node next) {
        prevs.forEach(prev -> this.addEOGEdge((Node)prev, next));
    }

    private void handleSynchronizedStatement(@NonNull Node node) {
        SynchronizedStatement synch = (SynchronizedStatement)node;
        this.createEOG(synch.getExpression());
        this.pushToEOG(synch);
        this.createEOG(synch.getBlockStatement());
    }

    private void handleConditionalExpression(@NonNull Node node) {
        ConditionalExpression conditionalExpression = (ConditionalExpression)node;
        ArrayList<Node> openBranchNodes = new ArrayList<Node>();
        this.createEOG(conditionalExpression.getCondition());
        this.pushToEOG(conditionalExpression);
        ArrayList<Node> openConditionEOGs = new ArrayList<Node>(this.currentEOG);
        this.createEOG(conditionalExpression.getThenExpr());
        openBranchNodes.addAll(this.currentEOG);
        this.setCurrentEOGs(openConditionEOGs);
        this.createEOG(conditionalExpression.getElseExpr());
        openBranchNodes.addAll(this.currentEOG);
        this.setCurrentEOGs(openBranchNodes);
    }

    private void handleDoStatement(@NonNull Node node) {
        DoStatement doStatement = (DoStatement)node;
        this.lang.getScopeManager().enterScope(doStatement);
        this.createEOG(doStatement.getStatement());
        this.createEOG(doStatement.getCondition());
        this.pushToEOG(doStatement);
        this.connectCurrentToLoopStart();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(doStatement);
        if (currentLoopScope != null) {
            this.exitLoop(doStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit do loop, but no loop scope: {}", (Object)doStatement.toString());
        }
    }

    private void handleForEachStatement(@NonNull Node node) {
        ForEachStatement forEachStatement = (ForEachStatement)node;
        this.lang.getScopeManager().enterScope(forEachStatement);
        this.createEOG(forEachStatement.getIterable());
        this.createEOG(forEachStatement.getVariable());
        this.pushToEOG(forEachStatement);
        ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
        this.createEOG(forEachStatement.getStatement());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(forEachStatement);
        if (currentLoopScope != null) {
            this.exitLoop(forEachStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit foreach loop, but not in loop scope: {}", (Object)forEachStatement.toString());
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }

    private void handleForStatement(@NonNull Node node) {
        ForStatement forStatement = (ForStatement)node;
        this.lang.getScopeManager().enterScope(forStatement);
        ForStatement forStmt = forStatement;
        this.createEOG(forStmt.getInitializerStatement());
        this.createEOG(forStmt.getConditionDeclaration());
        this.createEOG(forStmt.getCondition());
        this.pushToEOG(forStatement);
        ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
        this.createEOG(forStmt.getStatement());
        this.createEOG(forStmt.getIterationExpression());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(forStatement);
        if (currentLoopScope != null) {
            this.exitLoop(forStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit for loop, but no loop scope: {}", (Object)forStatement.toString());
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }

    private void handleIfStatement(@NonNull Node node) {
        IfStatement ifStatement = (IfStatement)node;
        ArrayList<Node> openBranchNodes = new ArrayList<Node>();
        this.lang.getScopeManager().enterScope(ifStatement);
        this.createEOG(ifStatement.getInitializerStatement());
        this.createEOG(ifStatement.getConditionDeclaration());
        this.createEOG(ifStatement.getCondition());
        this.pushToEOG(ifStatement);
        ArrayList<Node> openConditionEOGs = new ArrayList<Node>(this.currentEOG);
        this.currentProperties.put(Properties.BRANCH, (Object)true);
        this.createEOG(ifStatement.getThenStatement());
        openBranchNodes.addAll(this.currentEOG);
        if (ifStatement.getElseStatement() != null) {
            this.setCurrentEOGs(openConditionEOGs);
            this.currentProperties.put(Properties.BRANCH, (Object)false);
            this.createEOG(ifStatement.getElseStatement());
            openBranchNodes.addAll(this.currentEOG);
        } else {
            openBranchNodes.addAll(openConditionEOGs);
        }
        this.lang.getScopeManager().leaveScope(ifStatement);
        this.setCurrentEOGs(openBranchNodes);
    }

    private void handleSwitchStatement(@NonNull Node node) {
        CompoundStatement compound;
        SwitchStatement switchStatement = (SwitchStatement)node;
        this.lang.getScopeManager().enterScope(switchStatement);
        this.createEOG(switchStatement.getInitializerStatement());
        this.createEOG(switchStatement.getSelectorDeclaration());
        this.createEOG(switchStatement.selector);
        this.pushToEOG(switchStatement);
        ArrayList<Node> tmp = new ArrayList<Node>(this.currentEOG);
        if (switchStatement.getStatement() instanceof DoStatement) {
            this.createEOG(switchStatement.getStatement());
            compound = (CompoundStatement)((DoStatement)switchStatement.getStatement()).getStatement();
        } else {
            compound = (CompoundStatement)switchStatement.getStatement();
        }
        this.currentEOG = new ArrayList<Node>();
        for (Statement subStatement : compound.getStatements()) {
            if (subStatement instanceof CaseStatement || subStatement instanceof DefaultStatement) {
                this.currentEOG.addAll(tmp);
            }
            this.createEOG(subStatement);
        }
        this.pushToEOG(compound);
        SwitchScope switchScope = (SwitchScope)this.lang.getScopeManager().leaveScope(switchStatement);
        if (switchScope != null) {
            this.currentEOG.addAll(switchScope.getBreakStatements());
        } else {
            LOGGER.error("Handling switch statement, but not in switch scope: {}", (Object)switchStatement.toString());
        }
    }

    private void handleWhileStatement(@NonNull Node node) {
        WhileStatement whileStatement = (WhileStatement)node;
        this.lang.getScopeManager().enterScope(whileStatement);
        this.createEOG(whileStatement.getConditionDeclaration());
        this.createEOG(whileStatement.getCondition());
        this.pushToEOG(whileStatement);
        ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
        this.createEOG(whileStatement.getStatement());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(whileStatement);
        if (currentLoopScope != null) {
            this.exitLoop(whileStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit while loop, but no loop scope: {}", (Object)whileStatement.toString());
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }
}

