/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DoStatement;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.statements.WhileStatement;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ControlFlowGraphPass
extends Pass {
    private List<Statement> remaining = new CopyOnWriteArrayList<Statement>();
    private Deque<BreakContinueScope> breakContinueScopes = new ArrayDeque<BreakContinueScope>();

    @Override
    public void cleanup() {
        this.remaining.clear();
        this.breakContinueScopes.clear();
    }

    @Override
    public void accept(TranslationResult t) {
        for (TranslationUnitDeclaration tu : t.getTranslationUnits()) {
            for (Declaration decl : tu.getDeclarations()) {
                this.handleDeclaration(decl);
            }
        }
    }

    private void handleDeclaration(Declaration decl) {
        if (decl instanceof RecordDeclaration) {
            this.handleRecordDeclaration((RecordDeclaration)decl);
        } else if (decl instanceof NamespaceDeclaration) {
            for (Declaration declaration : ((NamespaceDeclaration)decl).getDeclarations()) {
                this.handleDeclaration(declaration);
            }
        } else if (decl instanceof FunctionDeclaration) {
            this.handleFunctionDeclaration((FunctionDeclaration)decl);
        }
    }

    private void handleFunctionDeclaration(FunctionDeclaration decl) {
        Statement body = decl.getBody();
        decl.addNextCFG(body);
        if (body != null) {
            this.handleBody((CompoundStatement)body);
        }
    }

    private void handleRecordDeclaration(RecordDeclaration decl) {
        for (MethodDeclaration m3 : decl.getMethods()) {
            this.handleFunctionDeclaration(m3);
        }
    }

    private void handleBody(CompoundStatement body) {
        List<Statement> containedStmts = body.getStatements();
        body.addNextCFG(containedStmts.get(0));
        this.handleStatements(body);
    }

    private void handleStatements(CompoundStatement body) {
        HashSet<Node> doNotLinkToFollowingStmt = new HashSet<Node>();
        this.remaining.addAll(body.getStatements());
        for (int i = 0; i < this.remaining.size(); ++i) {
            BreakContinueScope scope;
            Statement stmt = this.remaining.get(i);
            if (stmt == null) continue;
            this.updateBreakContinueScopes(i, stmt);
            ArrayList<Node> targets = new ArrayList<Node>();
            if (this.isIfStmt(stmt)) {
                List<Node> ifThenBlocks = this.getJumpTargets((IfStatement)stmt);
                targets.addAll(ifThenBlocks);
                if (ifThenBlocks.size() < 2) {
                    targets.add(this.remaining.get(i + 1));
                }
                Statement thenStmt = ((IfStatement)stmt).getThenStatement();
                doNotLinkToFollowingStmt.add(this.lastStatementInCompound(thenStmt));
                if (!this.isBreakOrContinue(thenStmt)) {
                    thenStmt.addNextCFG(this.remaining.get(i + 1));
                }
                this.addTodo(i, thenStmt);
                Statement elseStmt = ((IfStatement)stmt).getElseStatement();
                if (elseStmt != null) {
                    this.addTodo(i + 1, elseStmt);
                }
            } else if (stmt instanceof ContinueStatement) {
                ContinueStatement contStmt = (ContinueStatement)stmt;
                if (!this.breakContinueScopes.isEmpty()) {
                    scope = this.breakContinueScopes.peek();
                    contStmt.addNextCFG(scope.start);
                }
            } else if (stmt instanceof BreakStatement) {
                BreakStatement breakStmt = (BreakStatement)stmt;
                if (!this.breakContinueScopes.isEmpty()) {
                    scope = this.breakContinueScopes.peek();
                    breakStmt.addNextCFG(scope.breakLocation);
                }
            } else if (this.isCompoundStmt(stmt)) {
                List<Statement> containedStmts = ((CompoundStatement)stmt).getStatements();
                this.addTodo(i, containedStmts);
            } else if (stmt instanceof WhileStatement) {
                WhileStatement whileStmt = (WhileStatement)stmt;
                targets.add(this.firstStatementInCompound(whileStmt.getStatement()));
                targets.add(this.remaining.get(i + 1));
                this.addTodo(i, whileStmt.getStatement());
                Node lastInBlock = this.lastStatementInCompound(whileStmt.getStatement());
                if (lastInBlock != null) {
                    lastInBlock.addNextCFG(whileStmt);
                }
                doNotLinkToFollowingStmt.add(this.lastStatementInCompound(whileStmt.getStatement()));
            } else if (stmt instanceof DoStatement) {
                DoStatement doStmt = (DoStatement)stmt;
                this.addTodo(i, doStmt.getStatement());
                targets.add(this.firstStatementInCompound(doStmt.getStatement()));
                doStmt.getCondition().addNextCFG(this.firstStatementInCompound(doStmt.getStatement()));
                this.addTodo(i + 1, doStmt.getCondition());
            } else if (!(stmt instanceof ReturnStatement) && i + 1 < this.remaining.size() && !doNotLinkToFollowingStmt.contains(stmt)) {
                Node nextRealStmt = this.remaining.get(i + 1);
                if (this.isCompoundStmt(nextRealStmt)) {
                    nextRealStmt = this.firstStatementInCompound(nextRealStmt);
                }
                if (nextRealStmt != null) {
                    targets.add(nextRealStmt);
                }
            }
            stmt.addNextCFG(targets);
        }
    }

    private boolean isBreakOrContinue(Statement stmt) {
        return stmt instanceof BreakStatement || stmt instanceof ContinueStatement;
    }

    private void updateBreakContinueScopes(int index, Statement stmt) {
        if (this.isLoopingStmt(stmt)) {
            String label = "";
            Node beginOfScope = null;
            Node endOfScope = null;
            if (stmt instanceof DoStatement) {
                if (this.isCompoundStmt(((DoStatement)stmt).getStatement())) {
                    beginOfScope = this.firstStatementInCompound(((DoStatement)stmt).getStatement());
                    endOfScope = this.lastStatementInCompound(((DoStatement)stmt).getStatement());
                } else {
                    beginOfScope = stmt;
                    endOfScope = stmt;
                }
            } else if (stmt instanceof WhileStatement) {
                if (this.isCompoundStmt(((WhileStatement)stmt).getStatement())) {
                    beginOfScope = this.firstStatementInCompound(((WhileStatement)stmt).getStatement());
                    endOfScope = this.lastStatementInCompound(((WhileStatement)stmt).getStatement());
                } else {
                    beginOfScope = stmt;
                    endOfScope = stmt;
                }
            }
            Statement after = this.remaining.get(index + 1);
            BreakContinueScope scope2 = new BreakContinueScope(beginOfScope, endOfScope, after, label);
            this.breakContinueScopes.add(scope2);
        }
        Optional<BreakContinueScope> oScope = this.breakContinueScopes.stream().filter(scope -> stmt.equals(scope.end)).findAny();
        oScope.ifPresent(breakContinueScope -> this.breakContinueScopes.remove(breakContinueScope));
    }

    private boolean isLoopingStmt(Statement stmt) {
        return stmt instanceof DoStatement || stmt instanceof WhileStatement;
    }

    public void addTodo(int index, List<Statement> stmts) {
        if (index >= this.remaining.size()) {
            this.remaining.addAll(stmts);
        } else {
            this.remaining.addAll(index + 1, stmts);
        }
    }

    public void addTodo(int index, Statement ... statements) {
        this.addTodo(index, Arrays.asList(statements));
    }

    private @Nullable Node firstStatementInCompound(Node stmt) {
        if (!(stmt instanceof CompoundStatement)) {
            return stmt;
        }
        CompoundStatement comp = (CompoundStatement)stmt;
        Statement first = null;
        boolean found = false;
        while (!found) {
            List<Statement> containedStmts = comp.getStatements();
            if (containedStmts.isEmpty()) {
                return null;
            }
            first = containedStmts.get(0);
            if (first instanceof CompoundStatement) {
                comp = (CompoundStatement)first;
                continue;
            }
            found = true;
        }
        return first;
    }

    private @Nullable Node lastStatementInCompound(Node stmt) {
        if (!(stmt instanceof CompoundStatement)) {
            return stmt;
        }
        CompoundStatement comp = (CompoundStatement)stmt;
        Statement last = null;
        boolean found = false;
        while (!found) {
            List<Statement> containedStmts = comp.getStatements();
            if (containedStmts.isEmpty()) {
                return null;
            }
            last = containedStmts.get(containedStmts.size() - 1);
            if (last instanceof CompoundStatement) {
                comp = (CompoundStatement)last;
                continue;
            }
            found = true;
        }
        return last;
    }

    private List<Node> getJumpTargets(IfStatement stmt) {
        Node elseTarget;
        ArrayList<Node> result = new ArrayList<Node>();
        Node thenTarget = stmt.getThenStatement();
        if (this.isCompoundStmt(thenTarget)) {
            thenTarget = this.firstStatementInCompound(thenTarget);
        }
        if (thenTarget != null) {
            result.add(thenTarget);
        }
        if (this.isCompoundStmt(elseTarget = stmt.getElseStatement())) {
            elseTarget = this.firstStatementInCompound(elseTarget);
        }
        if (elseTarget != null) {
            result.add(elseTarget);
        }
        return result;
    }

    private boolean isIfStmt(Statement stmt) {
        return stmt instanceof IfStatement;
    }

    private boolean isCompoundStmt(Node stmt) {
        return stmt instanceof CompoundStatement;
    }

    private static class BreakContinueScope {
        Node start;
        Node end;
        String label;
        Node breakLocation;

        public BreakContinueScope(Node start, Node end, Node breakLocation, String label) {
            this.start = start;
            this.end = end;
            this.label = label;
            this.breakLocation = breakLocation;
        }

        public String toString() {
            return this.label + ": " + this.start.getLocation().getRegion().getStartLine() + " to " + this.end.getLocation().getRegion().getStartLine() + ", will break to " + this.breakLocation.getLocation().getRegion().getStartLine();
        }
    }
}

