/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;

public class LocationConverter
implements CompositeAttributeConverter<PhysicalLocation> {
    @Override
    public Map<String, ?> toGraphProperties(PhysicalLocation value) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (value != null) {
            properties.put("artifact", value.getArtifactLocation().getUri().toString());
            properties.put("startLine", value.getRegion().getStartLine());
            properties.put("endLine", value.getRegion().getEndLine());
            properties.put("startColumn", value.getRegion().getStartColumn());
            properties.put("endColumn", value.getRegion().getEndColumn());
        }
        return properties;
    }

    @Override
    public PhysicalLocation toEntityAttribute(Map<String, ?> value) {
        try {
            int startLine = Math.toIntExact(((Integer)value.get("startLine")).intValue());
            int endLine = Math.toIntExact(((Integer)value.get("endLine")).intValue());
            int startColumn = Math.toIntExact(((Integer)value.get("startColumn")).intValue());
            int endColumn = Math.toIntExact(((Integer)value.get("endColumn")).intValue());
            URI uri = URI.create((String)value.get("artifact"));
            return new PhysicalLocation(uri, new Region(startLine, startColumn, endLine, endColumn));
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

