/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Benchmark {
    private static final Logger log = LoggerFactory.getLogger(Benchmark.class);
    private final String message;
    private final String caller;
    private final Instant start;
    private long duration = -1L;

    public Benchmark(Class c, String message) {
        this.message = message;
        this.caller = c.getSimpleName();
        this.start = Instant.now();
    }

    public long stop() {
        this.duration = Duration.between(this.start, Instant.now()).toMillis();
        log.info("{} {} done in {} ms", this.caller, this.message, this.duration);
        return this.duration;
    }

    public long getDuration() {
        return this.duration;
    }
}

