/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.types;

import de.fraunhofer.aisec.cpg.graph.types.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import java.util.Objects;
import org.neo4j.ogm.annotation.Relationship;

public class PointerType
extends Type
implements SecondOrderType {
    @Relationship(value="ELEMENT_TYPE")
    private Type elementType;
    private PointerOrigin pointerOrigin;

    private PointerType() {
    }

    public PointerType(Type elementType, PointerOrigin pointerOrigin) {
        if (pointerOrigin == PointerOrigin.ARRAY) {
            this.name = elementType.getName() + "[]";
            this.pointerOrigin = PointerOrigin.ARRAY;
        } else {
            this.name = elementType.getName() + "*";
            this.pointerOrigin = PointerOrigin.POINTER;
        }
        this.elementType = elementType;
    }

    public PointerType(Type type, Type elementType, PointerOrigin pointerOrigin) {
        super(type);
        this.name = pointerOrigin == PointerOrigin.ARRAY ? elementType.getName() + "[]" : elementType.getName() + "*";
        this.elementType = elementType;
        this.pointerOrigin = pointerOrigin;
    }

    @Override
    public PointerType reference(PointerOrigin origin) {
        if (origin == null) {
            origin = PointerOrigin.ARRAY;
        }
        return new PointerType(this, origin);
    }

    @Override
    public Type dereference() {
        return this.elementType;
    }

    @Override
    public void refreshNames() {
        if (this.getElementType() instanceof PointerType) {
            ((PointerType)this.getElementType()).refreshNames();
        }
        this.name = this.pointerOrigin == PointerOrigin.ARRAY ? this.getElementType().getName() + "[]" : this.getElementType().getName() + "*";
    }

    @Override
    public Type duplicate() {
        return new PointerType(this, this.elementType.duplicate(), this.pointerOrigin);
    }

    public boolean isArray() {
        return this.pointerOrigin == PointerOrigin.ARRAY;
    }

    @Override
    public boolean isSimilar(Type t) {
        if (!(t instanceof PointerType)) {
            return false;
        }
        PointerType pointerType = (PointerType)t;
        return this.getReferenceDepth() == pointerType.getReferenceDepth() && this.getElementType().isSimilar(pointerType.getRoot()) && super.isSimilar(t);
    }

    public PointerOrigin getPointerOrigin() {
        return this.pointerOrigin;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public int getReferenceDepth() {
        int depth = 1;
        Type containedType = this.elementType;
        while (containedType instanceof PointerType) {
            ++depth;
            containedType = ((PointerType)containedType).getElementType();
        }
        return depth;
    }

    @Override
    public void setElementType(Type elementType) {
        this.elementType = elementType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PointerType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PointerType that = (PointerType)o;
        return Objects.equals(this.elementType, that.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementType);
    }

    @Override
    public String toString() {
        return "PointerType{elementType=" + this.elementType + ", typeName='" + this.name + "', storage=" + this.getStorage() + ", qualifier=" + this.getQualifier() + ", origin=" + this.getTypeOrigin() + "}";
    }

    public static enum PointerOrigin {
        POINTER,
        ARRAY;

    }
}

