/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Relationship;

public class DesignatedInitializerExpression
extends Expression {
    @SubGraph(value={"AST"})
    private Expression rhs;
    @Relationship(value="LHS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Expression>> lhs;

    public Expression getRhs() {
        return this.rhs;
    }

    public void setRhs(Expression rhs) {
        this.rhs = rhs;
    }

    public List<Expression> getLhs() {
        return PropertyEdge.unwrap(this.lhs);
    }

    public List<PropertyEdge<Expression>> getLhsPropertyEdge() {
        return this.lhs;
    }

    public void setLhs(List<Expression> lhs) {
        this.lhs = PropertyEdge.transformIntoOutgoingPropertyEdgeList(lhs, this);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("lhr", this.lhs).append("rhs", this.rhs).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesignatedInitializerExpression)) {
            return false;
        }
        DesignatedInitializerExpression that = (DesignatedInitializerExpression)o;
        return super.equals(that) && Objects.equals(this.rhs, that.rhs) && Objects.equals(this.lhs, that.lhs) && Objects.equals(this.getLhs(), that.getLhs());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

