/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.statements.expressions;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.edge.Properties;
import de.fraunhofer.aisec.cpg.graph.edge.PropertyEdge;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.neo4j.ogm.annotation.Relationship;

public class CallExpression
extends Expression
implements HasType.TypeListener {
    @Relationship(value="INVOKES", direction="OUTGOING")
    protected List<PropertyEdge<FunctionDeclaration>> invokes = new ArrayList<PropertyEdge<FunctionDeclaration>>();
    @Relationship(value="ARGUMENTS", direction="OUTGOING")
    @SubGraph(value={"AST"})
    private List<PropertyEdge<Expression>> arguments = new ArrayList<PropertyEdge<Expression>>();
    @SubGraph(value={"AST"})
    private Node base;
    private String fqn;

    public Node getBase() {
        return this.base;
    }

    public void setBase(Node base) {
        if (this.base instanceof HasType) {
            ((HasType)((Object)this.base)).unregisterTypeListener(this);
        }
        this.base = base;
        if (base instanceof HasType) {
            ((HasType)((Object)base)).registerTypeListener(this);
        }
    }

    public @NonNull List<Expression> getArguments() {
        ArrayList<Expression> targets = new ArrayList<Expression>();
        for (PropertyEdge<Expression> propertyEdge : this.arguments) {
            targets.add(propertyEdge.getEnd());
        }
        return Collections.unmodifiableList(targets);
    }

    public @NonNull List<PropertyEdge<Expression>> getArgumentsPropertyEdge() {
        return this.arguments;
    }

    public void addArgument(Expression expression) {
        PropertyEdge<Expression> propertyEdge = new PropertyEdge<Expression>(this, expression);
        propertyEdge.addProperty(Properties.INDEX, this.arguments.size());
        this.arguments.add(propertyEdge);
    }

    public void setArguments(List<Expression> arguments) {
        this.arguments = PropertyEdge.transformIntoOutgoingPropertyEdgeList(arguments, this);
    }

    public @NonNull List<FunctionDeclaration> getInvokes() {
        ArrayList<FunctionDeclaration> targets = new ArrayList<FunctionDeclaration>();
        for (PropertyEdge<FunctionDeclaration> propertyEdge : this.invokes) {
            targets.add(propertyEdge.getEnd());
        }
        return Collections.unmodifiableList(targets);
    }

    public List<PropertyEdge<FunctionDeclaration>> getInvokesPropertyEdge() {
        return this.invokes;
    }

    public void setInvokes(List<FunctionDeclaration> invokes) {
        PropertyEdge.getTarget(this.invokes).forEach(i -> {
            i.unregisterTypeListener(this);
            Util.detachCallParameters(i, this.getArguments());
            this.removePrevDFG((Node)i);
        });
        this.invokes = PropertyEdge.transformIntoOutgoingPropertyEdgeList(invokes, this);
        invokes.forEach(i -> {
            i.registerTypeListener(this);
            Util.attachCallParameters(i, this.getArguments());
            this.addPrevDFG((Node)i);
        });
    }

    public List<Type> getSignature() {
        return this.getArguments().stream().map(Expression::getType).collect(Collectors.toList());
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        if (src == this.base) {
            this.setFqn(src.getType().getRoot().getTypeName() + "." + this.getName());
        } else {
            Type previous = this.type;
            List<Type> types = this.invokes.stream().map(pe -> (FunctionDeclaration)pe.getEnd()).map(ValueDeclaration::getType).filter(Objects::nonNull).collect(Collectors.toList());
            Type alternative = !types.isEmpty() ? (Type)types.get(0) : null;
            Type commonType = TypeManager.getInstance().getCommonType(types).orElse(alternative);
            HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
            subTypes.remove(oldType);
            subTypes.addAll(types);
            this.setType(commonType, root);
            this.setPossibleSubTypes(subTypes, root);
            if (!previous.equals(this.type)) {
                this.type.setTypeOrigin(Type.Origin.DATAFLOW);
            }
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        if (src != this.base) {
            HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
            subTypes.addAll(src.getPossibleSubTypes());
            this.setPossibleSubTypes(subTypes, root);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("base", this.base).toString();
    }

    public String getFqn() {
        return this.fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallExpression)) {
            return false;
        }
        CallExpression that = (CallExpression)o;
        return super.equals(that) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.getArguments(), that.getArguments()) && Objects.equals(this.invokes, that.invokes) && Objects.equals(this.getInvokes(), that.getInvokes()) && Objects.equals(this.base, that.base);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

