/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typesolvers;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class JavaParserTypeSolver
implements TypeSolver {
    private final Path srcDir;
    private final JavaParser javaParser;
    private TypeSolver parent;
    private final Cache<Path, Optional<CompilationUnit>> parsedFiles;
    private final Cache<Path, List<CompilationUnit>> parsedDirectories;
    private final Cache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> foundTypes;
    private static final int CACHE_SIZE_UNSET = -1;

    public JavaParserTypeSolver(File srcDir) {
        this(srcDir.toPath());
    }

    public JavaParserTypeSolver(String srcDir) {
        this(new File(srcDir));
    }

    public JavaParserTypeSolver(Path srcDir) {
        this(srcDir, new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.BLEEDING_EDGE));
    }

    public JavaParserTypeSolver(File srcDir, ParserConfiguration parserConfiguration) {
        this(srcDir.toPath(), parserConfiguration);
    }

    public JavaParserTypeSolver(String srcDir, ParserConfiguration parserConfiguration) {
        this(new File(srcDir), parserConfiguration);
    }

    public JavaParserTypeSolver(Path srcDir, ParserConfiguration parserConfiguration) {
        this(srcDir, parserConfiguration, -1L);
    }

    private <TKey, TValue> Cache<TKey, TValue> BuildCache(long cacheSizeLimit) {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().softValues();
        if (cacheSizeLimit != -1L) {
            cacheBuilder.maximumSize(cacheSizeLimit);
        }
        return cacheBuilder.build();
    }

    public JavaParserTypeSolver(Path srcDir, ParserConfiguration parserConfiguration, long cacheSizeLimit) {
        if (!Files.exists(srcDir, new LinkOption[0]) || !Files.isDirectory(srcDir, new LinkOption[0])) {
            throw new IllegalStateException("SrcDir does not exist or is not a directory: " + srcDir);
        }
        this.srcDir = srcDir;
        this.javaParser = new JavaParser(parserConfiguration);
        this.parsedFiles = this.BuildCache(cacheSizeLimit);
        this.parsedDirectories = this.BuildCache(cacheSizeLimit);
        this.foundTypes = this.BuildCache(cacheSizeLimit);
    }

    public String toString() {
        return "JavaParserTypeSolver{srcDir=" + this.srcDir + ", parent=" + this.parent + '}';
    }

    @Override
    public TypeSolver getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TypeSolver parent) {
        Objects.requireNonNull(parent);
        if (this.parent != null) {
            throw new IllegalStateException("This TypeSolver already has a parent.");
        }
        if (parent == this) {
            throw new IllegalStateException("The parent of this TypeSolver cannot be itself.");
        }
        this.parent = parent;
    }

    private Optional<CompilationUnit> parse(Path srcFile) {
        try {
            return this.parsedFiles.get(srcFile.toAbsolutePath(), () -> {
                try {
                    if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isRegularFile(srcFile, new LinkOption[0])) {
                        return Optional.empty();
                    }
                    return this.javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(srcFile)).getResult().map(cu -> cu.setStorage(srcFile));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Issue while parsing while type solving: " + srcFile.toAbsolutePath(), e);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private List<CompilationUnit> parseDirectory(Path srcDirectory) {
        return this.parseDirectory(srcDirectory, false);
    }

    private List<CompilationUnit> parseDirectoryRecursively(Path srcDirectory) {
        return this.parseDirectory(srcDirectory, true);
    }

    private List<CompilationUnit> parseDirectory(Path srcDirectory, boolean recursively) {
        try {
            return this.parsedDirectories.get(srcDirectory.toAbsolutePath(), () -> {
                ArrayList units = new ArrayList();
                if (Files.exists(srcDirectory, new LinkOption[0])) {
                    try (DirectoryStream<Path> srcDirectoryStream = Files.newDirectoryStream(srcDirectory);){
                        srcDirectoryStream.forEach(file -> {
                            if (file.getFileName().toString().toLowerCase().endsWith(".java")) {
                                this.parse((Path)file).ifPresent(units::add);
                            } else if (recursively && file.toFile().isDirectory()) {
                                units.addAll(this.parseDirectoryRecursively((Path)file));
                            }
                        });
                    }
                }
                return units;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        try {
            return this.foundTypes.get(name, () -> {
                SymbolReference<ResolvedReferenceTypeDeclaration> result = this.tryToSolveTypeUncached(name);
                if (result.isSolved()) {
                    return SymbolReference.solved(result.getCorrespondingDeclaration());
                }
                return result;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveTypeUncached(String name) {
        String[] nameElements = name.split("\\.");
        for (int i = nameElements.length; i > 0; --i) {
            Optional<TypeDeclaration<?>> astTypeDeclaration;
            StringBuilder filePath = new StringBuilder(this.srcDir.toAbsolutePath().toString());
            for (int j = 0; j < i; ++j) {
                filePath.append("/").append(nameElements[j]);
            }
            filePath.append(".java");
            StringBuilder typeName = new StringBuilder();
            for (int j = i - 1; j < nameElements.length; ++j) {
                if (j != i - 1) {
                    typeName.append(".");
                }
                typeName.append(nameElements[j]);
            }
            Path srcFile = Paths.get(filePath.toString(), new String[0]);
            Optional<CompilationUnit> compilationUnit = this.parse(srcFile);
            if (compilationUnit.isPresent() && (astTypeDeclaration = Navigator.findType(compilationUnit.get(), typeName.toString())).isPresent()) {
                return SymbolReference.solved(JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration.get()));
            }
            List<CompilationUnit> compilationUnits = this.parseDirectory(srcFile.getParent());
            for (CompilationUnit compilationUnit2 : compilationUnits) {
                Optional<TypeDeclaration<?>> astTypeDeclaration2 = Navigator.findType(compilationUnit2, typeName.toString());
                if (!astTypeDeclaration2.isPresent()) continue;
                return SymbolReference.solved(JavaParserFacade.get(this).getTypeDeclaration(astTypeDeclaration2.get()));
            }
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }
}

