/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.logic;

import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class FunctionalInterfaceLogic {
    private static List<String> OBJECT_METHODS_SIGNATURES = Arrays.stream(Object.class.getDeclaredMethods()).map(method -> FunctionalInterfaceLogic.getSignature(method)).collect(Collectors.toList());

    private FunctionalInterfaceLogic() {
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration();
        if (!optionalTypeDeclaration.isPresent()) {
            return Optional.empty();
        }
        ResolvedReferenceTypeDeclaration typeDeclaration = optionalTypeDeclaration.get();
        if (type.isReferenceType() && typeDeclaration.isInterface()) {
            return FunctionalInterfaceLogic.getFunctionalMethod(typeDeclaration);
        }
        return Optional.empty();
    }

    public static Optional<MethodUsage> getFunctionalMethod(ResolvedReferenceTypeDeclaration typeDeclaration) {
        Set methods = typeDeclaration.getAllMethods().stream().filter(m3 -> m3.getDeclaration().isAbstract()).filter(m3 -> !FunctionalInterfaceLogic.declaredOnObject(m3)).collect(Collectors.toSet());
        if (methods.size() == 1) {
            return Optional.of(methods.iterator().next());
        }
        return Optional.empty();
    }

    public static boolean isFunctionalInterfaceType(ResolvedType type) {
        Optional<ResolvedReferenceTypeDeclaration> optionalTypeDeclaration;
        if (type.isReferenceType() && (optionalTypeDeclaration = type.asReferenceType().getTypeDeclaration()).isPresent() && optionalTypeDeclaration.get().hasAnnotation(FunctionalInterface.class.getCanonicalName())) {
            return true;
        }
        return FunctionalInterfaceLogic.getFunctionalMethod(type).isPresent();
    }

    private static String getSignature(Method m3) {
        return String.format("%s(%s)", m3.getName(), String.join((CharSequence)", ", Arrays.stream(m3.getParameters()).map(p -> FunctionalInterfaceLogic.toSignature(p)).collect(Collectors.toList())));
    }

    private static String toSignature(Parameter p) {
        return p.getType().getCanonicalName();
    }

    private static boolean declaredOnObject(MethodUsage m3) {
        return OBJECT_METHODS_SIGNATURES.contains(m3.getDeclaration().getSignature());
    }
}

