/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.helpers.ControlFlowSensitiveDFG;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;

public class ControlFlowSensitiveDFGPass
extends Pass {
    @Override
    public void cleanup() {
    }

    @Override
    public void accept(TranslationResult translationResult) {
        SubgraphWalker.IterativeGraphWalker walker = new SubgraphWalker.IterativeGraphWalker();
        walker.registerOnNodeVisit(this::handle);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            walker.iterate(tu);
        }
    }

    private void removeValues(ControlFlowSensitiveDFG dfg) {
        for (Node currNode : dfg.getRemoves().keySet()) {
            for (Node prev : dfg.getRemoves().get(currNode)) {
                currNode.removePrevDFG(prev);
            }
        }
    }

    public void handle(Node node) {
        if (node instanceof FunctionDeclaration) {
            ControlFlowSensitiveDFG controlFlowSensitiveDFG = new ControlFlowSensitiveDFG(node);
            controlFlowSensitiveDFG.handle();
            this.removeValues(controlFlowSensitiveDFG);
        }
    }
}

