/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.declarations.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.IfStatement;
import de.fraunhofer.aisec.cpg.graph.statements.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.DeclaredReferenceExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ControlFlowSensitiveDFG {
    private Map<VariableDeclaration, Set<Node>> variables;
    private Set<Node> visited = new HashSet<Node>();
    private Set<Node> visitedEOG;
    private Map<Node, Set<Node>> removes;
    private Node startNode;
    private Node endNode;

    public ControlFlowSensitiveDFG(Node startNode, Node endNode, Map<VariableDeclaration, Set<Node>> variables, Set<Node> visitedEOG) {
        this.variables = ControlFlowSensitiveDFG.duplicateMap(variables);
        this.startNode = startNode;
        this.endNode = endNode;
        this.visitedEOG = new HashSet<Node>(visitedEOG);
        this.removes = new HashMap<Node, Set<Node>>();
    }

    public ControlFlowSensitiveDFG(Node startNode) {
        this.variables = new HashMap<VariableDeclaration, Set<Node>>();
        this.startNode = startNode;
        this.endNode = null;
        this.visitedEOG = new HashSet<Node>();
        this.removes = new HashMap<Node, Set<Node>>();
    }

    public Map<Node, Set<Node>> getRemoves() {
        return this.removes;
    }

    private void addToRemoves(Node curr, Node prev) {
        if (!this.removes.containsKey(curr)) {
            this.removes.put(curr, new HashSet());
        }
        this.removes.get(curr).add(prev);
    }

    public Map<VariableDeclaration, Set<Node>> getVariables() {
        return this.variables;
    }

    public Set<Node> getVisitedEOG() {
        return this.visitedEOG;
    }

    private boolean checkVisited(Node node) {
        return this.visited.contains(node);
    }

    private static Map<VariableDeclaration, Set<Node>> duplicateMap(Map<VariableDeclaration, Set<Node>> in) {
        HashMap<VariableDeclaration, Set<Node>> duplicatedVariables = new HashMap<VariableDeclaration, Set<Node>>();
        for (Map.Entry<VariableDeclaration, Set<Node>> e : in.entrySet()) {
            HashSet nodes = new HashSet(e.getValue());
            duplicatedVariables.put(e.getKey(), nodes);
        }
        return duplicatedVariables;
    }

    private void addVisitedToMap(VariableDeclaration variableDeclaration) {
        Set<Node> prevDFGSet = variableDeclaration.getPrevDFG();
        for (Node prev : prevDFGSet) {
            if (!this.checkVisited(prev)) continue;
            if (this.variables.containsKey(variableDeclaration)) {
                this.variables.get(variableDeclaration).add(prev);
                continue;
            }
            HashSet<Node> dfgSet = new HashSet<Node>();
            dfgSet.add(prev);
            this.variables.put(variableDeclaration, dfgSet);
        }
    }

    private void addUniqueDFGs() {
        for (Map.Entry<VariableDeclaration, Set<Node>> entry : this.variables.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            entry.getKey().addPrevDFG(entry.getValue().iterator().next());
        }
    }

    private Set<Node> eogTraversal(Node node) {
        HashSet<Node> eogReachableNodes = new HashSet<Node>();
        HashSet<Node> checkRechable = new HashSet<Node>();
        checkRechable.add(node);
        while (!checkRechable.isEmpty()) {
            Node n = (Node)checkRechable.iterator().next();
            checkRechable.addAll(n.getNextEOG());
            eogReachableNodes.add(n);
            checkRechable.removeAll(eogReachableNodes);
        }
        return eogReachableNodes;
    }

    /*
     * WARNING - void declaration
     */
    private Node obtainJoinPoint(Node node) {
        HashSet<Node> nextEOG = new HashSet<Node>(node.getNextEOG());
        ArrayList<Set<Node>> eogs = new ArrayList<Set<Node>>();
        for (Node node2 : nextEOG) {
            eogs.add(this.eogTraversal(node2));
        }
        HashSet intersection = new HashSet((Collection)eogs.get(0));
        for (Set set : eogs) {
            intersection.retainAll(set);
        }
        Object var5_7 = null;
        while (intersection.size() > 1) {
            Optional optional;
            void var5_8;
            if (var5_8 != null) {
                intersection.remove(var5_8);
            }
            if (!(optional = intersection.stream().findFirst()).isPresent()) continue;
            Node node3 = (Node)optional.get();
            Set<Node> eog = this.eogTraversal(node3);
            eog.remove(node3);
            intersection.removeAll(eog);
        }
        Optional optional = intersection.stream().findAny();
        return optional.orElse(null);
    }

    private Map<VariableDeclaration, Set<Node>> joinVariables(List<ControlFlowSensitiveDFG> dfgs) {
        HashMap<VariableDeclaration, Set<Node>> joindVariables = new HashMap<VariableDeclaration, Set<Node>>();
        for (ControlFlowSensitiveDFG dfg : dfgs) {
            for (VariableDeclaration variableDeclaration : dfg.getVariables().keySet()) {
                if (!joindVariables.containsKey(variableDeclaration)) {
                    HashSet values = new HashSet(dfg.getVariables().get(variableDeclaration));
                    joindVariables.put(variableDeclaration, values);
                    continue;
                }
                ((Set)joindVariables.get(variableDeclaration)).addAll((Collection)dfg.getVariables().get(variableDeclaration));
            }
        }
        return joindVariables;
    }

    private Map<Node, Set<Node>> joinRemoves(List<ControlFlowSensitiveDFG> dfgs) {
        HashMap<Node, Set<Node>> newRemoves = new HashMap<Node, Set<Node>>();
        for (ControlFlowSensitiveDFG dfg : dfgs) {
            for (Node n : dfg.getRemoves().keySet()) {
                if (!newRemoves.containsKey(n)) {
                    newRemoves.put(n, new HashSet());
                }
                ((Set)newRemoves.get(n)).addAll((Collection)dfg.getRemoves().get(n));
            }
        }
        return newRemoves;
    }

    private void setIngoingDFG(Node currNode) {
        HashSet<Node> prevDFGs = new HashSet<Node>(currNode.getPrevDFG());
        for (Node prev : prevDFGs) {
            if (!(prev instanceof VariableDeclaration) || !this.variables.containsKey(prev)) continue;
            for (Node target : this.variables.get(prev)) {
                currNode.addPrevDFG(target);
            }
            this.addToRemoves(currNode, prev);
        }
    }

    private void registerOutgoingDFG(Node currNode) {
        HashSet<Node> nextDFG = new HashSet<Node>(currNode.getNextDFG());
        for (Node next : nextDFG) {
            if (!(next instanceof VariableDeclaration) || !this.variables.containsKey(next)) continue;
            HashSet<Node> values = new HashSet<Node>(currNode.getPrevDFG());
            this.variables.replace((VariableDeclaration)next, values);
        }
    }

    private Node getNextEOG(Node currNode) {
        for (Node next : currNode.getNextEOG()) {
            if (this.visitedEOG.contains(next)) continue;
            return next;
        }
        return null;
    }

    private Node handleDFGSplit(Node currNode) {
        Node joinNode = this.obtainJoinPoint(currNode);
        List<Node> eogList = currNode.getNextEOG();
        ArrayList<ControlFlowSensitiveDFG> dfgs = new ArrayList<ControlFlowSensitiveDFG>();
        for (Node n : eogList) {
            ControlFlowSensitiveDFG dfg = new ControlFlowSensitiveDFG(n, joinNode, this.variables, this.visitedEOG);
            dfgs.add(dfg);
            dfg.handle();
        }
        this.variables = this.joinVariables(dfgs);
        this.mergeRemoves(this.joinRemoves(dfgs));
        for (ControlFlowSensitiveDFG dfg : dfgs) {
            this.visitedEOG.addAll(dfg.getVisitedEOG());
        }
        return joinNode;
    }

    private Node obtainAssignmentNode(Node node) {
        HashSet<Node> nextEOG = new HashSet<Node>(node.getNextEOG());
        HashSet<Node> rechableEOGs = new HashSet<Node>();
        for (Node next : nextEOG) {
            rechableEOGs.addAll(this.eogTraversal(next));
        }
        return rechableEOGs.stream().filter(n -> n instanceof BinaryOperator && ((BinaryOperator)n).getLhs().equals(node)).findAny().orElse(null);
    }

    private void modifyDFGEdges(Node currNode) {
        this.registerOutgoingDFG(currNode);
        this.setIngoingDFG(currNode);
    }

    private void mergeRemoves(Map<Node, Set<Node>> newRemoves) {
        for (Map.Entry<Node, Set<Node>> entry : newRemoves.entrySet()) {
            if (this.removes.containsKey(entry.getKey())) {
                this.removes.get(entry.getKey()).addAll((Collection<Node>)entry.getValue());
                continue;
            }
            this.removes.put(entry.getKey(), entry.getValue());
        }
    }

    private Node handleDeclaredReferenceExpression(DeclaredReferenceExpression currNode) {
        if (currNode.getAccess().equals((Object)AccessValues.WRITE)) {
            Node binaryOperator = this.obtainAssignmentNode(currNode);
            Node nextEOG = currNode.getNextEOG().get(0);
            ArrayList<ControlFlowSensitiveDFG> dfgs = new ArrayList<ControlFlowSensitiveDFG>();
            ControlFlowSensitiveDFG dfg = new ControlFlowSensitiveDFG(nextEOG, binaryOperator, this.variables, this.visitedEOG);
            dfgs.add(dfg);
            dfg.handle();
            this.variables = this.joinVariables(dfgs);
            this.mergeRemoves(this.joinRemoves(dfgs));
            this.visitedEOG.addAll(dfg.getVisitedEOG());
            this.modifyDFGEdges(currNode);
            return binaryOperator;
        }
        this.modifyDFGEdges(currNode);
        return this.getNextEOG(currNode);
    }

    public void handle() {
        Node currNode = this.startNode;
        while (!this.visitedEOG.contains(currNode) && currNode != null && !currNode.equals(this.endNode)) {
            Node nextNode = null;
            this.visited.add(currNode);
            this.visitedEOG.add(currNode);
            List<Node> nextEOG = currNode.getNextEOG();
            if (nextEOG.isEmpty()) break;
            if (currNode instanceof VariableDeclaration) {
                this.addVisitedToMap((VariableDeclaration)currNode);
            } else if (currNode instanceof IfStatement || currNode instanceof SwitchStatement) {
                nextNode = this.handleDFGSplit(currNode);
            } else if (currNode instanceof DeclaredReferenceExpression) {
                nextNode = this.handleDeclaredReferenceExpression((DeclaredReferenceExpression)currNode);
            }
            if (nextNode == null) {
                nextNode = this.getNextEOG(currNode);
            }
            currNode = nextNode;
        }
        if (this.startNode instanceof FunctionDeclaration) {
            this.addUniqueDFGs();
        }
    }
}

