/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.declarations;

import de.fraunhofer.aisec.cpg.graph.DeclarationHolder;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.declarations.Declaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.declarations.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.statements.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.statements.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.statements.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.statements.Statement;
import de.fraunhofer.aisec.cpg.graph.types.Type;
import de.fraunhofer.aisec.cpg.graph.types.UnknownType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class FunctionDeclaration
extends ValueDeclaration
implements DeclarationHolder {
    private static final String WHITESPACE = " ";
    private static final String BRACKET_LEFT = "(";
    private static final String COMMA = ",";
    private static final String BRACKET_RIGHT = ")";
    @SubGraph(value={"AST"})
    protected Statement body;
    protected List<RecordDeclaration> records = new ArrayList<RecordDeclaration>();
    @SubGraph(value={"AST"})
    protected List<ParamVariableDeclaration> parameters = new ArrayList<ParamVariableDeclaration>();
    protected List<Type> throwsTypes = new ArrayList<Type>();
    @Relationship(value="OVERRIDES", direction="INCOMING")
    private List<FunctionDeclaration> overriddenBy = new ArrayList<FunctionDeclaration>();
    @Relationship(value="OVERRIDES", direction="OUTGOING")
    private List<FunctionDeclaration> overrides = new ArrayList<FunctionDeclaration>();
    private boolean isDefinition;
    @Relationship(value="DEFINES")
    private FunctionDeclaration definition;

    public boolean hasBody() {
        return this.body != null;
    }

    public String getSignature() {
        return this.name + BRACKET_LEFT + this.parameters.stream().map(x -> x.getType().getTypeName()).collect(Collectors.joining(", ")) + BRACKET_RIGHT + ((Type)Objects.requireNonNullElse(this.type, UnknownType.getUnknownType())).getTypeName();
    }

    public boolean hasSignature(List<Type> targetSignature) {
        List signature = this.parameters.stream().sorted(Comparator.comparingInt(Node::getArgumentIndex)).collect(Collectors.toList());
        if (targetSignature.size() < signature.size()) {
            return false;
        }
        for (int i = 0; i < signature.size(); ++i) {
            ParamVariableDeclaration declared = (ParamVariableDeclaration)signature.get(i);
            if (declared.isVariadic() && targetSignature.size() >= signature.size()) {
                return true;
            }
            Type provided = targetSignature.get(i);
            if (TypeManager.getInstance().isSupertypeOf(declared.getType(), provided)) continue;
            return false;
        }
        return targetSignature.size() == signature.size();
    }

    public boolean isOverrideCandidate(FunctionDeclaration other) {
        return other.getName().equals(this.name) && other.getType().equals(this.type) && other.getSignature().equals(this.getSignature());
    }

    public List<FunctionDeclaration> getOverriddenBy() {
        return this.overriddenBy;
    }

    public List<FunctionDeclaration> getOverrides() {
        return this.overrides;
    }

    public List<Type> getThrowsTypes() {
        return this.throwsTypes;
    }

    public void setThrowsTypes(List<Type> throwsTypes) {
        this.throwsTypes = throwsTypes;
    }

    public Statement getBody() {
        return this.body;
    }

    public <T> @Nullable T getBodyStatementAs(int i, Class<T> clazz) {
        if (this.body instanceof CompoundStatement) {
            Statement statement = ((CompoundStatement)this.body).getStatements().get(i);
            if (statement == null) {
                return null;
            }
            return statement.getClass().isAssignableFrom(clazz) ? (T)clazz.cast(statement) : null;
        }
        return null;
    }

    public void setBody(Statement body) {
        if (this.body instanceof ReturnStatement) {
            this.removePrevDFG(this.body);
        } else if (this.body instanceof CompoundStatement) {
            ((CompoundStatement)this.body).getStatements().stream().filter(ReturnStatement.class::isInstance).forEach(this::removePrevDFG);
        }
        this.body = body;
        if (body instanceof ReturnStatement) {
            this.addPrevDFG(body);
        } else if (body instanceof CompoundStatement) {
            ((CompoundStatement)body).getStatements().stream().filter(ReturnStatement.class::isInstance).forEach(this::addPrevDFG);
        }
    }

    public List<ParamVariableDeclaration> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParamVariableDeclaration> parameters) {
        this.parameters = parameters;
    }

    public Optional<VariableDeclaration> getVariableDeclarationByName(String name) {
        if (this.body instanceof CompoundStatement) {
            return ((CompoundStatement)this.body).getStatements().stream().filter(statement -> statement instanceof DeclarationStatement).map(DeclarationStatement.class::cast).flatMap(declarationStatement -> declarationStatement.getDeclarations().stream()).filter(declaration -> declaration instanceof VariableDeclaration).map(VariableDeclaration.class::cast).filter(declaration -> Objects.equals(declaration.getName(), name)).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", (Object)this.type).append("parameters", (Object)this.parameters.stream().map(Node::getName).collect(Collectors.joining(", "))).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionDeclaration)) {
            return false;
        }
        FunctionDeclaration that = (FunctionDeclaration)o;
        return super.equals(that) && Objects.equals(this.body, that.body) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.throwsTypes, that.throwsTypes) && Objects.equals(this.overriddenBy, that.overriddenBy) && Objects.equals(this.overrides, that.overrides);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public FunctionDeclaration getDefinition() {
        return this.isDefinition ? this : this.definition;
    }

    public boolean isDefinition() {
        return this.isDefinition;
    }

    public void setIsDefinition(boolean definition) {
        this.isDefinition = definition;
    }

    public void setDefinition(FunctionDeclaration definition) {
        this.definition = definition;
    }

    public List<RecordDeclaration> getRecords() {
        return this.records;
    }

    public void setRecords(List<RecordDeclaration> records) {
        this.records = records;
    }

    @Override
    public void addDeclaration(@NonNull Declaration declaration) {
        if (declaration instanceof ParamVariableDeclaration) {
            this.addIfNotContains(this.parameters, (ParamVariableDeclaration)declaration);
        }
        if (declaration instanceof RecordDeclaration) {
            this.addIfNotContains(this.records, (RecordDeclaration)declaration);
        }
    }
}

