/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.statements.expressions.Expression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTEqualsInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTInitializerList;

public class InitializerHandler
extends Handler<Expression, IASTInitializer, CXXLanguageFrontend> {
    public InitializerHandler(CXXLanguageFrontend lang) {
        super(Expression::new, lang);
        this.map.put(CPPASTConstructorInitializer.class, ctx -> this.handleConstructorInitializer((CPPASTConstructorInitializer)ctx));
        this.map.put(CPPASTEqualsInitializer.class, ctx -> this.handleEqualsInitializer((CPPASTEqualsInitializer)ctx));
        this.map.put(CPPASTInitializerList.class, ctx -> (Expression)lang.getExpressionHandler().handle((CPPASTInitializerList)ctx));
    }

    private Expression handleConstructorInitializer(CPPASTConstructorInitializer ctx) {
        ConstructExpression constructExpression = NodeBuilder.newConstructExpression(ctx.getRawSignature());
        int i = 0;
        for (IASTInitializerClause argument : ctx.getArguments()) {
            Expression arg = (Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(argument);
            arg.setArgumentIndex(i);
            constructExpression.getArguments().add(arg);
            ++i;
        }
        return constructExpression;
    }

    private Expression handleEqualsInitializer(CPPASTEqualsInitializer ctx) {
        return (Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getInitializerClause());
    }
}

