/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class NumberStringConverter
implements AttributeConverter<Number, String> {
    private final Class<? extends Number> numberClass;
    private final boolean lenient;

    public NumberStringConverter(Class<? extends Number> numberClass) {
        this.numberClass = numberClass;
        this.lenient = false;
    }

    public NumberStringConverter(Class<? extends Number> numberClass, boolean lenient) {
        this.numberClass = numberClass;
        this.lenient = lenient;
    }

    @Override
    public String toGraphProperty(Number value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Number toEntityAttribute(String value) {
        if (value == null || this.lenient && StringUtils.isBlank(value)) {
            return null;
        }
        try {
            return this.numberClass.getDeclaredConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Conversion failed!", e);
        }
    }
}

