/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.exception.core.BaseClassNotFoundException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.session.EntityInstantiator;

public class EntityFactory {
    private final Map<String, String> taxaLeafClass = new HashMap<String, String>();
    private final MetaData metadata;
    private EntityInstantiator entityInstantiator;

    public EntityFactory(MetaData metadata) {
        this.metadata = metadata;
        this.entityInstantiator = new ReflectionEntityInstantiator(metadata);
    }

    public EntityFactory(MetaData metadata, EntityInstantiator entityInstantiator) {
        this.metadata = metadata;
        this.entityInstantiator = entityInstantiator;
    }

    public <T> T newObject(Node nodeModel) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Property<String, Object> property : nodeModel.getPropertyList()) {
            map.put(property.getKey(), property.getValue());
        }
        return this.instantiateObjectFromTaxa(nodeModel.getLabels(), map);
    }

    public <T> T newObject(Class<T> clarse, Map<String, Object> map) {
        return this.instantiate(clarse, map);
    }

    private <T> T instantiateObjectFromTaxa(String[] taxa, Map<String, Object> propertyValues) {
        if (taxa == null || taxa.length == 0) {
            throw new BaseClassNotFoundException("<null>");
        }
        String fqn = this.resolve(taxa);
        Class<?> loadedClass = this.metadata.classInfo(fqn).getUnderlyingClass();
        return (T)this.instantiate(loadedClass, propertyValues);
    }

    private String resolve(String ... taxa) {
        String fqn = this.taxaLeafClass.get(Arrays.toString(taxa));
        if (fqn == null) {
            ClassInfo classInfo = this.metadata.resolve(taxa);
            if (classInfo != null) {
                fqn = classInfo.name();
                this.taxaLeafClass.put(Arrays.toString(taxa), fqn);
            } else {
                throw new BaseClassNotFoundException(Arrays.toString(taxa));
            }
        }
        return fqn;
    }

    private <T> T instantiate(Class<T> loadedClass, Map<String, Object> propertyValues) {
        return this.entityInstantiator.createInstance(loadedClass, propertyValues);
    }
}

