/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.config;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.config.Credentials;
import org.neo4j.ogm.config.Drivers;
import org.neo4j.ogm.config.UsernamePasswordCredentials;
import org.neo4j.ogm.support.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private String uri;
    private String[] uris;
    private int connectionPoolSize;
    private String encryptionLevel;
    private String trustStrategy;
    private String trustCertFile;
    private AutoIndexMode autoIndex;
    private String generatedIndexesOutputDir;
    private String generatedIndexesOutputFilename;
    private String neo4jConfLocation;
    @Deprecated
    private String neo4jHaPropertiesFile;
    private String driverName;
    private Credentials credentials;
    private Integer connectionLivenessCheckTimeout;
    private Boolean verifyConnection;
    private Map<String, Object> customProperties;

    Configuration(Builder builder) {
        this.uri = builder.uri;
        this.uris = builder.uris;
        this.connectionPoolSize = builder.connectionPoolSize != null ? builder.connectionPoolSize : 50;
        this.encryptionLevel = builder.encryptionLevel;
        this.trustStrategy = builder.trustStrategy;
        this.trustCertFile = builder.trustCertFile;
        this.connectionLivenessCheckTimeout = builder.connectionLivenessCheckTimeout;
        this.verifyConnection = builder.verifyConnection != null ? builder.verifyConnection : false;
        this.autoIndex = builder.autoIndex != null ? AutoIndexMode.fromString(builder.autoIndex) : AutoIndexMode.NONE;
        this.generatedIndexesOutputDir = builder.generatedIndexesOutputDir != null ? builder.generatedIndexesOutputDir : ".";
        this.generatedIndexesOutputFilename = builder.generatedIndexesOutputFilename != null ? builder.generatedIndexesOutputFilename : "generated_indexes.cql";
        this.neo4jConfLocation = builder.neo4jConfLocation;
        this.neo4jHaPropertiesFile = builder.neo4jHaPropertiesFile;
        this.customProperties = builder.customProperties;
        if (this.uri != null) {
            URI uri = null;
            try {
                uri = new URI(this.uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not configure supplied URI in Configuration", e);
            }
            String userInfo = uri.getUserInfo();
            if (userInfo != null) {
                String[] userPass = userInfo.split(":");
                this.credentials = new UsernamePasswordCredentials(userPass[0], userPass[1]);
                this.uri = uri.toString().replace(uri.getUserInfo() + "@", "");
            }
            if (this.getDriverClassName() == null) {
                this.driverName = Drivers.getDriverFor(uri.getScheme()).driverClassName();
            }
        } else {
            this.driverName = Drivers.EMBEDDED.driverClassName();
        }
        if (builder.username != null && builder.password != null) {
            if (this.credentials != null) {
                LOGGER.warn("Overriding credentials supplied in URI with supplied username and password.");
            }
            this.credentials = new UsernamePasswordCredentials(builder.username, builder.password);
        }
    }

    public AutoIndexMode getAutoIndex() {
        return this.autoIndex;
    }

    public String getDumpDir() {
        return this.generatedIndexesOutputDir;
    }

    public String getDumpFilename() {
        return this.generatedIndexesOutputFilename;
    }

    public String getURI() {
        return this.uri;
    }

    public String[] getURIS() {
        return this.uris;
    }

    public String getDriverClassName() {
        return this.driverName;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public String getEncryptionLevel() {
        return this.encryptionLevel;
    }

    public String getTrustStrategy() {
        return this.trustStrategy;
    }

    public String getTrustCertFile() {
        return this.trustCertFile;
    }

    public Integer getConnectionLivenessCheckTimeout() {
        return this.connectionLivenessCheckTimeout;
    }

    public Boolean getVerifyConnection() {
        return this.verifyConnection;
    }

    public String getNeo4jConfLocation() {
        return Optional.ofNullable(this.neo4jHaPropertiesFile).orElseGet(() -> this.neo4jConfLocation);
    }

    public boolean isEmbeddedHA() {
        boolean isEmbeddedHA;
        boolean bl = isEmbeddedHA = this.neo4jHaPropertiesFile != null;
        if (!isEmbeddedHA && this.neo4jConfLocation != null) {
            try {
                URL url = ResourceUtils.getResourceUrl(this.neo4jConfLocation);
                Properties neo4Properties = new Properties();
                neo4Properties.load(url.openStream());
                isEmbeddedHA = "HA".equalsIgnoreCase(neo4Properties.getProperty("dbms.mode", "-"));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not load neo4j.conf at location " + this.neo4jConfLocation, e);
            }
        }
        return isEmbeddedHA;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Map<String, Object> getCustomProperties() {
        return Collections.unmodifiableMap(this.customProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.connectionPoolSize == that.connectionPoolSize && Objects.equals(this.uri, that.uri) && Arrays.equals(this.uris, that.uris) && Objects.equals(this.encryptionLevel, that.encryptionLevel) && Objects.equals(this.trustStrategy, that.trustStrategy) && Objects.equals(this.trustCertFile, that.trustCertFile) && this.autoIndex == that.autoIndex && Objects.equals(this.generatedIndexesOutputDir, that.generatedIndexesOutputDir) && Objects.equals(this.generatedIndexesOutputFilename, that.generatedIndexesOutputFilename) && Objects.equals(this.neo4jConfLocation, that.neo4jConfLocation) && Objects.equals(this.neo4jHaPropertiesFile, that.neo4jHaPropertiesFile) && Objects.equals(this.driverName, that.driverName) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.connectionLivenessCheckTimeout, that.connectionLivenessCheckTimeout) && Objects.equals(this.verifyConnection, that.verifyConnection);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.uri, this.connectionPoolSize, this.encryptionLevel, this.trustStrategy, this.trustCertFile, this.autoIndex, this.generatedIndexesOutputDir, this.generatedIndexesOutputFilename, this.neo4jConfLocation, this.neo4jHaPropertiesFile, this.driverName, this.credentials, this.connectionLivenessCheckTimeout, this.verifyConnection});
        result = 31 * result + Arrays.hashCode(this.uris);
        return result;
    }

    public static class Builder {
        private static final String URI = "URI";
        private static final String URIS = "URIS";
        private static final String USERNAME = "username";
        private static final String PASSWORD = "password";
        private static final String CONNECTION_POOL_SIZE = "connection.pool.size";
        private static final String ENCRYPTION_LEVEL = "encryption.level";
        private static final String TRUST_STRATEGY = "trust.strategy";
        private static final String TRUST_CERT_FILE = "trust.certificate.file";
        private static final String CONNECTION_LIVENESS_CHECK_TIMEOUT = "connection.liveness.check.timeout";
        private static final String VERIFY_CONNECTION = "verify.connection";
        private static final String AUTO_INDEX = "indexes.auto";
        private static final String GENERATED_INDEXES_OUTPUT_DIR = "indexes.auto.dump.dir";
        private static final String GENERATED_INDEXES_OUTPUT_FILENAME = "indexes.auto.dump.filename";
        private static final String NEO4J_CONF_LOCATION = "neo4j.conf.location";
        private static final String NEO4J_HA_PROPERTIES_FILE = "neo4j.ha.properties.file";
        private String uri;
        private String[] uris;
        private Integer connectionPoolSize;
        private String encryptionLevel;
        private String trustStrategy;
        private String trustCertFile;
        private Integer connectionLivenessCheckTimeout;
        private Boolean verifyConnection;
        private String autoIndex;
        private String generatedIndexesOutputDir;
        private String generatedIndexesOutputFilename;
        private String neo4jConfLocation;
        @Deprecated
        private String neo4jHaPropertiesFile;
        private String username;
        private String password;
        private Map<String, Object> customProperties = new HashMap<String, Object>();

        public static Builder copy(Builder builder) {
            return new Builder().uri(builder.uri).connectionPoolSize(builder.connectionPoolSize).encryptionLevel(builder.encryptionLevel).trustStrategy(builder.trustStrategy).trustCertFile(builder.trustCertFile).connectionLivenessCheckTimeout(builder.connectionLivenessCheckTimeout).verifyConnection(builder.verifyConnection).autoIndex(builder.autoIndex).generatedIndexesOutputDir(builder.generatedIndexesOutputDir).generatedIndexesOutputFilename(builder.generatedIndexesOutputFilename).neo4jConfLocation(builder.neo4jConfLocation).neo4jHaPropertiesFile(builder.neo4jHaPropertiesFile).credentials(builder.username, builder.password).customProperties(new HashMap<String, Object>(builder.customProperties));
        }

        public Builder() {
        }

        public Builder(ConfigurationSource configurationSource) {
            block34: for (Map.Entry<Object, Object> entry : configurationSource.properties().entrySet()) {
                switch (entry.getKey().toString()) {
                    case "URI": {
                        this.uri = (String)entry.getValue();
                        continue block34;
                    }
                    case "username": {
                        this.username = (String)entry.getValue();
                        continue block34;
                    }
                    case "password": {
                        this.password = (String)entry.getValue();
                        continue block34;
                    }
                    case "URIS": {
                        this.uris = ((String)entry.getValue()).split(",");
                        continue block34;
                    }
                    case "connection.pool.size": {
                        this.connectionPoolSize = Integer.parseInt((String)entry.getValue());
                        continue block34;
                    }
                    case "encryption.level": {
                        this.encryptionLevel = (String)entry.getValue();
                        continue block34;
                    }
                    case "trust.strategy": {
                        this.trustStrategy = (String)entry.getValue();
                        continue block34;
                    }
                    case "trust.certificate.file": {
                        this.trustCertFile = (String)entry.getValue();
                        continue block34;
                    }
                    case "connection.liveness.check.timeout": {
                        this.connectionLivenessCheckTimeout = Integer.valueOf((String)entry.getValue());
                        continue block34;
                    }
                    case "verify.connection": {
                        this.verifyConnection = Boolean.valueOf((String)entry.getValue());
                        continue block34;
                    }
                    case "indexes.auto": {
                        this.autoIndex = (String)entry.getValue();
                        continue block34;
                    }
                    case "indexes.auto.dump.dir": {
                        this.generatedIndexesOutputDir = (String)entry.getValue();
                        continue block34;
                    }
                    case "indexes.auto.dump.filename": {
                        this.generatedIndexesOutputFilename = (String)entry.getValue();
                        continue block34;
                    }
                    case "neo4j.ha.properties.file": {
                        this.neo4jHaPropertiesFile = (String)entry.getValue();
                        continue block34;
                    }
                    case "neo4j.conf.location": {
                        this.neo4jConfLocation = (String)entry.getValue();
                        continue block34;
                    }
                }
                LOGGER.warn("Could not process property with key: {}", entry.getKey());
            }
        }

        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder uris(String[] uris) {
            this.uris = uris;
            return this;
        }

        public Builder connectionPoolSize(Integer connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            return this;
        }

        public Builder encryptionLevel(String encryptionLevel) {
            this.encryptionLevel = encryptionLevel;
            return this;
        }

        public Builder trustStrategy(String trustStrategy) {
            this.trustStrategy = trustStrategy;
            return this;
        }

        public Builder trustCertFile(String trustCertFile) {
            this.trustCertFile = trustCertFile;
            return this;
        }

        public Builder connectionLivenessCheckTimeout(Integer connectionLivenessCheckTimeout) {
            this.connectionLivenessCheckTimeout = connectionLivenessCheckTimeout;
            return this;
        }

        public Builder verifyConnection(Boolean verifyConnection) {
            this.verifyConnection = verifyConnection;
            return this;
        }

        public Builder autoIndex(String autoIndex) {
            this.autoIndex = autoIndex;
            return this;
        }

        public Builder generatedIndexesOutputDir(String generatedIndexesOutputDir) {
            this.generatedIndexesOutputDir = generatedIndexesOutputDir;
            return this;
        }

        public Builder generatedIndexesOutputFilename(String generatedIndexesOutputFilename) {
            this.generatedIndexesOutputFilename = generatedIndexesOutputFilename;
            return this;
        }

        @Deprecated
        public Builder neo4jHaPropertiesFile(String neo4jHaPropertiesFile) {
            this.neo4jHaPropertiesFile = neo4jHaPropertiesFile;
            return this;
        }

        public Builder neo4jConfLocation(String neo4jConfLocation) {
            this.neo4jConfLocation = neo4jConfLocation;
            return this;
        }

        private Builder customProperties(Map<String, Object> customProperties) {
            this.customProperties = customProperties;
            return this;
        }

        public Builder withCustomProperty(String name, Object value) {
            this.customProperties.put(name, value);
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }

        public Builder credentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }
    }
}

