/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.cdt.internal.core.util.LRUCache;
import org.eclipse.cdt.internal.core.util.LRUCacheEnumerator;

public abstract class OverflowingLRUCache<K, T>
extends LRUCache<K, T> {
    protected int fOverflow = 0;
    protected boolean fTimestampsOn = true;
    protected double fLoadFactor = 0.333;

    public OverflowingLRUCache() {
    }

    public OverflowingLRUCache(int size) {
        this(size, 0);
    }

    public OverflowingLRUCache(int size, int overflow) {
        super(size);
        this.fOverflow = overflow;
    }

    @Override
    public Object clone() {
        OverflowingLRUCache newCache = this.newInstance(this.fSpaceLimit, this.fOverflow);
        LRUCache.LRUCacheEntry qEntry = this.fEntryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry._fKey, qEntry._fValue, qEntry._fSpace);
            qEntry = qEntry._fPrevious;
        }
        return newCache;
    }

    protected abstract boolean close(LRUCache.LRUCacheEntry<K, T> var1);

    public Enumeration<T> elements() {
        if (this.fEntryQueue == null) {
            return new LRUCacheEnumerator(null);
        }
        LRUCacheEnumerator.LRUEnumeratorElement head = new LRUCacheEnumerator.LRUEnumeratorElement(this.fEntryQueue._fValue);
        LRUCache.LRUCacheEntry currentEntry = this.fEntryQueue._fNext;
        LRUCacheEnumerator.LRUEnumeratorElement currentElement = head;
        while (currentEntry != null) {
            currentElement.fNext = new LRUCacheEnumerator.LRUEnumeratorElement(currentEntry._fValue);
            currentElement = currentElement.fNext;
            currentEntry = currentEntry._fNext;
        }
        return new LRUCacheEnumerator(head);
    }

    public double fillingRatio() {
        return (double)(this.fCurrentSpace + this.fOverflow) * 100.0 / (double)this.fSpaceLimit;
    }

    public Hashtable<K, LRUCache.LRUCacheEntry<K, T>> getEntryTable() {
        return this.fEntryTable;
    }

    public double getLoadFactor() {
        return this.fLoadFactor;
    }

    public int getOverflow() {
        return this.fOverflow;
    }

    @Override
    protected boolean makeSpace(int space) {
        int limit = this.fSpaceLimit;
        if (this.fOverflow == 0 && this.fCurrentSpace + space <= limit) {
            return true;
        }
        int spaceNeeded = (int)((1.0 - this.fLoadFactor) * (double)this.fSpaceLimit);
        spaceNeeded = spaceNeeded > space ? spaceNeeded : space;
        LRUCache.LRUCacheEntry entry = this.fEntryQueueTail;
        while (this.fCurrentSpace + spaceNeeded > limit && entry != null) {
            this.privateRemoveEntry(entry, false, false);
            entry = entry._fPrevious;
        }
        if (this.fCurrentSpace + space <= limit) {
            this.fOverflow = 0;
            return true;
        }
        this.fOverflow = this.fCurrentSpace + space - limit;
        return false;
    }

    protected abstract OverflowingLRUCache<K, T> newInstance(int var1, int var2);

    public T peek(K key) {
        LRUCache.LRUCacheEntry entry = (LRUCache.LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return null;
        }
        return entry._fValue;
    }

    public void printStats() {
        int forwardListLength = 0;
        LRUCache.LRUCacheEntry entry = this.fEntryQueue;
        while (entry != null) {
            ++forwardListLength;
            entry = entry._fNext;
        }
        System.out.println("Forward length: " + forwardListLength);
        int backwardListLength = 0;
        entry = this.fEntryQueueTail;
        while (entry != null) {
            ++backwardListLength;
            entry = entry._fPrevious;
        }
        System.out.println("Backward length: " + backwardListLength);
        Enumeration keys = this.fEntryTable.keys();
        class Temp {
            public Class<?> fClass;
            public int fCount;

            public Temp(Class<?> aClass) {
                this.fClass = aClass;
                this.fCount = 1;
            }

            public String toString() {
                return "Class: " + this.fClass + " has " + this.fCount + " entries.";
            }
        }
        HashMap h2 = new HashMap();
        while (keys.hasMoreElements()) {
            entry = (LRUCache.LRUCacheEntry)this.fEntryTable.get(keys.nextElement());
            Class<?> key = entry._fValue.getClass();
            Temp t = (Temp)h2.get(key);
            if (t == null) {
                h2.put(key, new Temp(key));
                continue;
            }
            ++t.fCount;
        }
        for (Object element : h2.keySet()) {
            System.out.println(h2.get(element));
        }
    }

    @Override
    protected void privateRemoveEntry(LRUCache.LRUCacheEntry<K, T> entry, boolean shuffle) {
        this.privateRemoveEntry(entry, shuffle, true);
    }

    protected void privateRemoveEntry(LRUCache.LRUCacheEntry<K, T> entry, boolean shuffle, boolean external) {
        if (!shuffle) {
            if (external) {
                this.fEntryTable.remove(entry._fKey);
                this.fCurrentSpace -= entry._fSpace;
                this.privateNotifyDeletionFromCache(entry);
            } else {
                if (!this.close(entry)) {
                    return;
                }
                if (this.fEntryTable.get(entry._fKey) == null) {
                    return;
                }
                this.fEntryTable.remove(entry._fKey);
                this.fCurrentSpace -= entry._fSpace;
                this.privateNotifyDeletionFromCache(entry);
            }
        }
        LRUCache.LRUCacheEntry previous = entry._fPrevious;
        LRUCache.LRUCacheEntry next = entry._fNext;
        if (previous == null) {
            this.fEntryQueue = next;
        } else {
            previous._fNext = next;
        }
        if (next == null) {
            this.fEntryQueueTail = previous;
        } else {
            next._fPrevious = previous;
        }
    }

    @Override
    public T put(K key, T value) {
        if (this.fOverflow > 0) {
            this.shrink();
        }
        int newSpace = this.spaceFor(key, value);
        LRUCache.LRUCacheEntry entry = (LRUCache.LRUCacheEntry)this.fEntryTable.get(key);
        if (entry != null) {
            int oldSpace = entry._fSpace;
            int newTotal = this.fCurrentSpace - oldSpace + newSpace;
            if (newTotal <= this.fSpaceLimit) {
                this.updateTimestamp(entry);
                entry._fValue = value;
                entry._fSpace = newSpace;
                this.fCurrentSpace = newTotal;
                this.fOverflow = 0;
                return value;
            }
            this.privateRemoveEntry(entry, false, false);
        }
        this.makeSpace(newSpace);
        this.privateAdd(key, value, newSpace);
        return value;
    }

    public Object remove(K key) {
        return this.removeKey(key);
    }

    public void setLoadFactor(double newLoadFactor) throws IllegalArgumentException {
        if (!(newLoadFactor <= 1.0) || !(newLoadFactor > 0.0)) {
            throw new IllegalArgumentException("cache.invalidLoadFactor");
        }
        this.fLoadFactor = newLoadFactor;
    }

    @Override
    public void setSpaceLimit(int limit) {
        if (limit < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - limit);
        }
        this.fSpaceLimit = limit;
    }

    public boolean shrink() {
        if (this.fOverflow > 0) {
            return this.makeSpace(0);
        }
        return true;
    }

    @Override
    public String toString() {
        return "OverflowingLRUCache " + this.fillingRatio() + "% full\n" + this.toStringContents();
    }

    @Override
    protected void updateTimestamp(LRUCache.LRUCacheEntry<K, T> entry) {
        if (this.fTimestampsOn) {
            entry._fTimestamp = this.fTimestampCounter++;
            if (this.fEntryQueue != entry) {
                this.privateRemoveEntry(entry, true);
                this.privateAddEntry(entry, true);
            }
        }
    }
}

