/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFileData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFolderData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultLanguageData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.EntryStore;
import org.eclipse.cdt.core.settings.model.util.PathEntryResolveInfo;
import org.eclipse.cdt.core.settings.model.util.PathEntryTranslator;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PathEntryConfigurationDataProvider
extends CConfigurationDataProvider {
    private static PathEntryDataFactory fFactory;

    public static CDataFactory getDataFactory() {
        if (fFactory == null) {
            fFactory = new PathEntryDataFactory();
        }
        return fFactory;
    }

    public PathEntryConfigurationDataProvider() {
        PathEntryConfigurationDataProvider.getDataFactory();
    }

    public static boolean isPathEntryData(CConfigurationData data) {
        return data instanceof CfgData;
    }

    @Override
    public CConfigurationData applyConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData baseData, IProgressMonitor monitor) throws CoreException {
        if (!fFactory.isModified(baseData)) {
            return this.createData(cfgDescription, baseData, false, true);
        }
        IProject project = cfgDescription.getProjectDescription().getProject();
        IPathEntry[] entries = PathEntryTranslator.getPathEntries(project, baseCfgDescription, 2);
        CModelManager manager = CModelManager.getDefault();
        ICProject cproject = manager.create(project);
        IPathEntry[] curRawEntries = PathEntryManager.getDefault().getRawPathEntries(cproject);
        ArrayList<IPathEntry> list = new ArrayList<IPathEntry>();
        list.addAll(Arrays.asList(entries));
        int i = 0;
        while (i < curRawEntries.length) {
            if (curRawEntries[i].getEntryKind() == 32) {
                list.add(curRawEntries[i]);
            }
            ++i;
        }
        IPathEntry[] newEntries = list.toArray(new IPathEntry[list.size()]);
        PathEntryManager.getDefault().setRawPathEntries(cproject, newEntries, new NullProgressMonitor());
        return this.createData(cfgDescription, baseData, false, false);
    }

    private CConfigurationData createData(ICConfigurationDescription cfgDescription, CConfigurationData fallbackData, boolean modifiedFlag, boolean useCache) throws CoreException {
        CConfigurationData dataToReturn;
        try {
            dataToReturn = this.createData(cfgDescription, useCache);
        }
        catch (Exception e) {
            if (fallbackData != null) {
                dataToReturn = fallbackData;
            }
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            throw ExceptionFactory.createCoreException(e);
        }
        fFactory.setModified(dataToReturn, modifiedFlag);
        return dataToReturn;
    }

    @Override
    public CConfigurationData createConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData baseData, boolean clone, IProgressMonitor monitor) throws CoreException {
        CfgData copy = new CfgData(cfgDescription.getId(), cfgDescription.getName(), baseData, clone);
        copy.setModified(false);
        return copy;
    }

    private CfgData createData(ICConfigurationDescription cfgDescription, boolean useCache) throws CoreException {
        IProject project = cfgDescription.getProjectDescription().getProject();
        CModelManager manager = CModelManager.getDefault();
        ICProject cproject = manager.create(project);
        PathEntryResolveInfo rInfo = PathEntryManager.getDefault().getResolveInfo(cproject, useCache);
        CfgData data = new CfgData(cfgDescription.getId(), cfgDescription.getName());
        data.initEmptyData();
        CDataUtil.adjustConfig(data, PathEntryConfigurationDataProvider.getDataFactory());
        PathEntryTranslator tr = new PathEntryTranslator(project, data);
        PathEntryTranslator.ReferenceSettingsInfo refInfo = tr.applyPathEntries(rInfo, 3);
        ICExternalSetting[] extSettings = refInfo.getExternalSettings();
        cfgDescription.removeExternalSettings();
        if (extSettings.length != 0) {
            int i = 0;
            while (i < extSettings.length) {
                ICExternalSetting setting = extSettings[i];
                cfgDescription.createExternalSetting(setting.getCompatibleLanguageIds(), setting.getCompatibleContentTypeIds(), setting.getCompatibleExtensions(), setting.getEntries());
                ++i;
            }
        }
        cproject.close();
        String[] ids = this.getIds(cfgDescription.get("org.eclipse.cdt.core.BinaryParser"));
        data.getTargetPlatformData().setBinaryParserIds(ids);
        ids = this.getIds(cfgDescription.get("org.eclipse.cdt.core.ErrorParser"));
        data.getBuildData().setErrorParserIDs(ids);
        data.setModified(false);
        return data;
    }

    private String[] getIds(ICConfigExtensionReference[] refs) {
        if (refs == null || refs.length == 0) {
            return new String[0];
        }
        String[] ids = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = refs[i].getID();
            ++i;
        }
        return ids;
    }

    @Override
    public CConfigurationData loadConfiguration(ICConfigurationDescription cfgDescription, IProgressMonitor monitor) throws CoreException {
        return this.createData(cfgDescription, null, false, true);
    }

    @Override
    public void removeConfiguration(ICConfigurationDescription cfgDescription, CConfigurationData data, IProgressMonitor monitor) {
    }

    @Override
    public void dataCached(ICConfigurationDescription cfgDescription, CConfigurationData data, IProgressMonitor monitor) {
        fFactory.setModified(data, false);
    }

    private static class CfgData
    extends CDefaultConfigurationData {
        public CfgData(String id, String name, CConfigurationData base, boolean clone) {
            super(id, name, base, fFactory, clone);
        }

        public CfgData(String id, String name) {
            super(id, name, fFactory);
        }
    }

    private static class PathEntryDataFactory
    extends CDataFactory {
        private PathEntryDataFactory() {
        }

        @Override
        public CConfigurationData createConfigurationdata(String id, String name, CConfigurationData base, boolean clone) {
            if (clone) {
                id = base.getId();
            } else if (id == null) {
                id = CDataUtil.genId(null);
            }
            return new CfgData(id, name, base, clone);
        }

        @Override
        public CFileData createFileData(CConfigurationData cfg, CResourceData base, CLanguageData base2, String id, boolean clone, IPath path) {
            if (id == null) {
                String string = id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
            }
            if (base.getType() == 8) {
                return new PathEntryFileData(id, path, (PathEntryFileData)base, cfg, (CDataFactory)this, clone);
            }
            return new PathEntryFileData(id, path, (PathEntryFolderData)base, base2, cfg, (CDataFactory)this);
        }

        @Override
        public CFolderData createFolderData(CConfigurationData cfg, CFolderData base, String id, boolean clone, IPath path) {
            if (id == null) {
                id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
            }
            return new PathEntryFolderData(id, path, (PathEntryFolderData)base, cfg, (CDataFactory)this, clone);
        }

        @Override
        public CLanguageData createLanguageData(CConfigurationData cfg, CResourceData rcBase, CLanguageData base, String id, boolean clone) {
            if (id == null) {
                id = clone ? base.getId() : CDataUtil.genId(rcBase.getId());
            }
            EntryStore store = rcBase.getType() == 4 ? ((PathEntryFolderData)rcBase).fStore : ((PathEntryFileData)rcBase).fStore;
            return new PathEntryLanguageData(id, base, store);
        }

        @Override
        public CLanguageData createLanguageData(CConfigurationData cfg, CResourceData rcBase, String id, String name, String languageId, int supportedEntryKinds, String[] rcTypes, boolean isContentTypes) {
            if (id == null) {
                id = CDataUtil.genId(rcBase.getId());
            }
            EntryStore store = rcBase.getType() == 4 ? ((PathEntryFolderData)rcBase).fStore : ((PathEntryFileData)rcBase).fStore;
            return new PathEntryLanguageData(id, name, languageId, supportedEntryKinds, rcTypes, isContentTypes, store);
        }
    }

    private static class PathEntryFileData
    extends CDefaultFileData {
        private EntryStore fStore;

        public PathEntryFileData(String id, IPath path, PathEntryFileData base, CConfigurationData cfg, CDataFactory factory, boolean clone) {
            super(id, path, cfg, factory);
            this.fStore = new EntryStore(base.fStore, true);
            this.copyDataFrom(base, clone);
        }

        public PathEntryFileData(String id, IPath path, PathEntryFolderData base, CLanguageData baseLangData, CConfigurationData cfgData, CDataFactory factory) {
            super(id, path, cfgData, factory);
            this.fStore = new EntryStore(base.fStore, true);
            this.copyDataFrom(base, baseLangData);
        }
    }

    private static class PathEntryFolderData
    extends CDefaultFolderData {
        private EntryStore fStore;

        public PathEntryFolderData(String id, IPath path, PathEntryFolderData base, CConfigurationData cfgData, CDataFactory factory, boolean clone) {
            super(id, path, cfgData, factory);
            this.fStore = base != null ? new EntryStore(base.fStore, true) : new EntryStore(true);
            this.copyDataFrom(base, clone);
        }
    }

    private static class PathEntryLanguageData
    extends CDefaultLanguageData {
        public PathEntryLanguageData(String id, CLanguageData base, EntryStore store) {
            this.fId = id;
            this.fStore = store;
            this.copySettingsFrom(base);
        }

        public PathEntryLanguageData(String id, String name, String languageId, int kinds, String[] ids, boolean isContentTypes, EntryStore store) {
            super(id, languageId, ids, isContentTypes);
            this.fStore = store;
            this.fName = name;
            this.fSupportedKinds = kinds;
        }

        @Override
        protected EntryStore createStore() {
            return this.fStore;
        }

        @Override
        protected EntryStore createStore(CLanguageData data) {
            return this.fStore;
        }
    }
}

