/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.parser.AbstractParserLogService;
import org.eclipse.cdt.internal.core.model.DebugLogConstants;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.util.Canceler;
import org.eclipse.cdt.internal.core.util.ICancelable;
import org.eclipse.cdt.internal.core.util.ICanceler;
import org.eclipse.core.runtime.Platform;

public class ParserLogService
extends AbstractParserLogService
implements ICanceler {
    private final DebugLogConstants topic;
    private final boolean fIsTracing;
    private final boolean fIsTracingExceptions;
    private final ICanceler fCanceler;

    public ParserLogService(DebugLogConstants constant) {
        this(constant, new Canceler());
    }

    public ParserLogService(DebugLogConstants constant, ICanceler canceler) {
        if (canceler == null) {
            throw new NullPointerException();
        }
        this.topic = constant;
        if (CCorePlugin.getDefault() == null) {
            this.fIsTracingExceptions = false;
            this.fIsTracing = false;
        } else {
            this.fIsTracingExceptions = Util.PARSER_EXCEPTIONS;
            this.fIsTracing = Util.isActive(this.topic);
        }
        this.fCanceler = canceler;
    }

    @Override
    public void traceLog(String message) {
        Util.debugLog(message, this.topic);
    }

    @Override
    public boolean isTracing(String option) {
        return Boolean.parseBoolean(Platform.getDebugOption(option));
    }

    @Override
    public void traceLog(String option, String message) {
        if (this.isTracing(option)) {
            System.out.println(message);
        }
    }

    @Override
    public void errorLog(String message) {
        Util.log(message, ICLogConstants.CDT);
    }

    @Override
    public boolean isTracing() {
        return this.fIsTracing;
    }

    @Override
    public boolean isTracingExceptions() {
        return this.fIsTracingExceptions;
    }

    @Override
    public void setCancelable(ICancelable cancelable) {
        this.fCanceler.setCancelable(cancelable);
    }

    @Override
    public void setCanceled(boolean value) {
        this.fCanceler.setCanceled(value);
    }

    @Override
    public boolean isCanceled() {
        return this.fCanceler.isCanceled();
    }
}

