/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.BinaryParserConfig;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;

public class BinaryRunner {
    private final ICProject cproject;
    private final Job runnerJob;
    private IOutputEntry[] entries = new IOutputEntry[0];
    private boolean isStopped = false;

    public BinaryRunner(IProject prj) {
        this.cproject = CModelManager.getDefault().create(prj);
        this.runnerJob = this.createRunnerJob();
        try {
            this.entries = this.cproject.getOutputEntries();
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    private Job createRunnerJob() {
        String taskName = CCorePlugin.getResourceString("CoreModel.BinaryRunner.Binary_Search_Thread");
        taskName = String.valueOf(taskName) + " (" + this.cproject.getElementName() + ")";
        Job job = new Job(taskName){

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        if (BinaryRunner.this.cproject == null || BinaryRunner.this.entries.length == 0 || monitor.isCanceled()) {
                            status = Status.CANCEL_STATUS;
                        } else {
                            monitor.beginTask(this.getName(), -1);
                            BinaryContainer vbin = (BinaryContainer)BinaryRunner.this.cproject.getBinaryContainer();
                            ArchiveContainer vlib = (ArchiveContainer)BinaryRunner.this.cproject.getArchiveContainer();
                            vlib.removeChildren();
                            vbin.removeChildren();
                            BinaryParserConfig[] parsers = CModelManager.getDefault().getBinaryParser(BinaryRunner.this.cproject.getProject());
                            if (parsers.length > 0) {
                                BinaryRunner.this.cproject.getProject().accept((IResourceProxyVisitor)new Visitor(monitor), 1);
                            }
                            if (!monitor.isCanceled()) {
                                BinaryRunnerOperation op = new BinaryRunnerOperation(BinaryRunner.this.cproject);
                                op.runOperation(monitor);
                            }
                        }
                    }
                    catch (CoreException e) {
                        status = Status.CANCEL_STATUS;
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        job.setPriority(30);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Job job = this.runnerJob;
        synchronized (job) {
            if (!this.isStopped) {
                this.runnerJob.schedule();
            }
        }
    }

    public void waitIfRunning() {
        try {
            Job currentJob = Job.getJobManager().currentJob();
            if (!this.runnerJob.equals(currentJob)) {
                this.runnerJob.join();
            }
        }
        catch (IllegalStateException | InterruptedException e) {
            CCorePlugin.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Job job = this.runnerJob;
        synchronized (job) {
            this.isStopped = true;
            this.runnerJob.cancel();
        }
    }

    class BinaryRunnerOperation
    extends CModelOperation {
        BinaryRunnerOperation(ICProject cproj) {
            super(cproj);
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        protected void executeOperation() throws CModelException {
            ICProject cproj = (ICProject)this.getElementsToProcess()[0];
            IParent[] containers = new IParent[]{cproj.getBinaryContainer(), cproj.getArchiveContainer()};
            CModelManager factory = CModelManager.getDefault();
            CModel root = factory.getCModel();
            CElementDelta cdelta = new CElementDelta(root);
            cdelta.changed(cproj, 1);
            IParent[] iParentArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IParent container = iParentArray[n2];
                if (this.fMonitor.isCanceled()) {
                    return;
                }
                ICElement[] children = container.getChildren();
                if (children.length > 0) {
                    cdelta.added((ICElement)((Object)container));
                    ICElement[] iCElementArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICElement element = iCElementArray[n4];
                        cdelta.added(element);
                        ++n4;
                    }
                }
                ++n2;
            }
            this.addDelta(cdelta);
        }
    }

    private class Visitor
    implements IResourceProxyVisitor {
        private final IProgressMonitor vMonitor;
        private final IProject project;
        private final IContentType textContentType;

        public Visitor(IProgressMonitor monitor) {
            this.vMonitor = monitor;
            this.project = BinaryRunner.this.cproject.getProject();
            IContentTypeManager mgr = Platform.getContentTypeManager();
            this.textContentType = mgr.getContentType("org.eclipse.core.runtime.text");
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IContentType contentType;
            if (this.vMonitor.isCanceled()) {
                return false;
            }
            this.vMonitor.worked(1);
            if (proxy.getType() != 1) {
                return true;
            }
            String name = proxy.getName();
            if (name.contains(".") && (contentType = CCorePlugin.getContentType(this.project, name)) != null && this.textContentType != null) {
                if (contentType.isKindOf(this.textContentType)) {
                    return true;
                }
                if (this.textContentType.isAssociatedWith(name)) {
                    return true;
                }
            }
            this.vMonitor.subTask(name);
            IPath path = proxy.requestFullPath();
            if (path != null) {
                IOutputEntry[] iOutputEntryArray = BinaryRunner.this.entries;
                int n = iOutputEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IOutputEntry entrie = iOutputEntryArray[n2];
                    if (this.isOnOutputEntry(entrie, path)) {
                        IFile file = (IFile)proxy.requestResource();
                        CModelManager factory = CModelManager.getDefault();
                        IBinaryParser.IBinaryFile bin = factory.createBinaryFile(file);
                        if (bin != null) {
                            factory.create(file, bin, BinaryRunner.this.cproject);
                        }
                        return true;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private boolean isOnOutputEntry(IOutputEntry entry, IPath path) {
            return entry.getPath().isPrefixOf(path) && !CoreModelUtil.isExcluded(path, entry.fullExclusionPatternChars());
        }
    }
}

