/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.ArchiveInfo;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Archive
extends Openable
implements IArchive {
    IBinaryParser.IBinaryArchive binaryArchive;

    public Archive(ICElement parent, IFile file, IBinaryParser.IBinaryArchive ar) {
        super(parent, (IResource)file, 18);
        this.binaryArchive = ar;
    }

    public Archive(ICElement parent, IPath path, IBinaryParser.IBinaryArchive ar) {
        super(parent, path, 18);
        this.binaryArchive = ar;
    }

    @Override
    public IBinary[] getBinaries() throws CModelException {
        ICElement[] e = this.getChildren();
        IBinary[] b = new IBinary[e.length];
        System.arraycopy(e, 0, b, 0, e.length);
        return b;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public CElementInfo createElementInfo() {
        return new ArchiveInfo(this);
    }

    protected ArchiveInfo getArchiveInfo() throws CModelException {
        return (ArchiveInfo)this.getElementInfo();
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        return this.computeChildren(info, underlyingResource);
    }

    public boolean computeChildren(OpenableInfo info, IResource res) {
        IBinaryParser.IBinaryArchive ar = this.getBinaryArchive();
        if (ar != null) {
            IBinaryParser.IBinaryObject[] objects;
            IBinaryParser.IBinaryObject[] iBinaryObjectArray = objects = ar.getObjects();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryParser.IBinaryObject obj = iBinaryObjectArray[n2];
                Binary binary = new Binary((ICElement)this, ar.getPath().append(obj.getName()), obj);
                info.addChild(binary);
                ++n2;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (IBinaryParser.IBinaryArchive.class.equals(adapter)) {
            return adapter.cast(this.getBinaryArchive());
        }
        return super.getAdapter(adapter);
    }

    IBinaryParser.IBinaryArchive getBinaryArchive() {
        return this.binaryArchive;
    }

    @Override
    public boolean exists() {
        IResource res = this.getResource();
        if (res != null) {
            return res.exists();
        }
        return super.exists();
    }

    @Override
    protected void closing(Object info) throws CModelException {
        ICProject cproject = this.getCProject();
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(cproject);
        if (pinfo != null && pinfo.vLib != null) {
            pinfo.vLib.removeChild(this);
        }
        super.closing(info);
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        return null;
    }

    @Override
    public String getHandleMemento() {
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue(false, "Should not be called");
        return '\u0000';
    }
}

