/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class APathEntry
extends PathEntry {
    public static IPath[] NO_EXCLUSION_PATTERNS = new IPath[0];
    IPath[] exclusionPatterns;
    IPath basePath;
    IPath baseRef;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    char[][] fullCharExclusionPatterns = UNINIT_PATTERNS;

    public APathEntry(int kind, IPath basePath, IPath baseRef, IPath path, IPath[] exclusionPatterns, boolean isExported) {
        super(kind, path, isExported);
        this.basePath = basePath == null ? Path.EMPTY : basePath;
        this.baseRef = baseRef == null ? Path.EMPTY : baseRef;
        this.exclusionPatterns = exclusionPatterns == null ? NO_EXCLUSION_PATTERNS : exclusionPatterns;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IPath getBasePath() {
        return this.basePath;
    }

    public IPath getBaseReference() {
        return this.baseRef;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullCharExclusionPatterns[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullCharExclusionPatterns;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.basePath == null ? 0 : this.basePath.hashCode());
        result = 31 * result + (this.baseRef == null ? 0 : this.baseRef.hashCode());
        result = 31 * result + Arrays.hashCode(this.exclusionPatterns);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof APathEntry) {
            APathEntry otherEntry = (APathEntry)obj;
            if (!super.equals(otherEntry)) {
                return false;
            }
            IPath[] otherExcludes = otherEntry.getExclusionPatterns();
            if (this.exclusionPatterns != otherExcludes) {
                int excludeLength;
                int n = excludeLength = this.exclusionPatterns == null ? 0 : this.exclusionPatterns.length;
                if (otherExcludes.length != excludeLength) {
                    return false;
                }
                HashSet<String> excludeSet = new HashSet<String>();
                HashSet<String> otherSet = new HashSet<String>();
                int i = 0;
                while (i < excludeLength) {
                    if (this.exclusionPatterns[i] != otherExcludes[i]) {
                        excludeSet.add(this.exclusionPatterns[i].toString());
                        otherSet.add(otherExcludes[i].toString());
                    }
                    ++i;
                }
                if (!excludeSet.equals(otherSet)) {
                    return false;
                }
            }
            IPath otherBasePath = otherEntry.getBasePath();
            if (this.basePath != null && otherBasePath != null && !this.basePath.equals(otherBasePath)) {
                return false;
            }
            IPath otherBaseRef = otherEntry.getBaseReference();
            return this.baseRef == null || otherBaseRef == null || this.baseRef.equals(otherBaseRef);
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.basePath != null && !this.basePath.isEmpty()) {
            sb.append(" base-path:").append(this.basePath.toString());
        }
        if (this.baseRef != null && !this.baseRef.isEmpty()) {
            sb.append(" base-ref:").append(this.baseRef.toString());
        }
        return sb.toString();
    }
}

